/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.LifeSupport;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.Mind;
import org.mars_sim.msp.core.person.medical.MedicalAid;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.time.EarthClock;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.Medical;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleOperator;

public class Person
extends Unit
implements VehicleOperator,
Serializable {
    private static transient Logger logger = Logger.getLogger(Person.class.getName());
    public static final String ASSOCIATED_SETTLEMENT_EVENT = "associated settlement";
    public static final String INSETTLEMENT = "In Settlement";
    public static final String INVEHICLE = "In Vehicle";
    public static final String OUTSIDE = "Outside";
    public static final String BURIED = "Buried";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    private static final double BASE_CAPACITY = 60.0;
    private NaturalAttributeManager attributes;
    private Mind mind;
    private PhysicalCondition health;
    private boolean isBuried;
    private String gender;
    private EarthClock birthTimeStamp;
    private Settlement associatedSettlement;
    private Map<Science, Double> scientificAchievement;
    private double xLoc = 0.0;
    private double yLoc = 0.0;

    public Person(String name, String gender, Settlement settlement) {
        super(name, settlement.getCoordinates());
        this.gender = gender;
        String timeString = this.createTimeString();
        this.birthTimeStamp = new EarthClock(timeString);
        this.attributes = new NaturalAttributeManager(this);
        this.mind = new Mind(this);
        this.isBuried = false;
        this.health = new PhysicalCondition(this);
        this.scientificAchievement = new HashMap<Science, Double>(0);
        this.setBaseMass(70.0);
        int strength = this.attributes.getAttribute("Strength");
        this.getInventory().addGeneralCapacity(60.0 + (double)strength);
        settlement.getInventory().storeUnit(this);
        BuildingManager.addToRandomBuilding(this, settlement);
        this.associatedSettlement = settlement;
    }

    private String createTimeString() {
        int year = 2003 + RandomUtil.getRandomInt(10) + RandomUtil.getRandomInt(10);
        int month = RandomUtil.getRandomInt(11) + 1;
        int day = month == 2 ? (year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? RandomUtil.getRandomInt(28) + 1 : RandomUtil.getRandomInt(27) + 1) : (month % 2 == 1 ? RandomUtil.getRandomInt(30) + 1 : RandomUtil.getRandomInt(29) + 1);
        int hour = RandomUtil.getRandomInt(23);
        int minute = RandomUtil.getRandomInt(59);
        int second = RandomUtil.getRandomInt(59);
        return month + "/" + day + "/" + year + " " + hour + ":" + minute + ":" + second;
    }

    public String getLocationSituation() {
        String location = null;
        if (this.isBuried) {
            location = BURIED;
        } else {
            Unit container = this.getContainerUnit();
            if (container == null) {
                location = OUTSIDE;
            } else if (container instanceof Settlement) {
                location = INSETTLEMENT;
            } else if (container instanceof Vehicle) {
                location = INVEHICLE;
            }
        }
        return location;
    }

    public double getXLocation() {
        return this.xLoc;
    }

    public void setXLocation(double xLocation) {
        this.xLoc = xLocation;
    }

    public double getYLocation() {
        return this.yLoc;
    }

    public void setYLocation(double yLocation) {
        this.yLoc = yLocation;
    }

    public Settlement getSettlement() {
        if (INSETTLEMENT.equals(this.getLocationSituation())) {
            return (Settlement)this.getContainerUnit();
        }
        return null;
    }

    public Vehicle getVehicle() {
        if (INVEHICLE.equals(this.getLocationSituation())) {
            return (Vehicle)this.getContainerUnit();
        }
        return null;
    }

    @Override
    public void setContainerUnit(Unit containerUnit) {
        super.setContainerUnit(containerUnit);
        MedicalAid aid = this.getAccessibleAid();
        if (aid != null && this.health.canTreatProblems(aid)) {
            this.health.requestAllTreatments(aid);
        }
    }

    public void buryBody() {
        Unit containerUnit = this.getContainerUnit();
        if (containerUnit != null) {
            containerUnit.getInventory().retrieveUnit(this);
        }
        this.isBuried = true;
        this.setAssociatedSettlement(null);
    }

    void setDead() {
        this.mind.setInactive();
        this.buryBody();
    }

    @Override
    public void timePassing(double time) {
        if (this.health.getDeathDetails() == null) {
            PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
            LifeSupport support = this.getLifeSupport();
            if (this.health.timePassing(time, support, config)) {
                this.mind.timePassing(time);
            } else {
                this.setDead();
            }
        }
    }

    public NaturalAttributeManager getNaturalAttributeManager() {
        return this.attributes;
    }

    public double getPerformanceRating() {
        return this.health.getPerformanceFactor();
    }

    public PhysicalCondition getPhysicalCondition() {
        return this.health;
    }

    MedicalAid getAccessibleAid() {
        Vehicle vehicle;
        Settlement settlement;
        List<Building> infirmaries;
        MedicalAid found = null;
        String location = this.getLocationSituation();
        if (location.equals(INSETTLEMENT) && (infirmaries = (settlement = this.getSettlement()).getBuildingManager().getBuildings("Medical Care")).size() > 0) {
            int rand = RandomUtil.getRandomInt(infirmaries.size() - 1);
            Building foundBuilding = infirmaries.get(rand);
            found = (MedicalAid)((Object)foundBuilding.getFunction("Medical Care"));
        }
        if (location.equals(INVEHICLE) && (vehicle = this.getVehicle()) instanceof Medical) {
            found = ((Medical)((Object)vehicle)).getSickBay();
        }
        return found;
    }

    public Mind getMind() {
        return this.mind;
    }

    public int getAge() {
        EarthClock simClock = Simulation.instance().getMasterClock().getEarthClock();
        int age = simClock.getYear() - this.birthTimeStamp.getYear() - 1;
        if (simClock.getMonth() >= this.birthTimeStamp.getMonth() && simClock.getMonth() >= this.birthTimeStamp.getMonth()) {
            ++age;
        }
        return age;
    }

    public String getBirthDate() {
        return this.birthTimeStamp.getDateString();
    }

    private LifeSupport getLifeSupport() {
        ConcurrentLinkedQueue<Unit> lifeSupportUnits = new ConcurrentLinkedQueue<Unit>();
        for (Unit container = this.getContainerUnit(); container != null; container = container.getContainerUnit()) {
            if (!(container instanceof LifeSupport)) continue;
            lifeSupportUnits.add(container);
        }
        for (Unit unit : this.getInventory().getContainedUnits()) {
            if (!(unit instanceof LifeSupport)) continue;
            lifeSupportUnits.add(unit);
        }
        for (LifeSupport lifeSupport : lifeSupportUnits) {
            try {
                if (!lifeSupport.lifeSupportCheck()) continue;
                return lifeSupport;
            }
            catch (Exception e) {
            }
        }
        Iterator<Unit> i = lifeSupportUnits.iterator();
        if (i.hasNext()) {
            return (LifeSupport)((Object)i.next());
        }
        return null;
    }

    public void consumeFood(double amount, boolean takeFromInv) {
        if (takeFromInv) {
            this.health.consumeFood(amount, this.getContainerUnit());
        } else {
            this.health.consumeFood(amount);
        }
    }

    public String getGender() {
        return this.gender;
    }

    public Collection<Person> getLocalGroup() {
        ConcurrentLinkedQueue<Person> localGroup = new ConcurrentLinkedQueue<Person>();
        if (this.getLocationSituation().equals(INSETTLEMENT)) {
            String lifeSupportName;
            Building building = BuildingManager.getBuilding(this);
            if (building != null && building.hasFunction(lifeSupportName = "Life Support")) {
                org.mars_sim.msp.core.structure.building.function.LifeSupport lifeSupport = (org.mars_sim.msp.core.structure.building.function.LifeSupport)building.getFunction(lifeSupportName);
                localGroup = new ConcurrentLinkedQueue<Person>(lifeSupport.getOccupants());
            }
        } else if (this.getLocationSituation().equals(INVEHICLE)) {
            Crewable crewableVehicle = (Crewable)((Object)this.getVehicle());
            localGroup = new ConcurrentLinkedQueue<Person>(crewableVehicle.getCrew());
        }
        if (localGroup.contains(this)) {
            localGroup.remove(this);
        }
        return localGroup;
    }

    @Override
    public boolean isFitForOperatingVehicle() {
        return !this.health.hasSeriousMedicalProblems();
    }

    @Override
    public String getOperatorName() {
        return this.getName();
    }

    public Settlement getAssociatedSettlement() {
        return this.associatedSettlement;
    }

    public void setAssociatedSettlement(Settlement newSettlement) {
        if (this.associatedSettlement != newSettlement) {
            Settlement oldSettlement = this.associatedSettlement;
            this.associatedSettlement = newSettlement;
            this.fireUnitUpdate(ASSOCIATED_SETTLEMENT_EVENT, this.associatedSettlement);
            if (oldSettlement != null) {
                oldSettlement.fireUnitUpdate("remove associated person", this);
            }
            if (newSettlement != null) {
                newSettlement.fireUnitUpdate("add associated person", this);
            }
        }
    }

    public double getScientificAchievement(Science science) {
        double result = 0.0;
        if (this.scientificAchievement.containsKey(science)) {
            result = this.scientificAchievement.get(science);
        }
        return result;
    }

    public double getTotalScientificAchievement() {
        double result = 0.0;
        Iterator<Double> i = this.scientificAchievement.values().iterator();
        while (i.hasNext()) {
            result += i.next().doubleValue();
        }
        return result;
    }

    public void addScientificAchievement(double achievementCredit, Science science) {
        if (this.scientificAchievement.containsKey(science)) {
            achievementCredit += this.scientificAchievement.get(science).doubleValue();
        }
        this.scientificAchievement.put(science, achievementCredit);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.attributes.destroy();
        this.attributes = null;
        this.mind.destroy();
        this.mind = null;
        this.health.destroy();
        this.health = null;
        this.gender = null;
        this.birthTimeStamp = null;
        this.associatedSettlement = null;
        this.scientificAchievement.clear();
        this.scientificAchievement = null;
    }
}

