/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.LifeSupport;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.medical.Complaint;
import org.mars_sim.msp.core.person.medical.DeathInfo;
import org.mars_sim.msp.core.person.medical.HealthProblem;
import org.mars_sim.msp.core.person.medical.MedicalAid;
import org.mars_sim.msp.core.person.medical.MedicalEvent;
import org.mars_sim.msp.core.person.medical.MedicalManager;
import org.mars_sim.msp.core.person.medical.Medication;
import org.mars_sim.msp.core.resource.AmountResource;

public class PhysicalCondition
implements Serializable {
    private static Logger logger = Logger.getLogger(PhysicalCondition.class.getName());
    public static final String FATIGUE_EVENT = "fatigue event";
    public static final String HUNGER_EVENT = "hunger event";
    public static final String STRESS_EVENT = "stress event";
    public static final String PERFORMANCE_EVENT = "performance event";
    public static final String ILLNESS_EVENT = "illness event";
    public static final String DEATH_EVENT = "death event";
    private static int MIN_VALUE = 0;
    private static int MAX_VALUE = 1;
    public static final double ACCIDENT_STRESS = 40.0;
    private static final String ANXIETY_ATTACK = "Anxiety Attack";
    private DeathInfo deathDetails = null;
    private HashMap<Complaint, HealthProblem> problems;
    private HealthProblem serious;
    private double fatigue;
    private double hunger;
    private double stress;
    private double performance;
    private Person person;
    private boolean alive;
    private List<Medication> medicationList;

    public PhysicalCondition(Person newPerson) {
        this.person = newPerson;
        this.problems = new HashMap();
        this.performance = 1.0;
        this.fatigue = RandomUtil.getRandomDouble(1000.0);
        this.hunger = RandomUtil.getRandomDouble(1000.0);
        this.stress = RandomUtil.getRandomDouble(100.0);
        this.alive = true;
        this.medicationList = new ArrayList<Medication>();
    }

    private MedicalManager getMedicalManager() {
        return Simulation.instance().getMedicalManager();
    }

    boolean canTreatProblems(MedicalAid unit) {
        boolean result = false;
        Iterator<HealthProblem> iter = this.problems.values().iterator();
        while (iter.hasNext()) {
            if (!unit.canTreatProblem(iter.next())) continue;
            result = true;
        }
        return result;
    }

    void requestAllTreatments(MedicalAid aid) {
        for (HealthProblem prob : this.problems.values()) {
            if (!aid.canTreatProblem(prob)) continue;
            try {
                aid.requestTreatment(prob);
            }
            catch (Exception e) {}
        }
    }

    boolean timePassing(double time, LifeSupport support, PersonConfig config) {
        boolean illnessEvent = false;
        if (!this.problems.isEmpty()) {
            illnessEvent = true;
            ArrayList<Complaint> newProblems = new ArrayList<Complaint>();
            Iterator<HealthProblem> iter = this.problems.values().iterator();
            while (!this.isDead() && iter.hasNext()) {
                HealthProblem problem = iter.next();
                Complaint next = problem.timePassing(time, this);
                if (problem.getCured() || next != null) {
                    iter.remove();
                }
                if (next == null) continue;
                newProblems.add(next);
            }
            Iterator newIter = newProblems.iterator();
            while (newIter.hasNext()) {
                this.addMedicalComplaint((Complaint)newIter.next());
                illnessEvent = true;
            }
        }
        if (this.isDead()) {
            return false;
        }
        Complaint randomComplaint = this.getMedicalManager().getProbableComplaint(this.person, time);
        this.addMedicalComplaint(randomComplaint);
        if (randomComplaint != null) {
            illnessEvent = true;
        }
        try {
            if (this.consumeOxygen(support, PhysicalCondition.getOxygenConsumptionRate() * (time / 1000.0))) {
                logger.log(Level.SEVERE, this.person.getName() + " has insufficient oxygen.");
            }
            if (this.consumeWater(support, PhysicalCondition.getWaterConsumptionRate() * (time / 1000.0))) {
                logger.log(Level.SEVERE, this.person.getName() + " has insufficient water.");
            }
            if (this.requireAirPressure(support, config.getMinAirPressure())) {
                logger.log(Level.SEVERE, this.person.getName() + " has insufficient air pressure.");
            }
            if (this.requireTemperature(support, config.getMinTemperature(), config.getMaxTemperature())) {
                logger.log(Level.SEVERE, this.person.getName() + " has insufficient temperature.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this.person.getName() + " - Error in lifesupport needs: " + e.getMessage());
        }
        this.setFatigue(this.fatigue + time);
        this.setHunger(this.hunger + time);
        Iterator<Medication> i = this.medicationList.iterator();
        while (i.hasNext()) {
            Medication med = i.next();
            med.timePassing(time);
            if (med.isMedicated()) continue;
            i.remove();
        }
        if (this.stress == 100.0) {
            this.checkForStressBreakdown(config, time);
        }
        this.recalculate();
        if (illnessEvent) {
            this.person.fireUnitUpdate(ILLNESS_EVENT);
        }
        return !this.isDead();
    }

    public void addMedicalComplaint(Complaint complaint) {
        if (complaint != null && !this.problems.containsKey(complaint)) {
            HealthProblem problem = new HealthProblem(complaint, this.person, this.person.getAccessibleAid());
            this.problems.put(complaint, problem);
            this.recalculate();
        }
    }

    public void consumeFood(double amount, Unit container) {
        if (container == null) {
            throw new IllegalArgumentException("container is null");
        }
        AmountResource food = AmountResource.findAmountResource("food");
        double foodEaten = amount;
        double foodAvailable = container.getInventory().getAmountResourceStored(food, false);
        if (foodAvailable == 0.0) {
            throw new IllegalStateException("No food available.");
        }
        if (foodEaten > foodAvailable) {
            foodEaten = foodAvailable;
        }
        container.getInventory().retrieveAmountResource(food, foodEaten);
    }

    public void consumeFood(double amount) {
    }

    private boolean consumeOxygen(LifeSupport support, double amount) {
        double amountRecieved = support.provideOxygen(amount);
        return this.checkResourceConsumption(amountRecieved, amount / 2.0, MIN_VALUE, this.getMedicalManager().getSuffocation());
    }

    private boolean consumeWater(LifeSupport support, double amount) {
        double amountReceived = support.provideWater(amount);
        return this.checkResourceConsumption(amountReceived, amount / 2.0, MIN_VALUE, this.getMedicalManager().getDehydration());
    }

    private boolean checkResourceConsumption(double actual, double required, int bounds, Complaint complaint) {
        boolean newProblem = false;
        if (bounds == MIN_VALUE && actual < required) {
            newProblem = true;
        }
        if (bounds == MAX_VALUE && actual > required) {
            newProblem = true;
        }
        if (newProblem) {
            this.addMedicalComplaint(complaint);
            this.person.fireUnitUpdate(ILLNESS_EVENT);
        } else {
            HealthProblem illness = this.problems.get(complaint);
            if (illness != null) {
                illness.startRecovery();
                this.person.fireUnitUpdate(ILLNESS_EVENT);
            }
        }
        return newProblem;
    }

    private boolean requireAirPressure(LifeSupport support, double pressure) {
        return this.checkResourceConsumption(support.getAirPressure(), pressure, MIN_VALUE, this.getMedicalManager().getDecompression());
    }

    private boolean requireTemperature(LifeSupport support, double minTemperature, double maxTemperature) {
        boolean freeze = this.checkResourceConsumption(support.getTemperature(), minTemperature, MIN_VALUE, this.getMedicalManager().getFreezing());
        boolean hot = this.checkResourceConsumption(support.getTemperature(), maxTemperature, MAX_VALUE, this.getMedicalManager().getHeatStroke());
        return freeze || hot;
    }

    public DeathInfo getDeathDetails() {
        return this.deathDetails;
    }

    public double getFatigue() {
        return this.fatigue;
    }

    public double getPerformanceFactor() {
        return this.performance;
    }

    private void setPerformanceFactor(double newPerformance) {
        if (newPerformance != this.performance) {
            this.performance = newPerformance;
            this.person.fireUnitUpdate(PERFORMANCE_EVENT);
        }
    }

    Person getPerson() {
        return this.person;
    }

    public void setFatigue(double newFatigue) {
        if (this.fatigue != newFatigue) {
            this.fatigue = newFatigue;
            this.person.fireUnitUpdate(FATIGUE_EVENT);
        }
    }

    public double getHunger() {
        return this.hunger;
    }

    public void setHunger(double newHunger) {
        if (this.hunger != newHunger) {
            HealthProblem illness;
            this.hunger = newHunger;
            PersonConfig personConfig = SimulationConfig.instance().getPersonConfiguration();
            double starvationTime = 0.0;
            try {
                starvationTime = personConfig.getStarvationStartTime() * 1000.0;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            Complaint starvation = this.getMedicalManager().getStarvation();
            if (this.hunger > starvationTime) {
                if (!this.problems.containsKey(starvation)) {
                    this.addMedicalComplaint(starvation);
                    this.person.fireUnitUpdate(ILLNESS_EVENT);
                }
            } else if (this.hunger == 0.0 && (illness = this.problems.get(starvation)) != null) {
                illness.startRecovery();
                this.person.fireUnitUpdate(ILLNESS_EVENT);
            }
            this.person.fireUnitUpdate(HUNGER_EVENT);
        }
    }

    public double getStress() {
        return this.stress;
    }

    public void setStress(double newStress) {
        if (this.stress != newStress) {
            this.stress = newStress;
            if (this.stress > 100.0) {
                this.stress = 100.0;
            } else if (this.stress < 0.0) {
                this.stress = 0.0;
            }
            this.person.fireUnitUpdate(STRESS_EVENT);
        }
    }

    private void checkForStressBreakdown(PersonConfig config, double time) {
        try {
            if (!this.problems.containsKey(ANXIETY_ATTACK)) {
                int resilience = this.person.getNaturalAttributeManager().getAttribute("Stress Resilience");
                double resilienceModifier = (double)(100 - resilience) / 50.0;
                if (RandomUtil.lessThanRandPercent(config.getStressBreakdownChance() * time * resilienceModifier)) {
                    Complaint anxietyAttack = this.getMedicalManager().getComplaintByName(ANXIETY_ATTACK);
                    if (anxietyAttack != null) {
                        this.addMedicalComplaint(anxietyAttack);
                        this.person.fireUnitUpdate(ILLNESS_EVENT);
                        logger.info(this.person.getName() + " has an anxiety attack.");
                    } else {
                        logger.log(Level.SEVERE, "Could not find 'Anxiety Attack' medical complaint in 'conf/medical.xml'");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem reading 'stress-breakdown-chance' element in 'conf/people.xml': " + e.getMessage());
        }
    }

    public void setDead(HealthProblem illness) {
        this.setFatigue(0.0);
        this.setHunger(0.0);
        this.setPerformanceFactor(0.0);
        this.setStress(0.0);
        this.alive = false;
        this.deathDetails = new DeathInfo(this.person);
        logger.severe(this.person + " dies due to " + illness);
        MedicalEvent event = new MedicalEvent(this.person, illness, "Person Dies");
        Simulation.instance().getEventManager().registerNewEvent(event);
        this.person.fireUnitUpdate(DEATH_EVENT);
    }

    public boolean isDead() {
        return !this.alive;
    }

    public String getHealthSituation() {
        String situation = "Well";
        if (this.serious != null) {
            situation = this.isDead() ? "Dead, " + this.serious.getIllness().getName() : this.serious.getSituation();
        }
        return situation;
    }

    public Complaint getMostSerious() {
        return this.serious.getIllness();
    }

    public Collection<HealthProblem> getProblems() {
        return this.problems.values();
    }

    private void recalculate() {
        double tempPerformance = 1.0;
        this.serious = null;
        for (HealthProblem problem : this.problems.values()) {
            double factor = problem.getPerformanceFactor();
            if (factor < tempPerformance) {
                tempPerformance = factor;
            }
            if (this.serious != null && this.serious.getIllness().getSeriousness() >= problem.getIllness().getSeriousness()) continue;
            this.serious = problem;
        }
        if (this.fatigue > 1000.0) {
            tempPerformance -= (this.fatigue - 1000.0) * 3.0E-4;
        }
        if (this.hunger > 1000.0) {
            tempPerformance -= (this.hunger - 1000.0) * 1.0E-4;
        }
        if (this.stress >= 80.0) {
            tempPerformance -= (this.stress - 80.0) * 0.02;
        }
        if (tempPerformance < 0.0) {
            tempPerformance = 0.0;
        }
        this.setPerformanceFactor(tempPerformance);
    }

    public boolean hasSeriousMedicalProblems() {
        boolean result = false;
        Iterator<HealthProblem> meds = this.getProblems().iterator();
        while (meds.hasNext()) {
            if (meds.next().getIllness().getSeriousness() < 50) continue;
            result = true;
        }
        return result;
    }

    public static double getOxygenConsumptionRate() {
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        return config.getOxygenConsumptionRate();
    }

    public static double getWaterConsumptionRate() {
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        return config.getWaterConsumptionRate();
    }

    public static double getFoodConsumptionRate() {
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        return config.getFoodConsumptionRate();
    }

    public List<Medication> getMedicationList() {
        return new ArrayList<Medication>(this.medicationList);
    }

    public boolean hasMedication(String medicationName) {
        if (medicationName == null) {
            throw new IllegalArgumentException("medicationName is null");
        }
        boolean result = false;
        Iterator<Medication> i = this.medicationList.iterator();
        while (i.hasNext()) {
            if (!medicationName.equals(i.next().getName())) continue;
            result = true;
        }
        return result;
    }

    public void addMedication(Medication medication) {
        if (medication == null) {
            throw new IllegalArgumentException("medication is null");
        }
        this.medicationList.add(medication);
    }

    public void destroy() {
        this.deathDetails = null;
        this.problems.clear();
        this.problems = null;
        this.serious = null;
        this.person = null;
        this.medicationList.clear();
        this.medicationList = null;
    }
}

