/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai;

import java.io.Serializable;

public class Skill
implements Serializable {
    public static final String DRIVING = "Driving";
    public static final String BOTANY = "Botany";
    public static final String MECHANICS = "Mechanics";
    public static final String EVA_OPERATIONS = "EVA Operations";
    public static final String AREOLOGY = "Areology";
    public static final String MEDICAL = "Medicine";
    public static final String COOKING = "Cooking";
    public static final String TRADING = "Trading";
    public static final String MATERIALS_SCIENCE = "Materials Science";
    public static final String CONSTRUCTION = "Construction";
    public static final String BIOLOGY = "Biology";
    public static final String ASTRONOMY = "Astronomy";
    public static final String CHEMISTRY = "Chemistry";
    public static final String PHYSICS = "Physics";
    public static final String MATHEMATICS = "Mathematics";
    public static final String METEOROLOGY = "Meteorology";
    private int level;
    private double experiencePoints;
    private double neededExperiencePoints;
    private String name;

    public Skill(String name) {
        this.name = name;
        this.level = 0;
        this.experiencePoints = 0.0;
        this.neededExperiencePoints = 25.0;
    }

    public Skill(String name, int level) {
        this(name);
        this.setLevel(level);
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    void setLevel(int newLevel) {
        this.level = newLevel;
        this.experiencePoints = 0.0;
        this.neededExperiencePoints = 25.0 * Math.pow(2.0, newLevel);
    }

    void addExperience(double newPoints) {
        this.experiencePoints += newPoints;
        if (this.experiencePoints >= this.neededExperiencePoints) {
            this.experiencePoints -= this.neededExperiencePoints;
            this.neededExperiencePoints *= 2.0;
            ++this.level;
        }
    }
}

