/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai;

import java.io.Serializable;
import java.util.Hashtable;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.Skill;

public class SkillManager
implements Serializable {
    private Person person;
    private Hashtable<String, Skill> skills;

    SkillManager(Person person) {
        String[] startingSkills;
        this.person = person;
        this.skills = new Hashtable();
        for (String startingSkill : startingSkills = new String[]{"Driving", "Botany", "Mechanics", "EVA Operations", "Areology", "Medicine", "Cooking", "Trading", "Materials Science", "Construction", "Biology", "Astronomy", "Chemistry", "Physics", "Mathematics", "Meteorology"}) {
            int skillLevel = this.getInitialSkillLevel(0, 50);
            Skill newSkill = new Skill(startingSkill);
            newSkill.setLevel(skillLevel);
            this.addNewSkill(newSkill);
        }
    }

    private int getInitialSkillLevel(int level, int chance) {
        if (RandomUtil.lessThanRandPercent(chance)) {
            return this.getInitialSkillLevel(level + 1, chance / 2);
        }
        return level;
    }

    public int getSkillNum() {
        return this.skills.size();
    }

    public String[] getKeys() {
        Object[] tempArray = this.skills.keySet().toArray();
        String[] keyArray = new String[tempArray.length];
        for (int x = 0; x < tempArray.length; ++x) {
            keyArray[x] = (String)tempArray[x];
        }
        return keyArray;
    }

    public boolean hasSkill(String skillName) {
        return this.skills.containsKey(skillName);
    }

    public int getSkillLevel(String skillName) {
        int result = 0;
        if (this.skills.containsKey(skillName)) {
            result = this.skills.get(skillName).getLevel();
        }
        return result;
    }

    public int getEffectiveSkillLevel(String skillName) {
        int skill = this.getSkillLevel(skillName);
        double performance = this.person.getPerformanceRating();
        int result = (int)Math.round(performance * (double)skill);
        return result;
    }

    public void addNewSkill(Skill newSkill) {
        String skillName = newSkill.getName();
        if (this.hasSkill(skillName)) {
            this.skills.get(skillName).setLevel(newSkill.getLevel());
        } else {
            this.skills.put(newSkill.getName(), newSkill);
        }
    }

    public void addExperience(String skillName, double experiencePoints) {
        if (this.hasSkill(skillName)) {
            this.skills.get(skillName).addExperience(experiencePoints);
        } else {
            this.addNewSkill(new Skill(skillName));
            this.addExperience(skillName, experiencePoints);
        }
    }

    public void destroy() {
        this.person = null;
        this.skills.clear();
        this.skills = null;
    }
}

