/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Lab;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.AreologyStudyFieldMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.CollectIce;
import org.mars_sim.msp.core.person.ai.mission.CollectRegolith;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.Exploration;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.task.AssistScientificStudyResearcher;
import org.mars_sim.msp.core.person.ai.task.CompileScientificStudyResults;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.person.ai.task.DigLocalRegolith;
import org.mars_sim.msp.core.person.ai.task.InviteStudyCollaborator;
import org.mars_sim.msp.core.person.ai.task.PeerReviewStudyPaper;
import org.mars_sim.msp.core.person.ai.task.PerformLaboratoryResearch;
import org.mars_sim.msp.core.person.ai.task.ProposeScientificStudy;
import org.mars_sim.msp.core.person.ai.task.ResearchScientificStudy;
import org.mars_sim.msp.core.person.ai.task.RespondToStudyInvitation;
import org.mars_sim.msp.core.person.ai.task.StudyFieldSamples;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.Research;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class Areologist
extends Job
implements Serializable {
    private static Logger logger = Logger.getLogger(Areologist.class.getName());

    public Areologist() {
        super("Areologist");
        this.jobTasks.add(AssistScientificStudyResearcher.class);
        this.jobTasks.add(CompileScientificStudyResults.class);
        this.jobTasks.add(DigLocalRegolith.class);
        this.jobTasks.add(DigLocalIce.class);
        this.jobTasks.add(InviteStudyCollaborator.class);
        this.jobTasks.add(PeerReviewStudyPaper.class);
        this.jobTasks.add(PerformLaboratoryResearch.class);
        this.jobTasks.add(ProposeScientificStudy.class);
        this.jobTasks.add(ResearchScientificStudy.class);
        this.jobTasks.add(RespondToStudyInvitation.class);
        this.jobTasks.add(StudyFieldSamples.class);
        this.jobMissionStarts.add(Exploration.class);
        this.jobMissionJoins.add(Exploration.class);
        this.jobMissionStarts.add(CollectIce.class);
        this.jobMissionJoins.add(CollectIce.class);
        this.jobMissionStarts.add(CollectRegolith.class);
        this.jobMissionJoins.add(CollectRegolith.class);
        this.jobMissionStarts.add(TravelToSettlement.class);
        this.jobMissionJoins.add(TravelToSettlement.class);
        this.jobMissionStarts.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(RescueSalvageVehicle.class);
        this.jobMissionStarts.add(Mining.class);
        this.jobMissionJoins.add(Mining.class);
        this.jobMissionJoins.add(BuildingConstructionMission.class);
        this.jobMissionJoins.add(BuildingSalvageMission.class);
        this.jobMissionStarts.add(AreologyStudyFieldMission.class);
        this.jobMissionJoins.add(AreologyStudyFieldMission.class);
        this.jobMissionStarts.add(EmergencySupplyMission.class);
        this.jobMissionJoins.add(EmergencySupplyMission.class);
    }

    @Override
    public double getCapability(Person person) {
        double result = 0.0;
        int areologySkill = person.getMind().getSkillManager().getSkillLevel("Areology");
        result = areologySkill;
        NaturalAttributeManager attributes = person.getNaturalAttributeManager();
        int academicAptitude = attributes.getAttribute("Academic Aptitude");
        int experienceAptitude = attributes.getAttribute("Experience Aptitude");
        double averageAptitude = (double)(academicAptitude + experienceAptitude) / 2.0;
        result += result * ((averageAptitude - 50.0) / 100.0);
        if (person.getPhysicalCondition().hasSeriousMedicalProblems()) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getSettlementNeed(Settlement settlement) {
        double result = 0.0;
        List<Building> laboratoryBuildings = settlement.getBuildingManager().getBuildings("Research");
        for (Building building : laboratoryBuildings) {
            Research lab = (Research)building.getFunction("Research");
            if (!lab.hasSpeciality("Areology")) continue;
            result += (double)(lab.getLaboratorySize() * lab.getTechnologyLevel()) / 2.0;
        }
        for (Vehicle vehicle : settlement.getParkedVehicles()) {
            Lab lab;
            Rover rover;
            if (!(vehicle instanceof Rover) || !(rover = (Rover)vehicle).hasLab() || !(lab = rover.getLab()).hasSpeciality("Areology")) continue;
            result += (double)(lab.getLaboratorySize() * lab.getTechnologyLevel()) / 2.0;
        }
        MissionManager missionManager = Simulation.instance().getMissionManager();
        for (Mission mission : missionManager.getMissionsForSettlement(settlement)) {
            Lab lab;
            Rover rover;
            if (!(mission instanceof RoverMission) || (rover = ((RoverMission)mission).getRover()) == null || settlement.getParkedVehicles().contains(rover) || !rover.hasLab() || !(lab = rover.getLab()).hasSpeciality("Areology")) continue;
            result += (double)(lab.getLaboratorySize() * lab.getTechnologyLevel()) / 2.0;
        }
        return result;
    }
}

