/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.task.CookMeal;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.Cooking;

public class Chef
extends Job
implements Serializable {
    private static Logger logger = Logger.getLogger(Chef.class.getName());

    public Chef() {
        super("Chef");
        this.jobTasks.add(CookMeal.class);
        this.jobTasks.add(DigLocalIce.class);
        this.jobMissionStarts.add(TravelToSettlement.class);
        this.jobMissionJoins.add(TravelToSettlement.class);
        this.jobMissionStarts.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(BuildingConstructionMission.class);
        this.jobMissionJoins.add(BuildingSalvageMission.class);
        this.jobMissionStarts.add(EmergencySupplyMission.class);
        this.jobMissionJoins.add(EmergencySupplyMission.class);
    }

    @Override
    public double getCapability(Person person) {
        double result = 0.0;
        int cookingSkill = person.getMind().getSkillManager().getSkillLevel("Cooking");
        result = cookingSkill;
        NaturalAttributeManager attributes = person.getNaturalAttributeManager();
        int experienceAptitude = attributes.getAttribute("Experience Aptitude");
        result += result * (((double)experienceAptitude - 50.0) / 100.0);
        if (person.getPhysicalCondition().hasSeriousMedicalProblems()) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getSettlementNeed(Settlement settlement) {
        double result = 0.0;
        List<Building> kitchenBuildings = settlement.getBuildingManager().getBuildings("Cooking");
        for (Building building : kitchenBuildings) {
            Cooking kitchen = (Cooking)building.getFunction("Cooking");
            result += (double)kitchen.getCookCapacity();
        }
        int population = settlement.getCurrentPopulationNum();
        return result += (double)population / 10.0;
    }
}

