/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.person.ai.task.MaintainGroundVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.MaintainGroundVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.person.ai.task.MaintenanceEVA;
import org.mars_sim.msp.core.person.ai.task.RepairEVAMalfunction;
import org.mars_sim.msp.core.person.ai.task.RepairMalfunction;
import org.mars_sim.msp.core.person.ai.task.ToggleFuelPowerSource;
import org.mars_sim.msp.core.person.ai.task.ToggleResourceProcess;
import org.mars_sim.msp.core.structure.Settlement;

public class Technician
extends Job
implements Serializable {
    public Technician() {
        super("Technician");
        this.jobTasks.add(Maintenance.class);
        this.jobTasks.add(MaintenanceEVA.class);
        this.jobTasks.add(MaintainGroundVehicleGarage.class);
        this.jobTasks.add(MaintainGroundVehicleEVA.class);
        this.jobTasks.add(RepairMalfunction.class);
        this.jobTasks.add(RepairEVAMalfunction.class);
        this.jobTasks.add(ToggleResourceProcess.class);
        this.jobTasks.add(ToggleFuelPowerSource.class);
        this.jobTasks.add(DigLocalIce.class);
        this.jobMissionStarts.add(TravelToSettlement.class);
        this.jobMissionJoins.add(TravelToSettlement.class);
        this.jobMissionStarts.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(BuildingConstructionMission.class);
        this.jobMissionJoins.add(BuildingSalvageMission.class);
        this.jobMissionStarts.add(EmergencySupplyMission.class);
        this.jobMissionJoins.add(EmergencySupplyMission.class);
    }

    @Override
    public double getCapability(Person person) {
        double result = 0.0;
        int mechanicSkill = person.getMind().getSkillManager().getSkillLevel("Mechanics");
        result = mechanicSkill;
        NaturalAttributeManager attributes = person.getNaturalAttributeManager();
        int experienceAptitude = attributes.getAttribute("Experience Aptitude");
        result += result * (((double)experienceAptitude - 50.0) / 100.0);
        if (person.getPhysicalCondition().hasSeriousMedicalProblems()) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getSettlementNeed(Settlement settlement) {
        double result = 0.0;
        result += (double)settlement.getBuildingManager().getBuildingNum() / 3.0;
        return result += (double)settlement.getParkedVehicleNum() / 3.0;
    }
}

