/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.job;

import java.io.Serializable;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.Trade;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.structure.Settlement;

public class Trader
extends Job
implements Serializable {
    private static double TRADING_RANGE = 1500.0;
    private static double SETTLEMENT_MULTIPLIER = 3.0;

    public Trader() {
        super("Trader");
        this.jobTasks.add(DigLocalIce.class);
        this.jobMissionStarts.add(Trade.class);
        this.jobMissionJoins.add(Trade.class);
        this.jobMissionStarts.add(TravelToSettlement.class);
        this.jobMissionJoins.add(TravelToSettlement.class);
        this.jobMissionStarts.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(RescueSalvageVehicle.class);
        this.jobMissionJoins.add(BuildingConstructionMission.class);
        this.jobMissionJoins.add(BuildingSalvageMission.class);
        this.jobMissionStarts.add(EmergencySupplyMission.class);
        this.jobMissionJoins.add(EmergencySupplyMission.class);
    }

    @Override
    public double getCapability(Person person) {
        double result = 0.0;
        int tradingSkill = person.getMind().getSkillManager().getSkillLevel("Trading");
        result = tradingSkill;
        NaturalAttributeManager attributes = person.getNaturalAttributeManager();
        int experienceAptitude = attributes.getAttribute("Experience Aptitude");
        result += result * (((double)experienceAptitude - 50.0) / 100.0);
        int conversation = attributes.getAttribute("Conversation");
        result += result * (((double)conversation - 50.0) / 100.0);
        return result;
    }

    @Override
    public double getSettlementNeed(Settlement settlement) {
        double result = 0.0;
        for (Settlement otherSettlement : settlement.getUnitManager().getSettlements()) {
            double distance;
            if (otherSettlement == settlement || !((distance = settlement.getCoordinates().getDistance(otherSettlement.getCoordinates())) <= TRADING_RANGE)) continue;
            result += SETTLEMENT_MULTIPLIER;
        }
        return result;
    }
}

