/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.task.ConstructBuilding;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.core.structure.construction.ConstructionValues;
import org.mars_sim.msp.core.structure.construction.ConstructionVehicleType;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class BuildingConstructionMission
extends Mission
implements Serializable {
    private static Logger logger = Logger.getLogger(BuildingConstructionMission.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Construct Building";
    public static final String PREPARE_SITE_PHASE = "Prepare Site";
    public static final String CONSTRUCTION_PHASE = "Construction";
    private static final int MIN_PEOPLE = 3;
    private static final int MAX_PEOPLE = 10;
    private static final double SITE_PREPARE_TIME = 500.0;
    private Settlement settlement;
    private ConstructionSite constructionSite;
    private ConstructionStage constructionStage;
    private List<GroundVehicle> constructionVehicles;
    private MarsClock sitePreparationStartTime;
    private boolean finishingExistingStage;
    private boolean constructionSuppliesLoaded;
    private List<Part> luvAttachmentParts;

    public BuildingConstructionMission(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson, 3);
        if (!this.isDone()) {
            this.settlement = startingPerson.getSettlement();
            this.setMissionCapacity(10);
            int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(this.settlement);
            if (availableSuitNum < this.getMissionCapacity()) {
                this.setMissionCapacity(availableSuitNum);
            }
            this.recruitPeopleForMission(startingPerson);
            int constructionSkill = startingPerson.getMind().getSkillManager().getEffectiveSkillLevel(CONSTRUCTION_PHASE);
            ConstructionManager manager = this.settlement.getConstructionManager();
            ConstructionValues values = manager.getConstructionValues();
            double existingSitesProfit = values.getAllConstructionSitesProfit(constructionSkill);
            double newSiteProfit = values.getNewConstructionSiteProfit(constructionSkill);
            if (existingSitesProfit > newSiteProfit) {
                double topSiteProfit = 0.0;
                for (ConstructionSite site : manager.getConstructionSitesNeedingConstructionMission()) {
                    double siteProfit = values.getConstructionSiteProfit(site, constructionSkill);
                    if (!(siteProfit > topSiteProfit) || !this.hasExistingSiteConstructionMaterials(site, constructionSkill)) continue;
                    this.constructionSite = site;
                    topSiteProfit = siteProfit;
                }
            } else if (BuildingConstructionMission.hasAnyNewSiteConstructionMaterials(constructionSkill, this.settlement)) {
                this.constructionSite = manager.createNewConstructionSite();
                ConstructionStageInfo stageInfo = this.determineNewStageInfo(this.constructionSite, constructionSkill);
                if (stageInfo != null) {
                    this.constructionSite.setWidth(stageInfo.getWidth());
                    this.constructionSite.setLength(stageInfo.getLength());
                    this.positionNewConstructionSite(this.constructionSite, stageInfo);
                    logger.log(Level.INFO, "New construction site added at " + this.settlement.getName());
                } else {
                    this.endMission("New construction stage could not be determined.");
                }
            }
            if (this.constructionSite != null) {
                if (this.constructionSite.hasUnfinishedStage()) {
                    this.constructionStage = this.constructionSite.getCurrentConstructionStage();
                    this.finishingExistingStage = true;
                    logger.log(Level.INFO, "Continuing work on existing site at " + this.settlement.getName());
                } else {
                    ConstructionStageInfo stageInfo = this.determineNewStageInfo(this.constructionSite, constructionSkill);
                    if (stageInfo != null) {
                        this.constructionStage = new ConstructionStage(stageInfo, this.constructionSite);
                        this.constructionSite.addNewStage(this.constructionStage);
                        values.clearCache();
                        logger.log(Level.INFO, "Starting new construction stage: " + this.constructionStage);
                    } else {
                        this.endMission("New construction stage could not be determined.");
                    }
                }
                if (this.constructionStage != null) {
                    this.constructionSite.setUndergoingConstruction(true);
                }
            } else {
                this.endMission("Construction site could not be found or created.");
            }
            if (!this.isDone()) {
                this.reserveConstructionVehicles();
            }
            if (!this.isDone()) {
                this.retrieveConstructionLUVParts();
            }
        }
        this.addPhase(PREPARE_SITE_PHASE);
        this.addPhase(CONSTRUCTION_PHASE);
        this.setPhase(PREPARE_SITE_PHASE);
        this.setPhaseDescription("Preparing construction site at " + this.settlement.getName());
    }

    public BuildingConstructionMission(Collection<Person> members, Settlement settlement, ConstructionSite site, ConstructionStageInfo stageInfo, double xLoc, double yLoc, double facing, List<GroundVehicle> vehicles) {
        super(DEFAULT_DESCRIPTION, (Person)members.toArray()[0], 1);
        this.settlement = settlement;
        ConstructionManager manager = settlement.getConstructionManager();
        if (site != null) {
            this.constructionSite = site;
        } else {
            logger.log(Level.INFO, "New construction site added at " + settlement.getName());
            this.constructionSite = manager.createNewConstructionSite();
            if (this.constructionSite != null) {
                this.constructionSite.setWidth(stageInfo.getWidth());
                this.constructionSite.setLength(stageInfo.getLength());
                this.positionNewConstructionSite(this.constructionSite, stageInfo);
            } else {
                this.endMission("Construction site could not be created.");
            }
        }
        if (this.constructionSite.hasUnfinishedStage()) {
            this.constructionStage = this.constructionSite.getCurrentConstructionStage();
            this.finishingExistingStage = true;
            logger.log(Level.INFO, "Using existing construction stage: " + this.constructionStage);
        } else {
            this.constructionStage = new ConstructionStage(stageInfo, this.constructionSite);
            logger.log(Level.INFO, "Starting new construction stage: " + this.constructionStage);
            try {
                this.constructionSite.addNewStage(this.constructionStage);
            }
            catch (Exception e) {
                this.endMission("Construction stage could not be created.");
            }
        }
        if (this.constructionStage != null) {
            this.constructionSite.setUndergoingConstruction(true);
        }
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.constructionVehicles = vehicles;
        for (GroundVehicle vehicle : vehicles) {
            vehicle.setReservedForMission(true);
            if (settlement.getInventory().containsUnit(vehicle)) {
                settlement.getInventory().retrieveUnit(vehicle);
                continue;
            }
            logger.severe("Unable to retrieve " + vehicle.getName() + " cannot be retrieved from " + settlement.getName() + " inventory.");
            this.endMission("Construction vehicle " + vehicle.getName() + " could not be retrieved from settlement inventory.");
        }
        this.retrieveConstructionLUVParts();
        this.addPhase(PREPARE_SITE_PHASE);
        this.addPhase(CONSTRUCTION_PHASE);
        this.setPhase(PREPARE_SITE_PHASE);
        this.setPhaseDescription("Preparing construction site at " + settlement.getName());
    }

    public static double getNewMissionProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            Job job;
            Settlement settlement = person.getSettlement();
            boolean reservableLUV = BuildingConstructionMission.isLUVAvailable(settlement);
            int availablePeopleNum = 0;
            for (Person member : settlement.getInhabitants()) {
                boolean isFit;
                boolean noMission = !member.getMind().hasActiveMission();
                boolean bl = isFit = !member.getPhysicalCondition().hasSeriousMedicalProblems();
                if (!noMission || !isFit) continue;
                ++availablePeopleNum;
            }
            boolean enoughPeople = availablePeopleNum >= 3;
            boolean constructionOverride = settlement.getConstructionOverride();
            if (reservableLUV && enoughPeople && !constructionOverride) {
                try {
                    ConstructionValues values;
                    double constructionProfit;
                    int constructionSkill = person.getMind().getSkillManager().getEffectiveSkillLevel(CONSTRUCTION_PHASE);
                    if (BuildingConstructionMission.hasAnyNewSiteConstructionMaterials(constructionSkill, settlement) && (result = (constructionProfit = (values = settlement.getConstructionManager().getConstructionValues()).getSettlementConstructionProfit(constructionSkill))) > 100.0) {
                        result = 100.0;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error getting construction site.", e);
                }
            }
            if (Mission.getNumberAvailableEVASuitsAtSettlement(person.getSettlement()) < 3) {
                result = 0.0;
            }
            if ((job = person.getMind().getJob()) != null) {
                result *= job.getStartMissionProbabilityModifier(BuildingConstructionMission.class);
            }
        }
        return result;
    }

    private void reserveConstructionVehicles() {
        if (this.constructionStage != null) {
            this.constructionVehicles = new ArrayList<GroundVehicle>();
            for (ConstructionVehicleType vehicleType : this.constructionStage.getInfo().getVehicles()) {
                if (vehicleType.getVehicleClass() != LightUtilityVehicle.class) continue;
                LightUtilityVehicle luv = this.reserveLightUtilityVehicle();
                if (luv != null) {
                    this.constructionVehicles.add(luv);
                    continue;
                }
                this.endMission("Light utility vehicle not available.");
            }
        }
    }

    private void retrieveConstructionLUVParts() {
        if (this.constructionStage != null) {
            this.luvAttachmentParts = new ArrayList<Part>();
            int vehicleIndex = 0;
            Iterator<ConstructionVehicleType> k = this.constructionStage.getInfo().getVehicles().iterator();
            while (k.hasNext()) {
                Vehicle vehicle = null;
                if (this.constructionVehicles.size() > vehicleIndex) {
                    vehicle = this.constructionVehicles.get(vehicleIndex);
                }
                for (Part part : k.next().getAttachmentParts()) {
                    try {
                        this.settlement.getInventory().retrieveItemResources(part, 1);
                        if (vehicle != null) {
                            vehicle.getInventory().storeItemResources(part, 1);
                        }
                        this.luvAttachmentParts.add(part);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error retrieving attachment part " + part.getName());
                        this.endMission("Construction attachment part " + part.getName() + " could not be retrieved.");
                    }
                }
                ++vehicleIndex;
            }
        }
    }

    private ConstructionStageInfo determineNewStageInfo(ConstructionSite site, int skill) {
        ConstructionStageInfo result = null;
        ConstructionValues values = this.settlement.getConstructionManager().getConstructionValues();
        Map<ConstructionStageInfo, Double> stageProfits = values.getNewConstructionStageProfits(site, skill);
        if (!stageProfits.isEmpty()) {
            result = RandomUtil.getWeightedRandomObject(stageProfits);
        }
        return result;
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.settlement;
    }

    private static boolean isLUVAvailable(Settlement settlement) {
        boolean result = false;
        for (Vehicle vehicle : settlement.getParkedVehicles()) {
            if (!(vehicle instanceof LightUtilityVehicle)) continue;
            boolean usable = true;
            if (vehicle.isReserved()) {
                usable = false;
            }
            if (!vehicle.getStatus().equals("Parked")) {
                usable = false;
            }
            if (((Crewable)((Object)vehicle)).getCrewNum() > 0) {
                usable = false;
            }
            if (!usable) continue;
            result = true;
        }
        return result;
    }

    @Override
    protected void determineNewPhase() {
        if (PREPARE_SITE_PHASE.equals(this.getPhase())) {
            this.setPhase(CONSTRUCTION_PHASE);
            this.setPhaseDescription("Constructing Site Stage: " + this.constructionStage.getInfo().getName());
        } else if (CONSTRUCTION_PHASE.equals(this.getPhase())) {
            this.endMission("Successfully ended construction");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (PREPARE_SITE_PHASE.equals(this.getPhase())) {
            this.prepareSitePhase(person);
        } else if (CONSTRUCTION_PHASE.equals(this.getPhase())) {
            this.constructionPhase(person);
        }
    }

    private void prepareSitePhase(Person person) {
        if (this.finishingExistingStage) {
            this.setPhaseEnded(true);
        } else if (!this.constructionSuppliesLoaded) {
            Inventory inv = this.settlement.getInventory();
            for (AmountResource resource : this.constructionStage.getInfo().getResources().keySet()) {
                double amount = this.constructionStage.getInfo().getResources().get(resource);
                if (!(inv.getAmountResourceStored(resource, false) >= amount)) continue;
                inv.retrieveAmountResource(resource, amount);
            }
            for (Part part : this.constructionStage.getInfo().getParts().keySet()) {
                int number = this.constructionStage.getInfo().getParts().get(part);
                if (inv.getItemResourceNum(part) < number) continue;
                inv.retrieveItemResources(part, number);
            }
            this.constructionSuppliesLoaded = true;
        }
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        if (this.sitePreparationStartTime == null) {
            this.sitePreparationStartTime = (MarsClock)currentTime.clone();
        }
        if (MarsClock.getTimeDiff(currentTime, this.sitePreparationStartTime) >= 500.0) {
            this.setPhaseEnded(true);
        }
    }

    private void constructionPhase(Person person) {
        if (this.hasEmergency()) {
            this.setPhaseEnded(true);
        }
        if (!this.getPhaseEnded() && RandomUtil.lessThanRandPercent(75.0) && ConstructBuilding.canConstruct(person)) {
            this.assignTask(person, new ConstructBuilding(person, this.constructionStage, this.constructionSite, this.constructionVehicles));
        }
        if (this.constructionStage.isComplete()) {
            this.setPhaseEnded(true);
            this.settlement.getConstructionManager().getConstructionValues().clearCache();
            if (this.constructionSite.isAllConstructionComplete()) {
                Building building = this.constructionSite.createBuilding(this.settlement.getBuildingManager());
                this.settlement.getConstructionManager().removeConstructionSite(this.constructionSite);
                this.settlement.fireUnitUpdate("finish building", building);
                logger.log(Level.INFO, "New " + this.constructionSite.getBuildingName() + " building constructed at " + this.settlement.getName());
            }
        }
    }

    @Override
    public void endMission(String reason) {
        super.endMission(reason);
        if (this.constructionSite != null) {
            this.constructionSite.setUndergoingConstruction(false);
        }
        this.unreserveConstructionVehicles();
        for (Part part : this.luvAttachmentParts) {
            try {
                this.settlement.getInventory().storeItemResources(part, 1);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error storing attachment part " + part.getName());
                this.endMission("Construction attachment part " + part.getName() + " could not be stored.");
            }
        }
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.settlement;
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForRemainingMission(boolean useBuffer) {
        HashMap<Resource, Number> resources = new HashMap<Resource, Number>();
        if (!this.constructionSuppliesLoaded) {
            resources.putAll(this.constructionStage.getInfo().getResources());
            resources.putAll(this.constructionStage.getInfo().getParts());
            for (Part part : this.luvAttachmentParts) {
                if (resources.containsKey(part)) {
                    resources.put(part, ((Number)resources.get(part)).intValue() + 1);
                    continue;
                }
                resources.put(part, 1);
            }
        }
        return resources;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        HashMap<Class, Integer> equipment = new HashMap<Class, Integer>(1);
        equipment.put(EVASuit.class, this.getPeopleNumber());
        return equipment;
    }

    private LightUtilityVehicle reserveLightUtilityVehicle() {
        LightUtilityVehicle result = null;
        Iterator<Vehicle> i = this.settlement.getParkedVehicles().iterator();
        while (i.hasNext() && result == null) {
            LightUtilityVehicle luvTemp;
            Vehicle vehicle = i.next();
            if (!(vehicle instanceof LightUtilityVehicle) || !(luvTemp = (LightUtilityVehicle)vehicle).getStatus().equals("Parked") || luvTemp.isReserved() || luvTemp.getCrewNum() != 0) continue;
            result = luvTemp;
            luvTemp.setReservedForMission(true);
            Point2D.Double relativeLocSite = LocalAreaUtil.getRandomInteriorLocation(this.constructionSite);
            Point2D.Double settlementLocSite = LocalAreaUtil.getLocalRelativeLocation(relativeLocSite.getX(), relativeLocSite.getY(), this.constructionSite);
            luvTemp.setParkedLocation(settlementLocSite.getX(), settlementLocSite.getY(), RandomUtil.getRandomDouble(360.0));
            if (this.settlement.getInventory().containsUnit(luvTemp)) {
                this.settlement.getInventory().retrieveUnit(luvTemp);
                continue;
            }
            logger.severe("Unable to retrieve " + luvTemp.getName() + " cannot be retrieved from " + this.settlement.getName() + " inventory.");
            this.endMission("Construction vehicle " + luvTemp.getName() + " could not be retrieved from settlement inventory.");
        }
        return result;
    }

    private void unreserveConstructionVehicles() {
        if (this.constructionVehicles != null) {
            for (GroundVehicle vehicle : this.constructionVehicles) {
                vehicle.setReservedForMission(false);
                Inventory vInv = vehicle.getInventory();
                Inventory sInv = this.settlement.getInventory();
                sInv.storeUnit(vehicle);
                vehicle.determinedSettlementParkedLocationAndFacing();
                for (ItemResource attachmentPart : vInv.getAllItemResourcesStored()) {
                    int num = vInv.getItemResourceNum(attachmentPart);
                    vInv.retrieveItemResources(attachmentPart, num);
                    sInv.storeItemResources(attachmentPart, num);
                }
            }
        }
    }

    public List<GroundVehicle> getConstructionVehicles() {
        return new ArrayList<GroundVehicle>(this.constructionVehicles);
    }

    private static boolean hasStageConstructionMaterials(ConstructionStageInfo stage, Settlement settlement) {
        boolean result = true;
        for (AmountResource resource : stage.getResources().keySet()) {
            double amount = stage.getResources().get(resource);
            if (!(settlement.getInventory().getAmountResourceStored(resource, false) < amount)) continue;
            result = false;
        }
        for (Part part : stage.getParts().keySet()) {
            int number = stage.getParts().get(part);
            if (settlement.getInventory().getItemResourceNum(part) >= number) continue;
            result = false;
        }
        return result;
    }

    private static boolean hasAnyNewSiteConstructionMaterials(int skill, Settlement settlement) {
        boolean result = false;
        Iterator<ConstructionStageInfo> i = ConstructionUtil.getConstructionStageInfoList("foundation", skill).iterator();
        while (i.hasNext()) {
            if (!BuildingConstructionMission.hasStageConstructionMaterials(i.next(), settlement)) continue;
            result = true;
        }
        return result;
    }

    private boolean hasExistingSiteConstructionMaterials(ConstructionSite site, int skill) {
        boolean result = true;
        if (!site.hasUnfinishedStage()) {
            result = false;
            String stageType = site.getNextStageType();
            Iterator<ConstructionStageInfo> i = ConstructionUtil.getConstructionStageInfoList(stageType, skill).iterator();
            while (i.hasNext()) {
                if (!BuildingConstructionMission.hasStageConstructionMaterials(i.next(), this.settlement)) continue;
                result = true;
            }
        }
        return result;
    }

    @Override
    protected boolean hasEmergency() {
        boolean result = super.hasEmergency();
        try {
            Vehicle vehicleTarget = null;
            Vehicle vehicle = RoverMission.getVehicleWithGreatestRange(this.settlement, true);
            if (vehicle != null && (vehicleTarget = RescueSalvageVehicle.findAvailableBeaconVehicle(this.settlement, vehicle.getRange())) != null && !RescueSalvageVehicle.isClosestCapableSettlement(this.settlement, vehicleTarget)) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public ConstructionSite getConstructionSite() {
        return this.constructionSite;
    }

    public ConstructionStage getConstructionStage() {
        return this.constructionStage;
    }

    private void positionNewConstructionSite(ConstructionSite site, ConstructionStageInfo foundationStageInfo) {
        String buildingType = this.determinePreferredConstructedBuildingType(foundationStageInfo);
        if (buildingType != null) {
            boolean hasLifeSupport = SimulationConfig.instance().getBuildingConfiguration().hasLifeSupport(buildingType);
            boolean goodPosition = false;
            if (hasLifeSupport) {
                List<Building> inhabitableBuildings = this.settlement.getBuildingManager().getBuildings("Life Support");
                Collections.shuffle(inhabitableBuildings);
                Iterator<Building> i = inhabitableBuildings.iterator();
                while (i.hasNext() && !(goodPosition = this.positionNextToBuilding(site, i.next(), 0.0))) {
                }
            } else {
                List<Building> sameBuildings = this.settlement.getBuildingManager().getBuildingsOfName(buildingType);
                Collections.shuffle(sameBuildings);
                Iterator<Building> j = sameBuildings.iterator();
                while (j.hasNext() && !(goodPosition = this.positionNextToBuilding(site, j.next(), 0.0))) {
                }
            }
            if (!goodPosition) {
                BuildingManager buildingManager = this.settlement.getBuildingManager();
                if (buildingManager.getBuildingNum() > 0) {
                    int x = 10;
                    while (!goodPosition) {
                        List<Building> allBuildings = buildingManager.getBuildings();
                        Collections.shuffle(allBuildings);
                        Iterator<Building> i = allBuildings.iterator();
                        while (i.hasNext() && !(goodPosition = this.positionNextToBuilding(site, i.next(), x))) {
                        }
                        x += 10;
                    }
                } else {
                    site.setXLocation(0.0);
                    site.setYLocation(0.0);
                    site.setFacing(RandomUtil.getRandomDouble(360.0));
                }
            }
        }
    }

    private String determinePreferredConstructedBuildingType(ConstructionStageInfo foundationStageInfo) {
        String result = null;
        ConstructionValues values = this.settlement.getConstructionManager().getConstructionValues();
        List<String> constructableBuildings = ConstructionUtil.getConstructableBuildingNames(foundationStageInfo);
        Iterator<String> i = constructableBuildings.iterator();
        double maxBuildingValue = Double.NEGATIVE_INFINITY;
        while (i.hasNext()) {
            String buildingType = i.next();
            double buildingValue = values.getConstructionStageValue(foundationStageInfo);
            if (!(buildingValue > maxBuildingValue)) continue;
            maxBuildingValue = buildingValue;
            result = buildingType;
        }
        return result;
    }

    private boolean positionNextToBuilding(ConstructionSite site, Building building, double separationDistance) {
        boolean goodPosition = false;
        boolean front = false;
        boolean back = true;
        int right = 2;
        int left = 3;
        ArrayList<Integer> directions = new ArrayList<Integer>(4);
        directions.add(0);
        directions.add(1);
        directions.add(2);
        directions.add(3);
        Collections.shuffle(directions);
        double direction = 0.0;
        double structureDistance = 0.0;
        for (int x = 0; x < directions.size(); ++x) {
            switch ((Integer)directions.get(x)) {
                case 0: {
                    direction = building.getFacing();
                    structureDistance = building.getLength() / 2.0 + site.getLength() / 2.0;
                    break;
                }
                case 1: {
                    direction = building.getFacing() + 180.0;
                    structureDistance = building.getLength() / 2.0 + site.getLength() / 2.0;
                    break;
                }
                case 2: {
                    direction = building.getFacing() + 90.0;
                    structureDistance = building.getWidth() / 2.0 + site.getWidth() / 2.0;
                    break;
                }
                case 3: {
                    direction = building.getFacing() + 270.0;
                    structureDistance = building.getWidth() / 2.0 + site.getWidth() / 2.0;
                }
            }
            goodPosition = true;
            double distance = structureDistance + separationDistance;
            double radianDirection = Math.PI * direction / 180.0;
            double rectCenterX = building.getXLocation() - distance * Math.sin(radianDirection);
            double rectCenterY = building.getYLocation() + distance * Math.cos(radianDirection);
            double rectRotation = building.getFacing();
            if (!this.settlement.getBuildingManager().checkIfNewBuildingLocationOpen(rectCenterX, rectCenterY, site.getWidth(), site.getLength(), rectRotation, site)) continue;
            site.setXLocation(rectCenterX);
            site.setYLocation(rectCenterY);
            site.setFacing(building.getFacing());
            break;
        }
        return goodPosition;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.settlement = null;
        this.constructionSite = null;
        this.constructionStage = null;
        if (this.constructionVehicles != null) {
            this.constructionVehicles.clear();
        }
        this.constructionVehicles = null;
        this.sitePreparationStartTime = null;
        if (this.luvAttachmentParts != null) {
            this.luvAttachmentParts.clear();
        }
        this.luvAttachmentParts = null;
    }
}

