/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.CollectResourcesMission;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.vehicle.Rover;

public class CollectRegolith
extends CollectResourcesMission {
    private static Logger logger = Logger.getLogger(CollectRegolith.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Regolith Prospecting";
    private static final double SITE_GOAL = 500.0;
    public static final int REQUIRED_BAGS = 10;
    private static final double COLLECTION_RATE = 5.0;
    private static final int NUM_SITES = 1;
    private static final int MIN_PEOPLE = 2;

    public CollectRegolith(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson, CollectRegolith.getRegolithResource(), 500.0, 5.0, Bag.class, 10, 1, 2);
    }

    public CollectRegolith(Collection<Person> members, Settlement startingSettlement, List<Coordinates> regolithCollectionSites, Rover rover, String description) {
        super(description, members, startingSettlement, CollectRegolith.getRegolithResource(), 500.0, 5.0, Bag.class, 10, regolithCollectionSites.size(), 1, rover, regolithCollectionSites);
    }

    public static double getNewMissionProbability(Person person) {
        double result = CollectResourcesMission.getNewMissionProbability(person, Bag.class, 10, 2, CollectRegolith.class);
        if (result > 0.0) {
            try {
                GoodsManager manager = person.getSettlement().getGoodsManager();
                AmountResource regolithResource = AmountResource.findAmountResource("regolith");
                double value = manager.getGoodValuePerItem(GoodsUtil.getResourceGood(regolithResource));
                result *= value * 10.0;
                if (result > 100.0) {
                    result = 100.0;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error checking good value of regolith.");
            }
            if (Mission.getNumberAvailableEVASuitsAtSettlement(person.getSettlement()) < 2) {
                result = 0.0;
            }
        }
        return result;
    }

    @Override
    protected String getCollectionSiteDescription(int siteNum) {
        return "prospecting site";
    }

    private static AmountResource getRegolithResource() {
        return AmountResource.findAmountResource("regolith");
    }
}

