/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.CollectResources;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Rover;

public abstract class CollectResourcesMission
extends RoverMission
implements Serializable {
    private static Logger logger = Logger.getLogger(CollectResourcesMission.class.getName());
    public static final String COLLECT_RESOURCES = "Collecting Resources";
    public static final double EVA_COLLECTION_OVERHEAD = 20.0;
    private AmountResource resourceType;
    private double siteCollectedResources;
    private double collectingStart;
    private double siteResourceGoal;
    private double resourceCollectionRate;
    private Class containerType;
    private int containerNum;
    private MarsClock collectionSiteStartTime;
    private boolean endCollectingSite;
    private double totalResourceCollected;

    CollectResourcesMission(String missionName, Person startingPerson, AmountResource resourceType, double siteResourceGoal, double resourceCollectionRate, Class containerType, int containerNum, int numSites, int minPeople) {
        super(missionName, startingPerson, minPeople);
        if (!this.isDone()) {
            int availableSuitNum;
            if (this.hasVehicle()) {
                this.setMissionCapacity(this.getRover().getCrewCapacity());
            }
            if ((availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingPerson.getSettlement())) < this.getMissionCapacity()) {
                this.setMissionCapacity(availableSuitNum);
            }
            this.setStartingSettlement(startingPerson.getSettlement());
            this.resourceType = resourceType;
            this.siteResourceGoal = siteResourceGoal;
            this.resourceCollectionRate = resourceCollectionRate;
            this.containerType = containerType;
            this.containerNum = containerNum;
            this.recruitPeopleForMission(startingPerson);
            if (this.hasVehicle()) {
                this.determineCollectionSites(this.getVehicle().getRange(), CollectResourcesMission.getTotalTripTimeLimit(this.getRover(), this.getPeopleNumber(), true), numSites);
            }
            this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
            if (this.hasVehicle() && !this.isVehicleLoadable()) {
                this.endMission("Vehicle is not loadable. (CollectingResourcesMission)");
            }
        }
        this.addPhase(COLLECT_RESOURCES);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
    }

    CollectResourcesMission(String missionName, Collection<Person> members, Settlement startingSettlement, AmountResource resourceType, double siteResourceGoal, double resourceCollectionRate, Class containerType, int containerNum, int numSites, int minPeople, Rover rover, List<Coordinates> collectionSites) {
        super(missionName, (Person)members.toArray()[0], minPeople, rover);
        this.setStartingSettlement(startingSettlement);
        this.setMissionCapacity(this.getRover().getCrewCapacity());
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingSettlement);
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        this.resourceType = resourceType;
        this.siteResourceGoal = siteResourceGoal;
        this.resourceCollectionRate = resourceCollectionRate;
        this.containerType = containerType;
        this.containerNum = containerNum;
        for (int x = 0; x < collectionSites.size(); ++x) {
            this.addNavpoint(new NavPoint(collectionSites.get(x), this.getCollectionSiteDescription(x + 1)));
        }
        this.addNavpoint(new NavPoint(startingSettlement.getCoordinates(), startingSettlement, startingSettlement.getName()));
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.addPhase(COLLECT_RESOURCES);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        if (this.hasVehicle() && !this.isVehicleLoadable()) {
            this.endMission("Vehicle is not loadable. (CollectingResourcesMission)");
        }
    }

    public static double getNewMissionProbability(Person person, Class containerType, int containerNum, int minPeople, Class missionType) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            Job job;
            int crowding;
            boolean enoughMethane;
            Settlement settlement = person.getSettlement();
            boolean reservableRover = CollectResourcesMission.areVehiclesAvailable(settlement, false);
            boolean backupRover = CollectResourcesMission.hasBackupRover(settlement);
            boolean minNum = CollectResourcesMission.minAvailablePeopleAtSettlement(settlement, minPeople + 1);
            boolean enoughContainers = CollectResourcesMission.numCollectingContainersAvailable(settlement, containerType) >= containerNum;
            boolean embarkingMissions = VehicleMission.hasEmbarkingMissions(settlement);
            boolean hasBasicResources = RoverMission.hasEnoughBasicResources(settlement);
            AmountResource methane = AmountResource.findAmountResource("methane");
            boolean bl = enoughMethane = settlement.getInventory().getAmountResourceStored(methane, false) >= 1000.0;
            if (reservableRover && backupRover && minNum && enoughContainers && !embarkingMissions && hasBasicResources && enoughMethane) {
                result = 5.0;
            }
            if ((crowding = settlement.getCurrentPopulationNum() - settlement.getPopulationCapacity()) > 0) {
                result *= (double)(crowding + 1);
            }
            if ((job = person.getMind().getJob()) != null) {
                result *= job.getStartMissionProbabilityModifier(missionType);
            }
        }
        return result;
    }

    public double getTotalCollectedResources() {
        return this.totalResourceCollected;
    }

    @Override
    protected void determineNewPhase() {
        if ("Embarking".equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Travelling".equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                this.setPhase("Disembarking");
                this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getSettlement().getName());
            } else {
                this.setPhase(COLLECT_RESOURCES);
                this.setPhaseDescription("Collecting resources at " + this.getCurrentNavpoint().getDescription());
                this.collectionSiteStartTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
            }
        } else if (COLLECT_RESOURCES.equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Disembarking".equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (COLLECT_RESOURCES.equals(this.getPhase())) {
            this.collectingPhase(person);
        }
    }

    public void endCollectingAtSite() {
        logger.info("Collecting phase ended due to external trigger.");
        this.endCollectingSite = true;
        Iterator<Person> i = this.getPeople().iterator();
        while (i.hasNext()) {
            Task task = i.next().getMind().getTaskManager().getTask();
            if (!(task instanceof CollectResources)) continue;
            ((CollectResources)task).endEVA();
        }
    }

    private void collectingPhase(Person person) {
        Inventory inv = this.getRover().getInventory();
        double resourcesCollected = inv.getAmountResourceStored(this.resourceType, false);
        double resourcesCapacity = inv.getAmountResourceCapacity(this.resourceType, false);
        this.totalResourceCollected = resourcesCollected;
        this.siteCollectedResources = resourcesCollected - this.collectingStart;
        if (this.isEveryoneInRover()) {
            if (this.endCollectingSite) {
                this.endCollectingSite = false;
                this.setPhaseEnded(true);
            }
            if (resourcesCollected >= resourcesCapacity) {
                this.setPhaseEnded(true);
            }
            if (this.siteCollectedResources >= this.siteResourceGoal) {
                this.setPhaseEnded(true);
            }
            boolean nobodyCollect = true;
            Iterator<Person> j = this.getPeople().iterator();
            while (j.hasNext()) {
                if (!CollectResources.canCollectResources(j.next(), this.getRover(), this.containerType, this.resourceType)) continue;
                nobodyCollect = false;
            }
            Mars mars = Simulation.instance().getMars();
            boolean inDarkPolarRegion = mars.getSurfaceFeatures().inDarkPolarRegion(this.getCurrentMissionLocation());
            double sunlight = mars.getSurfaceFeatures().getSurfaceSunlight(this.getCurrentMissionLocation());
            if (nobodyCollect && (sunlight > 0.0 || inDarkPolarRegion)) {
                this.setPhaseEnded(true);
            }
            if (this.hasEmergency()) {
                this.setPhaseEnded(true);
            }
            if (!this.hasEnoughResourcesForRemainingMission(false)) {
                this.determineEmergencyDestination(person);
                this.setPhaseEnded(true);
            }
        }
        if (!this.getPhaseEnded()) {
            if (this.siteCollectedResources < this.siteResourceGoal && !this.endCollectingSite && CollectResources.canCollectResources(person, this.getRover(), this.containerType, this.resourceType)) {
                CollectResources collectResources = new CollectResources(COLLECT_RESOURCES, person, this.getRover(), this.resourceType, this.resourceCollectionRate, this.siteResourceGoal - this.siteCollectedResources, inv.getAmountResourceStored(this.resourceType, false), this.containerType);
                this.assignTask(person, collectResources);
            }
        } else if (this.siteCollectedResources >= resourcesCapacity) {
            this.setNextNavpointIndex(this.getNumberOfNavpoints() - 2);
            this.updateTravelDestination();
            this.siteCollectedResources = 0.0;
        }
    }

    private void determineCollectionSites(double roverRange, double tripTimeLimit, int numSites) {
        ArrayList<Coordinates> unorderedSites = new ArrayList<Coordinates>();
        double range = roverRange;
        double timeRange = this.getTripTimeRange(tripTimeLimit, numSites, true);
        if (timeRange < range) {
            range = timeRange;
        }
        Coordinates startingLocation = this.getCurrentMissionLocation();
        Direction direction = new Direction(RandomUtil.getRandomDouble(Math.PI * 2));
        double limit = range / 4.0;
        double siteDistance = RandomUtil.getRandomDouble(limit);
        Coordinates newLocation = startingLocation.getNewLocation(direction, siteDistance);
        unorderedSites.add(newLocation);
        Coordinates currentLocation = newLocation;
        double remainingRange = range / 2.0 - siteDistance;
        for (int x = 1; x < numSites; ++x) {
            double currentDistanceToSettlement = currentLocation.getDistance(startingLocation);
            if (!(remainingRange > currentDistanceToSettlement)) continue;
            direction = new Direction(RandomUtil.getRandomDouble(Math.PI * 2));
            double tempLimit1 = Math.pow(remainingRange, 2.0) - Math.pow(currentDistanceToSettlement, 2.0);
            double tempLimit2 = 2.0 * remainingRange - 2.0 * currentDistanceToSettlement * direction.getCosDirection();
            limit = tempLimit1 / tempLimit2;
            siteDistance = RandomUtil.getRandomDouble(limit);
            newLocation = currentLocation.getNewLocation(direction, siteDistance);
            unorderedSites.add(newLocation);
            currentLocation = newLocation;
            remainingRange -= siteDistance;
        }
        int collectionSiteNum = 1;
        currentLocation = startingLocation;
        while (unorderedSites.size() > 0) {
            Coordinates shortest = (Coordinates)unorderedSites.get(0);
            for (Coordinates site : unorderedSites) {
                if (!(currentLocation.getDistance(site) < currentLocation.getDistance(shortest))) continue;
                shortest = site;
            }
            this.addNavpoint(new NavPoint(shortest, this.getCollectionSiteDescription(collectionSiteNum)));
            unorderedSites.remove(shortest);
            currentLocation = shortest;
            ++collectionSiteNum;
        }
    }

    private double getTripTimeRange(double tripTimeLimit, int numSites, boolean useBuffer) {
        double timeAtSites = this.getEstimatedTimeAtCollectionSite(useBuffer) * (double)numSites;
        double tripTimeTravellingLimit = tripTimeLimit - timeAtSites;
        double averageSpeed = this.getAverageVehicleSpeedForOperators();
        double millisolsInHour = MarsClock.convertSecondsToMillisols(3600.0);
        double averageSpeedMillisol = averageSpeed / millisolsInHour;
        return tripTimeTravellingLimit * averageSpeedMillisol;
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.getStartingSettlement();
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.getStartingSettlement();
    }

    @Override
    protected void recruitPeopleForMission(Person startingPerson) {
        super.recruitPeopleForMission(startingPerson);
        if (!CollectResourcesMission.atLeastOnePersonRemainingAtSettlement(this.getStartingSettlement(), startingPerson)) {
            Object[] array = this.getPeople().toArray();
            int amount = this.getPeopleNumber() - 1;
            Person lastPerson = null;
            if (amount >= 0 && amount < array.length) {
                lastPerson = (Person)array[amount];
            }
            if (lastPerson != null) {
                lastPerson.getMind().setMission(null);
                if (this.getPeopleNumber() < this.getMinPeople()) {
                    this.endMission("Not enough members.");
                }
            }
        }
    }

    protected static int numCollectingContainersAvailable(Settlement settlement, Class containerType) {
        return settlement.getInventory().findNumEmptyUnitsOfClass(containerType, false);
    }

    @Override
    public double getEstimatedRemainingMissionTime(boolean useBuffer) {
        double result = super.getEstimatedRemainingMissionTime(useBuffer);
        return result += this.getEstimatedRemainingCollectionSiteTime(useBuffer);
    }

    private double getEstimatedRemainingCollectionSiteTime(boolean useBuffer) {
        double result = 0.0;
        if (COLLECT_RESOURCES.equals(this.getPhase())) {
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            double timeSpentAtCollectionSite = MarsClock.getTimeDiff(currentTime, this.collectionSiteStartTime);
            double remainingTime = this.getEstimatedTimeAtCollectionSite(useBuffer) - timeSpentAtCollectionSite;
            if (remainingTime > 0.0) {
                result += remainingTime;
            }
        }
        int remainingCollectionSites = this.getNumCollectionSites() - this.getNumCollectionSitesVisited();
        return result += this.getEstimatedTimeAtCollectionSite(useBuffer) * (double)remainingCollectionSites;
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForRemainingMission(boolean useBuffer) {
        Map<Resource, Number> result = super.getResourcesNeededForRemainingMission(useBuffer);
        double collectionSitesTime = this.getEstimatedRemainingCollectionSiteTime(useBuffer);
        double timeSols = collectionSitesTime / 1000.0;
        int crewNum = this.getPeopleNumber();
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenAmount = PhysicalCondition.getOxygenConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(oxygen)) {
            oxygenAmount += ((Double)result.get(oxygen)).doubleValue();
        }
        result.put(oxygen, oxygenAmount);
        AmountResource water = AmountResource.findAmountResource("water");
        double waterAmount = PhysicalCondition.getWaterConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(water)) {
            waterAmount += ((Double)result.get(water)).doubleValue();
        }
        result.put(water, waterAmount);
        AmountResource food = AmountResource.findAmountResource("food");
        double foodAmount = PhysicalCondition.getFoodConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(food)) {
            foodAmount += ((Double)result.get(food)).doubleValue();
        }
        result.put(food, foodAmount);
        return result;
    }

    @Override
    protected Map<Resource, Number> getPartsNeededForTrip(double distance) {
        Map<Resource, Number> result = super.getPartsNeededForTrip(distance);
        double evaTime = this.getEstimatedRemainingCollectionSiteTime(false);
        double numberAccidents = evaTime * (double)this.getPeopleNumber() * 0.001;
        double numberMalfunctions = numberAccidents * 2.0;
        EVASuit suit = (EVASuit)EquipmentFactory.getEquipment(EVASuit.class, new Coordinates(0.0, 0.0), true);
        Map<Part, Double> parts = suit.getMalfunctionManager().getRepairPartProbabilities();
        for (Part part : parts.keySet()) {
            int number = (int)Math.round(parts.get(part) * numberMalfunctions);
            if (number <= 0) continue;
            if (result.containsKey(part)) {
                number += result.get(part).intValue();
            }
            result.put(part, number);
        }
        return result;
    }

    public final int getNumCollectionSites() {
        return this.getNumberOfNavpoints() - 2;
    }

    public final int getNumCollectionSitesVisited() {
        int result = this.getCurrentNavpointIndex();
        if (result == this.getNumberOfNavpoints() - 1) {
            --result;
        }
        return result;
    }

    protected double getEstimatedTimeAtCollectionSite(boolean useBuffer) {
        double timePerPerson = this.siteResourceGoal / this.resourceCollectionRate;
        if (useBuffer) {
            timePerPerson *= 20.0;
        }
        return timePerPerson / (double)this.getPeopleNumber();
    }

    public static double getTotalTripTimeLimit(Rover rover, int memberNum, boolean useBuffer) {
        Inventory vInv = rover.getInventory();
        double timeLimit = Double.MAX_VALUE;
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        AmountResource food = AmountResource.findAmountResource("food");
        double foodConsumptionRate = config.getFoodConsumptionRate();
        double foodCapacity = vInv.getAmountResourceCapacity(food, false);
        double foodTimeLimit = foodCapacity / (foodConsumptionRate * (double)memberNum);
        if (foodTimeLimit < timeLimit) {
            timeLimit = foodTimeLimit;
        }
        AmountResource water = AmountResource.findAmountResource("water");
        double waterConsumptionRate = config.getWaterConsumptionRate();
        double waterCapacity = vInv.getAmountResourceCapacity(water, false);
        double waterTimeLimit = waterCapacity / (waterConsumptionRate * (double)memberNum);
        if (waterTimeLimit < timeLimit) {
            timeLimit = waterTimeLimit;
        }
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenConsumptionRate = config.getOxygenConsumptionRate();
        double oxygenCapacity = vInv.getAmountResourceCapacity(oxygen, false);
        double oxygenTimeLimit = oxygenCapacity / (oxygenConsumptionRate * (double)memberNum);
        if (oxygenTimeLimit < timeLimit) {
            timeLimit = oxygenTimeLimit;
        }
        timeLimit *= 1000.0;
        if (useBuffer) {
            timeLimit /= 3.0;
        }
        return timeLimit;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        if (this.equipmentNeededCache != null) {
            return this.equipmentNeededCache;
        }
        HashMap<Class, Integer> result = new HashMap<Class, Integer>();
        result.put(this.containerType, this.containerNum);
        this.equipmentNeededCache = result;
        return result;
    }

    protected abstract String getCollectionSiteDescription(int var1);

    @Override
    public void destroy() {
        super.destroy();
        this.resourceType = null;
        this.containerType = null;
        this.collectionSiteStartTime = null;
    }
}

