/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.equipment.SpecimenContainer;
import org.mars_sim.msp.core.mars.ExploredLocation;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.mars.MineralMap;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.ExploreSite;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class Exploration
extends RoverMission
implements Serializable {
    private static Logger logger = Logger.getLogger(Exploration.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Mineral Exploration";
    public static final String EXPLORE_SITE = "Exploring Site";
    public static final String SITE_EXPLORATION_EVENT = "explore site";
    public static final int REQUIRED_SPECIMEN_CONTAINERS = 20;
    private static final int NUM_SITES = 5;
    public static final double EXPLORING_SITE_TIME = 1000.0;
    private static final double MINERAL_ESTIMATION_CEILING = 20.0;
    private Map<String, Double> explorationSiteCompletion;
    private MarsClock explorationSiteStartTime;
    private ExploredLocation currentSite;
    private List<ExploredLocation> exploredSites;
    private boolean endExploringSite;

    public Exploration(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson, 2);
        if (!this.isDone()) {
            int availableSuitNum;
            if (this.hasVehicle()) {
                this.setMissionCapacity(this.getRover().getCrewCapacity());
            }
            if ((availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingPerson.getSettlement())) < this.getMissionCapacity()) {
                this.setMissionCapacity(availableSuitNum);
            }
            this.setStartingSettlement(startingPerson.getSettlement());
            this.exploredSites = new ArrayList<ExploredLocation>(5);
            this.explorationSiteCompletion = new HashMap<String, Double>(5);
            this.recruitPeopleForMission(startingPerson);
            try {
                if (this.hasVehicle()) {
                    int skill = startingPerson.getMind().getSkillManager().getEffectiveSkillLevel("Areology");
                    this.determineExplorationSites(this.getVehicle().getRange(), Exploration.getTotalTripTimeLimit(this.getRover(), this.getPeopleNumber(), true), 5, skill);
                }
            }
            catch (Exception e) {
                this.endMission("Exploration sites could not be determined.");
            }
            this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
            if (this.hasVehicle() && !this.isVehicleLoadable()) {
                this.endMission("Vehicle is not loadable. (Exploration)");
            }
        }
        this.addPhase(EXPLORE_SITE);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
    }

    public Exploration(Collection<Person> members, Settlement startingSettlement, List<Coordinates> explorationSites, Rover rover, String description) {
        super(description, (Person)members.toArray()[0], 1, rover);
        this.setStartingSettlement(startingSettlement);
        this.setMissionCapacity(this.getRover().getCrewCapacity());
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingSettlement);
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        this.exploredSites = new ArrayList<ExploredLocation>(5);
        this.explorationSiteCompletion = new HashMap<String, Double>(5);
        for (int x = 0; x < explorationSites.size(); ++x) {
            String siteName = "exploration site " + (x + 1);
            this.addNavpoint(new NavPoint(explorationSites.get(x), siteName));
            this.explorationSiteCompletion.put(siteName, 0.0);
        }
        this.addNavpoint(new NavPoint(startingSettlement.getCoordinates(), startingSettlement, startingSettlement.getName()));
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.addPhase(EXPLORE_SITE);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        if (this.hasVehicle() && !this.isVehicleLoadable()) {
            this.endMission("Vehicle is not loadable. (Exploration)");
        }
    }

    public static double getNewMissionProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            Job job;
            int crowding;
            boolean enoughMethane;
            Settlement settlement = person.getSettlement();
            boolean reservableRover = RoverMission.areVehiclesAvailable(settlement, false);
            boolean backupRover = Exploration.hasBackupRover(settlement);
            boolean minNum = RoverMission.minAvailablePeopleAtSettlement(settlement, 3);
            boolean enoughContainers = false;
            int numContainers = settlement.getInventory().findNumEmptyUnitsOfClass(SpecimenContainer.class, false);
            enoughContainers = numContainers >= 20;
            boolean embarkingMissions = VehicleMission.hasEmbarkingMissions(settlement);
            boolean hasBasicResources = RoverMission.hasEnoughBasicResources(settlement);
            AmountResource methane = AmountResource.findAmountResource("methane");
            boolean bl = enoughMethane = settlement.getInventory().getAmountResourceStored(methane, false) >= 1000.0;
            if (reservableRover && backupRover && minNum && enoughContainers && !embarkingMissions && hasBasicResources && enoughMethane) {
                try {
                    Rover rover = (Rover)Exploration.getVehicleWithGreatestRange(settlement, false);
                    if (rover != null && Exploration.hasNearbyMineralLocations(rover, settlement)) {
                        result = 20.0;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error determining mineral locations.", e);
                }
            }
            if ((crowding = settlement.getCurrentPopulationNum() - settlement.getPopulationCapacity()) > 0) {
                result *= (double)(crowding + 1);
            }
            if ((job = person.getMind().getJob()) != null) {
                result *= job.getStartMissionProbabilityModifier(Exploration.class);
            }
        }
        if (result > 0.0 && Mission.getNumberAvailableEVASuitsAtSettlement(person.getSettlement()) < 2) {
            result = 0.0;
        }
        return result;
    }

    private static boolean hasNearbyMineralLocations(Rover rover, Settlement homeSettlement) {
        MineralMap map;
        Coordinates mineralLocation;
        double range;
        double roverRange = rover.getRange();
        double tripTimeLimit = Exploration.getTotalTripTimeLimit(rover, rover.getCrewCapacity(), true);
        double tripRange = Exploration.getTripTimeRange(tripTimeLimit, rover.getBaseSpeed() / 2.0);
        if (tripRange < (range = roverRange)) {
            range = tripRange;
        }
        boolean result = (mineralLocation = (map = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap()).findRandomMineralLocation(homeSettlement.getCoordinates(), range / 2.0)) != null;
        return result;
    }

    private static double getTripTimeRange(double tripTimeLimit, double averageSpeed) {
        double tripTimeTravellingLimit = tripTimeLimit - 5000.0;
        double millisolsInHour = MarsClock.convertSecondsToMillisols(3600.0);
        double averageSpeedMillisol = averageSpeed / millisolsInHour;
        return tripTimeTravellingLimit * averageSpeedMillisol;
    }

    @Override
    protected void determineNewPhase() {
        if ("Embarking".equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Travelling".equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                this.setPhase("Disembarking");
                this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getSettlement().getName());
            } else {
                this.setPhase(EXPLORE_SITE);
                this.setPhaseDescription("Exploring site at " + this.getCurrentNavpoint().getDescription());
            }
        } else if (EXPLORE_SITE.equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Disembarking".equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (EXPLORE_SITE.equals(this.getPhase())) {
            this.exploringPhase(person);
        }
    }

    public void endExplorationAtSite() {
        logger.info("Explore site phase ended due to external trigger.");
        this.endExploringSite = true;
        Iterator<Person> i = this.getPeople().iterator();
        while (i.hasNext()) {
            Task task = i.next().getMind().getTaskManager().getTask();
            if (!(task instanceof ExploreSite)) continue;
            ((ExploreSite)task).endEVA();
        }
    }

    private void exploringPhase(Person person) {
        double completion;
        if (this.currentSite == null) {
            this.createNewExploredSite();
            this.explorationSiteStartTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        }
        boolean timeExpired = false;
        MarsClock currentTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        double timeDiff = MarsClock.getTimeDiff(currentTime, this.explorationSiteStartTime);
        if (timeDiff >= 1000.0) {
            timeExpired = true;
        }
        if ((completion = timeDiff / 1000.0) > 1.0) {
            completion = 1.0;
        } else if (completion < 0.0) {
            completion = 0.0;
        }
        this.explorationSiteCompletion.put(this.getCurrentNavpoint().getDescription(), completion);
        this.fireMissionUpdate(SITE_EXPLORATION_EVENT, this.getCurrentNavpoint().getDescription());
        if (this.isEveryoneInRover()) {
            if (this.endExploringSite) {
                this.endExploringSite = false;
                this.setPhaseEnded(true);
            }
            if (timeExpired) {
                this.setPhaseEnded(true);
            }
            boolean nobodyExplore = true;
            Iterator<Person> j = this.getPeople().iterator();
            while (j.hasNext()) {
                if (!ExploreSite.canExploreSite(j.next(), this.getRover())) continue;
                nobodyExplore = false;
            }
            Mars mars = Simulation.instance().getMars();
            boolean inDarkPolarRegion = mars.getSurfaceFeatures().inDarkPolarRegion(this.getCurrentMissionLocation());
            double sunlight = mars.getSurfaceFeatures().getSurfaceSunlight(this.getCurrentMissionLocation());
            if (nobodyExplore && (sunlight > 0.0 || inDarkPolarRegion)) {
                this.setPhaseEnded(true);
            }
            if (this.hasEmergency()) {
                this.setPhaseEnded(true);
            }
            if (!this.hasEnoughResourcesForRemainingMission(false)) {
                this.determineEmergencyDestination(person);
                this.setPhaseEnded(true);
            }
        } else if (timeExpired) {
            Iterator<Person> i = this.getPeople().iterator();
            while (i.hasNext()) {
                Task task = i.next().getMind().getTaskManager().getTask();
                if (task == null || !(task instanceof ExploreSite)) continue;
                ((ExploreSite)task).endEVA();
            }
        }
        if (!this.getPhaseEnded()) {
            if (!this.endExploringSite && !timeExpired && ExploreSite.canExploreSite(person, this.getRover())) {
                this.assignTask(person, new ExploreSite(person, this.currentSite, (Rover)this.getVehicle()));
            }
        } else {
            this.currentSite.setExplored(true);
            this.currentSite = null;
        }
    }

    private void createNewExploredSite() {
        SurfaceFeatures surfaceFeatures = Simulation.instance().getMars().getSurfaceFeatures();
        MineralMap mineralMap = surfaceFeatures.getMineralMap();
        String[] mineralTypes = mineralMap.getMineralTypeNames();
        HashMap<String, Double> initialMineralEstimations = new HashMap<String, Double>(mineralTypes.length);
        for (String mineralType : mineralTypes) {
            double estimation = RandomUtil.getRandomDouble(40.0) - 20.0;
            double actualConcentration = mineralMap.getMineralConcentration(mineralType, this.getCurrentMissionLocation());
            if ((estimation += actualConcentration) < 0.0) {
                estimation = 0.0 - estimation;
            } else if (estimation > 100.0) {
                estimation = 100.0 - estimation;
            }
            initialMineralEstimations.put(mineralType, estimation);
        }
        this.currentSite = surfaceFeatures.addExploredLocation(new Coordinates(this.getCurrentMissionLocation()), initialMineralEstimations, this.getAssociatedSettlement());
        this.exploredSites.add(this.currentSite);
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.getStartingSettlement();
    }

    @Override
    protected void recruitPeopleForMission(Person startingPerson) {
        Person lastPerson;
        super.recruitPeopleForMission(startingPerson);
        if (!Exploration.atLeastOnePersonRemainingAtSettlement(this.getStartingSettlement(), startingPerson) && (lastPerson = (Person)this.getPeople().toArray()[this.getPeopleNumber() - 1]) != null) {
            lastPerson.getMind().setMission(null);
            if (this.getPeopleNumber() < this.getMinPeople()) {
                this.endMission("Not enough members.");
            }
        }
    }

    @Override
    public double getEstimatedRemainingMissionTime(boolean useBuffer) {
        double result = super.getEstimatedRemainingMissionTime(useBuffer);
        return result += this.getEstimatedRemainingExplorationSiteTime();
    }

    private double getEstimatedRemainingExplorationSiteTime() {
        MarsClock currentTime;
        double timeSpentAtExplorationSite;
        double remainingTime;
        double result = 0.0;
        if (EXPLORE_SITE.equals(this.getPhase()) && (remainingTime = 1000.0 - (timeSpentAtExplorationSite = MarsClock.getTimeDiff(currentTime = Simulation.instance().getMasterClock().getMarsClock(), this.explorationSiteStartTime))) > 0.0) {
            result += remainingTime;
        }
        int remainingExplorationSites = this.getNumExplorationSites() - this.getNumExplorationSitesVisited();
        return result += 1000.0 * (double)remainingExplorationSites;
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForRemainingMission(boolean useBuffer) {
        Map<Resource, Number> result = super.getResourcesNeededForRemainingMission(useBuffer);
        double explorationSitesTime = this.getEstimatedRemainingExplorationSiteTime();
        double timeSols = explorationSitesTime / 1000.0;
        int crewNum = this.getPeopleNumber();
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenAmount = PhysicalCondition.getOxygenConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(oxygen)) {
            oxygenAmount += ((Double)result.get(oxygen)).doubleValue();
        }
        result.put(oxygen, oxygenAmount);
        AmountResource water = AmountResource.findAmountResource("water");
        double waterAmount = PhysicalCondition.getWaterConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(water)) {
            waterAmount += ((Double)result.get(water)).doubleValue();
        }
        result.put(water, waterAmount);
        AmountResource food = AmountResource.findAmountResource("food");
        double foodAmount = PhysicalCondition.getFoodConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(food)) {
            foodAmount += ((Double)result.get(food)).doubleValue();
        }
        result.put(food, foodAmount);
        return result;
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.getStartingSettlement();
    }

    @Override
    protected int compareVehicles(Vehicle firstVehicle, Vehicle secondVehicle) {
        int result = super.compareVehicles(firstVehicle, secondVehicle);
        if (result == 0 && this.isUsableVehicle(firstVehicle) && this.isUsableVehicle(secondVehicle)) {
            boolean firstLab = ((Rover)firstVehicle).hasLab();
            boolean secondLab = ((Rover)secondVehicle).hasLab();
            if (firstLab && !secondLab) {
                result = 1;
            } else if (!firstLab && secondLab) {
                result = -1;
            }
        }
        return result;
    }

    protected double getEstimatedTimeAtExplorationSites() {
        return 1000.0 * (double)this.getNumExplorationSites();
    }

    public final int getNumExplorationSites() {
        return this.getNumberOfNavpoints() - 2;
    }

    public final int getNumExplorationSitesVisited() {
        int result = this.getCurrentNavpointIndex();
        if (result == this.getNumberOfNavpoints() - 1) {
            --result;
        }
        return result;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        if (this.equipmentNeededCache != null) {
            return this.equipmentNeededCache;
        }
        HashMap<Class, Integer> result = new HashMap<Class, Integer>();
        result.put(SpecimenContainer.class, 20);
        this.equipmentNeededCache = result;
        return result;
    }

    public static double getTotalTripTimeLimit(Rover rover, int memberNum, boolean useBuffer) {
        Inventory vInv = rover.getInventory();
        double timeLimit = Double.MAX_VALUE;
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        AmountResource food = AmountResource.findAmountResource("food");
        double foodConsumptionRate = config.getFoodConsumptionRate();
        double foodCapacity = vInv.getAmountResourceCapacity(food, false);
        double foodTimeLimit = foodCapacity / (foodConsumptionRate * (double)memberNum);
        if (foodTimeLimit < timeLimit) {
            timeLimit = foodTimeLimit;
        }
        AmountResource water = AmountResource.findAmountResource("water");
        double waterConsumptionRate = config.getWaterConsumptionRate();
        double waterCapacity = vInv.getAmountResourceCapacity(water, false);
        double waterTimeLimit = waterCapacity / (waterConsumptionRate * (double)memberNum);
        if (waterTimeLimit < timeLimit) {
            timeLimit = waterTimeLimit;
        }
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenConsumptionRate = config.getOxygenConsumptionRate();
        double oxygenCapacity = vInv.getAmountResourceCapacity(oxygen, false);
        double oxygenTimeLimit = oxygenCapacity / (oxygenConsumptionRate * (double)memberNum);
        if (oxygenTimeLimit < timeLimit) {
            timeLimit = oxygenTimeLimit;
        }
        timeLimit *= 1000.0;
        if (useBuffer) {
            timeLimit /= 3.0;
        }
        return timeLimit;
    }

    private void determineExplorationSites(double roverRange, double tripTimeLimit, int numSites, int areologySkill) {
        ArrayList<Coordinates> unorderedSites = new ArrayList<Coordinates>();
        double range = roverRange;
        double timeRange = this.getTripTimeRange(tripTimeLimit);
        if (timeRange < range) {
            range = timeRange;
        }
        Coordinates startingLocation = this.getCurrentMissionLocation();
        Coordinates newLocation = this.determineFirstExplorationSite(range / 2.0, areologySkill);
        if (newLocation == null) {
            throw new IllegalStateException(this.getPhase() + " : Could not determine first exploration site.");
        }
        unorderedSites.add(newLocation);
        double siteDistance = startingLocation.getDistance(newLocation);
        Coordinates currentLocation = newLocation;
        double remainingRange = range / 2.0 - siteDistance;
        for (int x = 1; x < numSites; ++x) {
            double currentDistanceToSettlement = currentLocation.getDistance(startingLocation);
            if (!(remainingRange > currentDistanceToSettlement)) continue;
            Direction direction = new Direction(RandomUtil.getRandomDouble(Math.PI * 2));
            double tempLimit1 = Math.pow(remainingRange, 2.0) - Math.pow(currentDistanceToSettlement, 2.0);
            double tempLimit2 = 2.0 * remainingRange - 2.0 * currentDistanceToSettlement * direction.getCosDirection();
            double limit = tempLimit1 / tempLimit2;
            siteDistance = RandomUtil.getRandomDouble(limit);
            newLocation = currentLocation.getNewLocation(direction, siteDistance);
            unorderedSites.add(newLocation);
            currentLocation = newLocation;
            remainingRange -= siteDistance;
        }
        ArrayList<Coordinates> sites = null;
        if (unorderedSites.size() > 1) {
            double unorderedSitesTotalDistance = this.getTotalDistance(startingLocation, unorderedSites);
            ArrayList<Coordinates> unorderedSites2 = new ArrayList<Coordinates>(unorderedSites);
            ArrayList<Coordinates> orderedSites = new ArrayList<Coordinates>(unorderedSites2.size());
            currentLocation = startingLocation;
            while (unorderedSites2.size() > 0) {
                Coordinates shortest = (Coordinates)unorderedSites2.get(0);
                double shortestDistance = currentLocation.getDistance(shortest);
                for (Coordinates site : unorderedSites2) {
                    double distance = currentLocation.getDistance(site);
                    if (!(distance < shortestDistance)) continue;
                    shortest = site;
                    shortestDistance = distance;
                }
                unorderedSites2.remove(shortest);
                orderedSites.add(shortest);
                currentLocation = shortest;
            }
            double orderedSitesTotalDistance = this.getTotalDistance(startingLocation, orderedSites);
            sites = unorderedSites;
            sites = orderedSitesTotalDistance < unorderedSitesTotalDistance ? orderedSites : unorderedSites;
        } else {
            sites = unorderedSites;
        }
        int explorationSiteNum = 1;
        for (Coordinates site : sites) {
            String siteName = "exploration site " + explorationSiteNum;
            this.addNavpoint(new NavPoint(site, siteName));
            this.explorationSiteCompletion.put(siteName, 0.0);
            ++explorationSiteNum;
        }
    }

    private double getTotalDistance(Coordinates startingLoc, List<Coordinates> sites) {
        double result = 0.0;
        Coordinates currentLoc = startingLoc;
        for (Coordinates site : sites) {
            result += currentLoc.getDistance(site);
            currentLoc = site;
        }
        return result += currentLoc.getDistance(startingLoc);
    }

    private Coordinates determineFirstExplorationSite(double range, int areologySkill) {
        Coordinates result = null;
        Coordinates startingLocation = this.getCurrentMissionLocation();
        MineralMap map = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap();
        Coordinates randomLocation = map.findRandomMineralLocation(startingLocation, range);
        if (randomLocation != null) {
            double distance;
            double distanceFromStart;
            Direction direction = new Direction(RandomUtil.getRandomDouble(Math.PI * 2));
            if (areologySkill <= 0) {
                areologySkill = 1;
            }
            if ((distanceFromStart = startingLocation.getDistance(result = randomLocation.getNewLocation(direction, distance = RandomUtil.getRandomDouble(500.0 / (double)areologySkill)))) > range) {
                Direction direction2 = startingLocation.getDirectionToPoint(result);
                result = startingLocation.getNewLocation(direction2, range);
            }
        } else {
            Direction direction = new Direction(RandomUtil.getRandomDouble(Math.PI * 2));
            double distance = RandomUtil.getRandomDouble(range);
            result = startingLocation.getNewLocation(direction, distance);
        }
        return result;
    }

    private double getTripTimeRange(double tripTimeLimit) {
        double timeAtSites = this.getEstimatedTimeAtExplorationSites();
        double tripTimeTravellingLimit = tripTimeLimit - timeAtSites;
        double averageSpeed = this.getAverageVehicleSpeedForOperators();
        double millisolsInHour = MarsClock.convertSecondsToMillisols(3600.0);
        double averageSpeedMillisol = averageSpeed / millisolsInHour;
        return tripTimeTravellingLimit * averageSpeedMillisol;
    }

    public List<ExploredLocation> getExploredSites() {
        return this.exploredSites;
    }

    public Map<String, Double> getExplorationSiteCompletion() {
        return new HashMap<String, Double>(this.explorationSiteCompletion);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.explorationSiteCompletion != null) {
            this.explorationSiteCompletion.clear();
        }
        this.explorationSiteCompletion = null;
        this.explorationSiteStartTime = null;
        this.currentSite = null;
        if (this.exploredSites != null) {
            this.exploredSites.clear();
        }
        this.exploredSites = null;
    }
}

