/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.mars.ExploredLocation;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.CollectMinedMinerals;
import org.mars_sim.msp.core.person.ai.task.MineSite;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class Mining
extends RoverMission {
    private static Logger logger = Logger.getLogger(Mining.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Mining";
    public static final String MINING_SITE = "Mining Site";
    public static final String EXCAVATE_MINERALS_EVENT = "excavate minerals";
    public static final String COLLECT_MINERALS_EVENT = "collect minerals";
    private static final int NUMBER_OF_BAGS = 20;
    private static final double MINERAL_BASE_AMOUNT = 1000.0;
    private static final double MINING_SITE_TIME = 3000.0;
    private static final double MINIMUM_COLLECT_AMOUNT = 10.0;
    public static final String PNEUMATIC_DRILL = "pneumatic drill";
    public static final String BACKHOE = "backhoe";
    private ExploredLocation miningSite;
    private MarsClock miningSiteStartTime;
    private boolean endMiningSite;
    private Map<AmountResource, Double> excavatedMinerals;
    private Map<AmountResource, Double> totalExcavatedMinerals;
    private LightUtilityVehicle luv;

    public Mining(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson, 2);
        if (!this.isDone()) {
            int availableSuitNum;
            if (this.hasVehicle()) {
                this.setMissionCapacity(this.getRover().getCrewCapacity());
            }
            if ((availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingPerson.getSettlement())) < this.getMissionCapacity()) {
                this.setMissionCapacity(availableSuitNum);
            }
            this.setStartingSettlement(startingPerson.getSettlement());
            this.excavatedMinerals = new HashMap<AmountResource, Double>(1);
            this.totalExcavatedMinerals = new HashMap<AmountResource, Double>(1);
            this.recruitPeopleForMission(startingPerson);
            try {
                if (this.hasVehicle()) {
                    this.miningSite = Mining.determineBestMiningSite(this.getRover(), this.getStartingSettlement());
                    this.miningSite.setReserved(true);
                    this.addNavpoint(new NavPoint(this.miningSite.getLocation(), "mining site"));
                }
            }
            catch (Exception e) {
                this.endMission("Mining site could not be determined.");
            }
            this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
            if (this.hasVehicle() && !this.isVehicleLoadable()) {
                this.endMission("Vehicle is not loadable. (Mining)");
            }
            if (!this.isDone()) {
                this.luv = this.reserveLightUtilityVehicle();
                if (this.luv == null) {
                    this.endMission("Light utility vehicle not available.");
                }
            }
        }
        this.addPhase(MINING_SITE);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
    }

    public Mining(Collection<Person> members, Settlement startingSettlement, ExploredLocation miningSite, Rover rover, LightUtilityVehicle luv, String description) {
        super(description, (Person)members.toArray()[0], 1, rover);
        this.setStartingSettlement(startingSettlement);
        this.miningSite = miningSite;
        miningSite.setReserved(true);
        this.excavatedMinerals = new HashMap<AmountResource, Double>(1);
        this.totalExcavatedMinerals = new HashMap<AmountResource, Double>(1);
        this.setMissionCapacity(this.getRover().getCrewCapacity());
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingSettlement);
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.addNavpoint(new NavPoint(miningSite.getLocation(), "mining site"));
        this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
        if (this.hasVehicle() && !this.isVehicleLoadable()) {
            this.endMission("Vehicle is not loadable. (Mining)");
        }
        this.luv = luv;
        if (luv == null) {
            this.endMission("Light utility vehicle not available.");
        } else {
            luv.setReservedForMission(true);
        }
        this.addPhase(MINING_SITE);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
    }

    public static double getNewMissionProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            Job job;
            int crowding;
            boolean enoughMethane;
            Settlement settlement = person.getSettlement();
            boolean reservableRover = RoverMission.areVehiclesAvailable(settlement, false);
            boolean backupRover = Mining.hasBackupRover(settlement);
            boolean minNum = RoverMission.minAvailablePeopleAtSettlement(settlement, 3);
            boolean enoughBags = false;
            int numBags = settlement.getInventory().findNumEmptyUnitsOfClass(Bag.class, false);
            enoughBags = numBags >= 20;
            boolean embarkingMissions = VehicleMission.hasEmbarkingMissions(settlement);
            boolean hasBasicResources = RoverMission.hasEnoughBasicResources(settlement);
            boolean reservableLUV = Mining.isLUVAvailable(settlement);
            boolean availableAttachmentParts = Mining.areAvailableAttachmentParts(settlement);
            AmountResource methane = AmountResource.findAmountResource("methane");
            boolean bl = enoughMethane = settlement.getInventory().getAmountResourceStored(methane, false) >= 1000.0;
            if (reservableRover && backupRover && minNum && enoughBags && !embarkingMissions && reservableLUV && availableAttachmentParts && hasBasicResources && enoughMethane) {
                try {
                    ExploredLocation miningSite;
                    Rover rover = (Rover)Mining.getVehicleWithGreatestRange(settlement, false);
                    if (rover != null && (miningSite = Mining.determineBestMiningSite(rover, settlement)) != null && (result = Mining.getMiningSiteValue(miningSite, settlement)) > 100.0) {
                        result = 100.0;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error getting mining site.", e);
                }
            }
            if ((crowding = settlement.getCurrentPopulationNum() - settlement.getPopulationCapacity()) > 0) {
                result *= (double)(crowding + 1);
            }
            if ((job = person.getMind().getJob()) != null) {
                result *= job.getStartMissionProbabilityModifier(Mining.class);
            }
        }
        if (result > 0.0 && Mission.getNumberAvailableEVASuitsAtSettlement(person.getSettlement()) < 2) {
            result = 0.0;
        }
        return result;
    }

    private static boolean isLUVAvailable(Settlement settlement) {
        boolean result = false;
        for (Vehicle vehicle : settlement.getParkedVehicles()) {
            if (!(vehicle instanceof LightUtilityVehicle)) continue;
            boolean usable = true;
            if (vehicle.isReserved()) {
                usable = false;
            }
            if (!vehicle.getStatus().equals("Parked")) {
                usable = false;
            }
            if (((Crewable)((Object)vehicle)).getCrewNum() > 0) {
                usable = false;
            }
            if (!usable) continue;
            result = true;
        }
        return result;
    }

    private static boolean areAvailableAttachmentParts(Settlement settlement) {
        boolean result = true;
        Inventory inv = settlement.getInventory();
        try {
            Part backhoe;
            Part pneumaticDrill = (Part)Part.findItemResource(PNEUMATIC_DRILL);
            if (!inv.hasItemResource(pneumaticDrill)) {
                result = false;
            }
            if (!inv.hasItemResource(backhoe = (Part)Part.findItemResource(BACKHOE))) {
                result = false;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting parts.");
        }
        return result;
    }

    @Override
    protected void determineNewPhase() {
        if ("Embarking".equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Travelling".equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                this.setPhase("Disembarking");
                this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getSettlement().getName());
            } else {
                this.setPhase(MINING_SITE);
                this.setPhaseDescription("Mining at " + this.getCurrentNavpoint().getDescription());
            }
        } else if (MINING_SITE.equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Disembarking".equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (MINING_SITE.equals(this.getPhase())) {
            this.miningPhase(person);
        }
    }

    @Override
    protected void performEmbarkFromSettlementPhase(Person person) {
        super.performEmbarkFromSettlementPhase(person);
        if (!this.isDone() && this.getRover().getTowedVehicle() == null) {
            try {
                Inventory settlementInv = this.getStartingSettlement().getInventory();
                Inventory luvInv = this.luv.getInventory();
                this.getRover().setTowedVehicle(this.luv);
                this.luv.setTowingVehicle(this.getRover());
                settlementInv.retrieveUnit(this.luv);
                Part pneumaticDrill = (Part)Part.findItemResource(PNEUMATIC_DRILL);
                settlementInv.retrieveItemResources(pneumaticDrill, 1);
                luvInv.storeItemResources(pneumaticDrill, 1);
                Part backhoe = (Part)Part.findItemResource(BACKHOE);
                settlementInv.retrieveItemResources(backhoe, 1);
                luvInv.storeItemResources(backhoe, 1);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error loading light utility vehicle and attachment parts.");
                this.endMission("Light utility vehicle and attachment parts could not be loaded.");
            }
        }
    }

    @Override
    protected void performDisembarkToSettlementPhase(Person person, Settlement disembarkSettlement) {
        if (!this.isDone() && this.getRover().getTowedVehicle() != null) {
            try {
                Inventory settlementInv = this.getStartingSettlement().getInventory();
                Inventory luvInv = this.luv.getInventory();
                this.getRover().setTowedVehicle(null);
                this.luv.setTowingVehicle(null);
                settlementInv.storeUnit(this.luv);
                this.luv.determinedSettlementParkedLocationAndFacing();
                Part pneumaticDrill = (Part)Part.findItemResource(PNEUMATIC_DRILL);
                luvInv.retrieveItemResources(pneumaticDrill, 1);
                settlementInv.storeItemResources(pneumaticDrill, 1);
                Part backhoe = (Part)Part.findItemResource(BACKHOE);
                luvInv.retrieveItemResources(backhoe, 1);
                settlementInv.storeItemResources(backhoe, 1);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error unloading light utility vehicle and attachment parts.");
                this.endMission("Light utility vehicle and attachment parts could not be unloaded.");
            }
        }
        super.performDisembarkToSettlementPhase(person, disembarkSettlement);
    }

    private void miningPhase(Person person) {
        if (this.miningSiteStartTime == null) {
            this.miningSiteStartTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        }
        if (this.getRover().getTowedVehicle() != null) {
            this.getRover().setTowedVehicle(null);
            this.luv.setTowingVehicle(null);
        }
        boolean timeExpired = false;
        MarsClock currentTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        if (MarsClock.getTimeDiff(currentTime, this.miningSiteStartTime) >= 3000.0) {
            timeExpired = true;
        }
        if (this.isEveryoneInRover()) {
            if (this.endMiningSite) {
                this.endMiningSite = false;
                this.setPhaseEnded(true);
            }
            if (timeExpired) {
                this.setPhaseEnded(true);
            }
            boolean nobodyMineOrCollect = true;
            for (Person personTemp : this.getPeople()) {
                if (MineSite.canMineSite(personTemp, this.getRover())) {
                    nobodyMineOrCollect = false;
                }
                if (!this.canCollectExcavatedMinerals(personTemp)) continue;
                nobodyMineOrCollect = false;
            }
            Mars mars = Simulation.instance().getMars();
            boolean inDarkPolarRegion = mars.getSurfaceFeatures().inDarkPolarRegion(this.getCurrentMissionLocation());
            double sunlight = mars.getSurfaceFeatures().getSurfaceSunlight(this.getCurrentMissionLocation());
            if (nobodyMineOrCollect && (sunlight > 0.0 || inDarkPolarRegion)) {
                this.setPhaseEnded(true);
            }
            if (this.hasEmergency()) {
                this.setPhaseEnded(true);
            }
            if (!this.hasEnoughResourcesForRemainingMission(false)) {
                this.determineEmergencyDestination(person);
                this.setPhaseEnded(true);
            }
        } else if (timeExpired) {
            Iterator<Person> i = this.getPeople().iterator();
            while (i.hasNext()) {
                Task task = i.next().getMind().getTaskManager().getTask();
                if (task instanceof MineSite) {
                    ((MineSite)task).endEVA();
                }
                if (!(task instanceof CollectMinedMinerals)) continue;
                ((CollectMinedMinerals)task).endEVA();
            }
        }
        if (!this.getPhaseEnded()) {
            if (RandomUtil.lessThanRandPercent(75.0) && !this.endMiningSite && !timeExpired) {
                if (this.canCollectExcavatedMinerals(person)) {
                    AmountResource mineralToCollect = this.getMineralToCollect(person);
                    this.assignTask(person, new CollectMinedMinerals(person, this.getRover(), mineralToCollect));
                } else if (MineSite.canMineSite(person, this.getRover())) {
                    this.assignTask(person, new MineSite(person, this.miningSite.getLocation(), (Rover)this.getVehicle(), this.luv));
                }
            }
        } else {
            this.miningSite.setMined(true);
            this.getRover().setTowedVehicle(this.luv);
            this.luv.setTowingVehicle(this.getRover());
        }
    }

    private boolean canCollectExcavatedMinerals(Person person) {
        boolean result = false;
        for (AmountResource resource : this.excavatedMinerals.keySet()) {
            if (!(this.excavatedMinerals.get(resource) >= 10.0) || !CollectMinedMinerals.canCollectMinerals(person, this.getRover(), resource)) continue;
            result = true;
        }
        return result;
    }

    private AmountResource getMineralToCollect(Person person) {
        AmountResource result = null;
        double largestAmount = 0.0;
        for (AmountResource resource : this.excavatedMinerals.keySet()) {
            double amount;
            if (!(this.excavatedMinerals.get(resource) >= 10.0) || !CollectMinedMinerals.canCollectMinerals(person, this.getRover(), resource) || !((amount = this.excavatedMinerals.get(resource).doubleValue()) > largestAmount)) continue;
            result = resource;
            largestAmount = amount;
        }
        return result;
    }

    public void endMiningAtSite() {
        logger.info("Mining site phase ended due to external trigger.");
        this.endMiningSite = true;
        Iterator<Person> i = this.getPeople().iterator();
        while (i.hasNext()) {
            Task task = i.next().getMind().getTaskManager().getTask();
            if (task instanceof MineSite) {
                ((MineSite)task).endEVA();
            }
            if (!(task instanceof CollectMinedMinerals)) continue;
            ((CollectMinedMinerals)task).endEVA();
        }
    }

    private static ExploredLocation determineBestMiningSite(Rover rover, Settlement homeSettlement) {
        ExploredLocation result = null;
        double bestValue = 0.0;
        try {
            double roverRange = rover.getRange();
            double tripTimeLimit = Mining.getTotalTripTimeLimit(rover, rover.getCrewCapacity(), true);
            double tripRange = Mining.getTripTimeRange(tripTimeLimit, rover.getBaseSpeed() / 2.0);
            double range = roverRange;
            if (tripRange < range) {
                range = tripRange;
            }
            for (ExploredLocation site : Simulation.instance().getMars().getSurfaceFeatures().getExploredLocations()) {
                double value;
                if (site.isMined() || site.isReserved() || !site.isExplored()) continue;
                Coordinates siteLocation = site.getLocation();
                Coordinates homeLocation = homeSettlement.getCoordinates();
                if (!(homeLocation.getDistance(siteLocation) <= range / 2.0) || !((value = Mining.getMiningSiteValue(site, homeSettlement)) > bestValue)) continue;
                result = site;
                bestValue = value;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error determining best mining site.");
        }
        return result;
    }

    private static double getMiningSiteValue(ExploredLocation site, Settlement settlement) {
        double result = 0.0;
        Map<String, Double> concentrations = site.getEstimatedMineralConcentrations();
        for (String mineralType : concentrations.keySet()) {
            AmountResource mineralResource = AmountResource.findAmountResource(mineralType);
            Good mineralGood = GoodsUtil.getResourceGood(mineralResource);
            double mineralValue = settlement.getGoodsManager().getGoodValuePerItem(mineralGood);
            double concentration = concentrations.get(mineralType);
            double mineralAmount = concentration / 100.0 * 1000.0;
            result += mineralValue * mineralAmount;
        }
        return result;
    }

    private static double getTotalTripTimeLimit(Rover rover, int memberNum, boolean useBuffer) {
        Inventory vInv = rover.getInventory();
        double timeLimit = Double.MAX_VALUE;
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        AmountResource food = AmountResource.findAmountResource("food");
        double foodConsumptionRate = config.getFoodConsumptionRate();
        double foodCapacity = vInv.getAmountResourceCapacity(food, false);
        double foodTimeLimit = foodCapacity / (foodConsumptionRate * (double)memberNum);
        if (foodTimeLimit < timeLimit) {
            timeLimit = foodTimeLimit;
        }
        AmountResource water = AmountResource.findAmountResource("water");
        double waterConsumptionRate = config.getWaterConsumptionRate();
        double waterCapacity = vInv.getAmountResourceCapacity(water, false);
        double waterTimeLimit = waterCapacity / (waterConsumptionRate * (double)memberNum);
        if (waterTimeLimit < timeLimit) {
            timeLimit = waterTimeLimit;
        }
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenConsumptionRate = config.getOxygenConsumptionRate();
        double oxygenCapacity = vInv.getAmountResourceCapacity(oxygen, false);
        double oxygenTimeLimit = oxygenCapacity / (oxygenConsumptionRate * (double)memberNum);
        if (oxygenTimeLimit < timeLimit) {
            timeLimit = oxygenTimeLimit;
        }
        timeLimit *= 1000.0;
        if (useBuffer) {
            timeLimit /= 3.0;
        }
        return timeLimit;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        if (this.equipmentNeededCache != null) {
            return this.equipmentNeededCache;
        }
        HashMap<Class, Integer> result = new HashMap<Class, Integer>();
        result.put(Bag.class, 20);
        this.equipmentNeededCache = result;
        return result;
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.getStartingSettlement();
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.getStartingSettlement();
    }

    @Override
    protected void recruitPeopleForMission(Person startingPerson) {
        Person lastPerson;
        super.recruitPeopleForMission(startingPerson);
        if (!Mining.atLeastOnePersonRemainingAtSettlement(this.getStartingSettlement(), startingPerson) && (lastPerson = (Person)this.getPeople().toArray()[this.getPeopleNumber() - 1]) != null) {
            lastPerson.getMind().setMission(null);
            if (this.getPeopleNumber() < this.getMinPeople()) {
                this.endMission("Not enough members.");
            }
        }
    }

    @Override
    public double getEstimatedRemainingMissionTime(boolean useBuffer) {
        double result = super.getEstimatedRemainingMissionTime(useBuffer);
        return result += this.getEstimatedRemainingMiningSiteTime();
    }

    private double getEstimatedRemainingMiningSiteTime() {
        double result = 0.0;
        if (MINING_SITE.equals(this.getPhase())) {
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            double timeSpentAtMiningSite = MarsClock.getTimeDiff(currentTime, this.miningSiteStartTime);
            double remainingTime = 3000.0 - timeSpentAtMiningSite;
            if (remainingTime > 0.0) {
                result = remainingTime;
            }
        } else if (this.miningSiteStartTime == null) {
            result = 3000.0;
        }
        return result;
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForRemainingMission(boolean useBuffer) {
        Map<Resource, Number> result = super.getResourcesNeededForRemainingMission(useBuffer);
        double miningSiteTime = this.getEstimatedRemainingMiningSiteTime();
        double timeSols = miningSiteTime / 1000.0;
        int crewNum = this.getPeopleNumber();
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenAmount = PhysicalCondition.getOxygenConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(oxygen)) {
            oxygenAmount += ((Double)result.get(oxygen)).doubleValue();
        }
        result.put(oxygen, oxygenAmount);
        AmountResource water = AmountResource.findAmountResource("water");
        double waterAmount = PhysicalCondition.getWaterConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(water)) {
            waterAmount += ((Double)result.get(water)).doubleValue();
        }
        result.put(water, waterAmount);
        AmountResource food = AmountResource.findAmountResource("food");
        double foodAmount = PhysicalCondition.getFoodConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(food)) {
            foodAmount += ((Double)result.get(food)).doubleValue();
        }
        result.put(food, foodAmount);
        return result;
    }

    private static double getTripTimeRange(double tripTimeLimit, double averageSpeed) {
        double tripTimeTravellingLimit = tripTimeLimit - 3000.0;
        double millisolsInHour = MarsClock.convertSecondsToMillisols(3600.0);
        double averageSpeedMillisol = averageSpeed / millisolsInHour;
        return tripTimeTravellingLimit * averageSpeedMillisol;
    }

    public ExploredLocation getMiningSite() {
        return this.miningSite;
    }

    @Override
    public void endMission(String reason) {
        super.endMission(reason);
        if (this.miningSite != null) {
            this.miningSite.setReserved(false);
        }
        if (this.luv != null) {
            this.luv.setReservedForMission(false);
        }
    }

    private LightUtilityVehicle reserveLightUtilityVehicle() {
        LightUtilityVehicle result = null;
        Iterator<Vehicle> i = this.getStartingSettlement().getParkedVehicles().iterator();
        while (i.hasNext() && result == null) {
            LightUtilityVehicle luvTemp;
            Vehicle vehicle = i.next();
            if (!(vehicle instanceof LightUtilityVehicle) || !(luvTemp = (LightUtilityVehicle)vehicle).getStatus().equals("Parked") || luvTemp.isReserved() || luvTemp.getCrewNum() != 0) continue;
            result = luvTemp;
            luvTemp.setReservedForMission(true);
        }
        return result;
    }

    public LightUtilityVehicle getLightUtilityVehicle() {
        return this.luv;
    }

    public double getMineralExcavationAmount(AmountResource mineral) {
        if (this.excavatedMinerals.containsKey(mineral)) {
            return this.excavatedMinerals.get(mineral);
        }
        return 0.0;
    }

    public double getTotalMineralExcavatedAmount(AmountResource mineral) {
        if (this.totalExcavatedMinerals.containsKey(mineral)) {
            return this.totalExcavatedMinerals.get(mineral);
        }
        return 0.0;
    }

    public void excavateMineral(AmountResource mineral, double amount) {
        double currentExcavated = amount;
        if (this.excavatedMinerals.containsKey(mineral)) {
            currentExcavated += this.excavatedMinerals.get(mineral).doubleValue();
        }
        this.excavatedMinerals.put(mineral, currentExcavated);
        double totalExcavated = amount;
        if (this.totalExcavatedMinerals.containsKey(mineral)) {
            totalExcavated += this.totalExcavatedMinerals.get(mineral).doubleValue();
        }
        this.totalExcavatedMinerals.put(mineral, totalExcavated);
        this.fireMissionUpdate(EXCAVATE_MINERALS_EVENT);
    }

    public void collectMineral(AmountResource mineral, double amount) {
        double currentExcavated = 0.0;
        if (this.excavatedMinerals.containsKey(mineral)) {
            currentExcavated = this.excavatedMinerals.get(mineral);
        }
        if (!(currentExcavated >= amount)) {
            throw new IllegalStateException(mineral.getName() + " amount: " + amount + " more than currently excavated.");
        }
        this.excavatedMinerals.put(mineral, currentExcavated - amount);
        this.fireMissionUpdate(COLLECT_MINERALS_EVENT);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.miningSite = null;
        this.miningSiteStartTime = null;
        if (this.excavatedMinerals != null) {
            this.excavatedMinerals.clear();
        }
        this.excavatedMinerals = null;
        if (this.totalExcavatedMinerals != null) {
            this.totalExcavatedMinerals.clear();
        }
        this.totalExcavatedMinerals = null;
        this.luv = null;
    }
}

