/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionHistoricalEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionListener;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;

public abstract class Mission
implements Serializable {
    private static Logger logger = Logger.getLogger(Mission.class.getName());
    public static final String NAME_EVENT = "name";
    public static final String DESCRIPTION_EVENT = "description";
    public static final String PHASE_EVENT = "phase";
    public static final String PHASE_DESCRIPTION_EVENT = "phase description";
    public static final String MIN_PEOPLE_EVENT = "minimum people";
    public static final String ASSOCIATED_SETTLEMENT_EVENT = "associated settlement";
    public static final String CAPACITY_EVENT = "capacity";
    public static final String ADD_MEMBER_EVENT = "remove member";
    public static final String REMOVE_MEMBER_EVENT = "add member";
    public static final String END_MISSION_EVENT = "end mission";
    private Collection<Person> people;
    private String name;
    private String description;
    private int minPeople;
    private boolean done;
    private Collection<String> phases;
    private String phase;
    private String phaseDescription;
    private boolean phaseEnded;
    private int missionCapacity;
    private transient List<MissionListener> listeners;

    public Mission(String name, Person startingPerson, int minPeople) {
        this.name = name;
        this.description = name;
        this.people = new ConcurrentLinkedQueue<Person>();
        this.done = false;
        this.phase = null;
        this.phaseDescription = null;
        this.phases = new ArrayList<String>();
        this.phaseEnded = false;
        this.minPeople = minPeople;
        this.missionCapacity = Integer.MAX_VALUE;
        this.listeners = Collections.synchronizedList(new ArrayList());
        MissionHistoricalEvent newEvent = new MissionHistoricalEvent(startingPerson, this, "Mission Started");
        Simulation.instance().getEventManager().registerNewEvent(newEvent);
        logger.info(this.description + " started by " + startingPerson.getName() + " at " + startingPerson.getSettlement());
        startingPerson.getMind().setMission(this);
    }

    public final void addMissionListener(MissionListener newListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public final void removeMissionListener(MissionListener oldListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.listeners.contains(oldListener)) {
            this.listeners.remove(oldListener);
        }
    }

    protected final void fireMissionUpdate(String updateType) {
        this.fireMissionUpdate(updateType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireMissionUpdate(String updateType, Object target) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        List<MissionListener> list = this.listeners;
        synchronized (list) {
            Iterator<MissionListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().missionUpdate(new MissionEvent(this, updateType, target));
            }
        }
    }

    public String toString() {
        return this.description;
    }

    public final void addPerson(Person person) {
        if (!this.people.contains(person)) {
            this.people.add(person);
            MissionHistoricalEvent newEvent = new MissionHistoricalEvent(person, this, "Mission Joined");
            Simulation.instance().getEventManager().registerNewEvent(newEvent);
            this.fireMissionUpdate(ADD_MEMBER_EVENT, person);
            logger.finer(person.getName() + " added to mission: " + this.name);
        }
    }

    public final void removePerson(Person person) {
        if (this.people.contains(person)) {
            this.people.remove(person);
            MissionHistoricalEvent newEvent = new MissionHistoricalEvent(person, this, "Mission Finished");
            Simulation.instance().getEventManager().registerNewEvent(newEvent);
            this.fireMissionUpdate(REMOVE_MEMBER_EVENT, person);
            if (this.people.size() == 0 && !this.done) {
                this.endMission("Not enough members.");
            }
            logger.finer(person.getName() + " removed from mission: " + this.name);
        }
    }

    public final boolean hasPerson(Person person) {
        return this.people.contains(person);
    }

    public final int getPeopleNumber() {
        return this.people.size();
    }

    public final int getMinPeople() {
        return this.minPeople;
    }

    protected final void setMinPeople(int minPeople) {
        this.minPeople = minPeople;
        this.fireMissionUpdate(MIN_PEOPLE_EVENT, minPeople);
    }

    public final Collection<Person> getPeople() {
        return new ConcurrentLinkedQueue<Person>(this.people);
    }

    public final boolean isDone() {
        return this.done;
    }

    public final String getName() {
        return this.name;
    }

    protected final void setName(String name) {
        this.name = name;
        this.fireMissionUpdate(NAME_EVENT, name);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.description = description;
            this.fireMissionUpdate(DESCRIPTION_EVENT, description);
        }
    }

    public final String getPhase() {
        return this.phase;
    }

    protected final void setPhase(String newPhase) {
        if (newPhase == null) {
            throw new IllegalArgumentException("newPhase is null");
        }
        if (!this.phases.contains(newPhase)) {
            throw new IllegalStateException(this.phase + " : newPhase: " + newPhase + " is not a valid phase for this mission.");
        }
        this.phase = newPhase;
        this.setPhaseEnded(false);
        this.phaseDescription = null;
        this.fireMissionUpdate(PHASE_EVENT, newPhase);
    }

    public final void addPhase(String newPhase) {
        if (newPhase == null) {
            throw new IllegalArgumentException("newPhase is null");
        }
        if (!this.phases.contains(newPhase)) {
            this.phases.add(newPhase);
        }
    }

    public final String getPhaseDescription() {
        if (this.phaseDescription != null) {
            return this.phaseDescription;
        }
        return this.phase;
    }

    protected final void setPhaseDescription(String description) {
        this.phaseDescription = description;
        this.fireMissionUpdate(PHASE_DESCRIPTION_EVENT, description);
    }

    public void performMission(Person person) {
        if (this.phaseEnded) {
            this.determineNewPhase();
        }
        if (!this.done) {
            this.performPhase(person);
        }
    }

    protected abstract void determineNewPhase();

    protected void performPhase(Person person) {
        if (this.phase == null) {
            this.endMission("Current mission phase is null.");
        }
    }

    public final int getMissionCapacity() {
        return this.missionCapacity;
    }

    protected final void setMissionCapacity(int newCapacity) {
        this.missionCapacity = newCapacity;
        this.fireMissionUpdate(CAPACITY_EVENT, newCapacity);
    }

    public void endMission(String reason) {
        if (!this.done) {
            Object[] p;
            this.done = true;
            this.fireMissionUpdate(END_MISSION_EVENT);
            for (Object aP : p = this.people.toArray()) {
                this.removePerson((Person)aP);
            }
            logger.info(this.description + " ending at " + this.phase + " due to " + reason);
        }
    }

    protected void assignTask(Person person, Task task) {
        boolean canPerformTask = true;
        if (task.isEffortDriven() && person.getPerformanceRating() < 0.5) {
            canPerformTask = false;
        }
        if (canPerformTask) {
            person.getMind().getTaskManager().addTask(task);
        }
    }

    protected final boolean hasDangerousMedicalProblems() {
        boolean result = false;
        Iterator<Person> i = this.people.iterator();
        while (i.hasNext()) {
            if (!i.next().getPhysicalCondition().hasSeriousMedicalProblems()) continue;
            result = true;
        }
        return result;
    }

    protected final boolean hasDangerousMedicalProblemsAllCrew() {
        boolean result = true;
        Iterator<Person> i = this.people.iterator();
        while (i.hasNext()) {
            if (i.next().getPhysicalCondition().hasSeriousMedicalProblems()) continue;
            result = false;
        }
        return result;
    }

    protected boolean hasEmergency() {
        return this.hasDangerousMedicalProblems();
    }

    protected boolean hasEmergencyAllCrew() {
        return this.hasDangerousMedicalProblemsAllCrew();
    }

    protected void recruitPeopleForMission(Person startingPerson) {
        int count = 0;
        block2: while (count < 4) {
            ++count;
            ConcurrentLinkedQueue<Person> qualifiedPeople = new ConcurrentLinkedQueue<Person>();
            for (Person person : Simulation.instance().getUnitManager().getPeople()) {
                if (!this.isCapableOfMission(person)) continue;
                qualifiedPeople.add(person);
            }
            try {
                while (qualifiedPeople.size() > 0) {
                    double bestPersonValue = 0.0;
                    Person bestPerson = null;
                    Iterator j = qualifiedPeople.iterator();
                    while (j.hasNext() && this.getPeopleNumber() < this.missionCapacity) {
                        RelationshipManager relationshipManager;
                        double likability;
                        Person person = (Person)j.next();
                        double qualification = this.getMissionQualification(person) * 100.0;
                        double personValue = (qualification + (likability = (relationshipManager = Simulation.instance().getRelationshipManager()).getOpinionOfPerson(startingPerson, person))) / 2.0;
                        if (!(personValue > bestPersonValue)) continue;
                        bestPerson = person;
                        bestPersonValue = personValue;
                    }
                    if (bestPerson == null) continue block2;
                    this.recruitPerson(startingPerson, bestPerson);
                    qualifiedPeople.remove(bestPerson);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (this.getPeopleNumber() < this.minPeople) {
            this.endMission("Not enough members");
        }
    }

    private void recruitPerson(Person recruiter, Person recruitee) {
        if (this.isCapableOfMission(recruitee)) {
            double groupLikability;
            RelationshipManager relationshipManager;
            double recruiterLikability;
            double qualification = this.getMissionQualification(recruitee) * 100.0;
            double recruitmentChance = (qualification + (recruiterLikability = (relationshipManager = Simulation.instance().getRelationshipManager()).getOpinionOfPerson(recruitee, recruiter)) + (groupLikability = relationshipManager.getAverageOpinionOfPeople(recruitee, this.people))) / 3.0;
            if (recruitmentChance > 100.0) {
                recruitmentChance = 100.0;
            } else if (recruitmentChance < 0.0) {
                recruitmentChance = 0.0;
            }
            if (RandomUtil.lessThanRandPercent(recruitmentChance)) {
                recruitee.getMind().setMission(this);
            }
        }
    }

    protected boolean isCapableOfMission(Person person) {
        if (person == null) {
            throw new IllegalArgumentException("person is null");
        }
        return person.getMind().getMission() == null && !person.getPhysicalCondition().hasSeriousMedicalProblems();
    }

    protected double getMissionQualification(Person person) {
        Job job;
        double result = 0.0;
        if (this.isCapableOfMission(person) && (job = person.getMind().getJob()) != null) {
            result = job.getJoinMissionProbabilityModifier(this.getClass());
        }
        return result;
    }

    public final boolean getPhaseEnded() {
        return this.phaseEnded;
    }

    protected final void setPhaseEnded(boolean phaseEnded) {
        this.phaseEnded = phaseEnded;
    }

    public abstract Settlement getAssociatedSettlement();

    public abstract Map<Resource, Number> getResourcesNeededForRemainingMission(boolean var1);

    public abstract Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean var1);

    public void timePassing(double time) {
    }

    public void associateAllMembersWithSettlement(Settlement settlement) {
        Iterator<Person> i = this.people.iterator();
        while (i.hasNext()) {
            i.next().setAssociatedSettlement(settlement);
        }
    }

    public final Coordinates getCurrentMissionLocation() {
        if (this.getPeopleNumber() > 0) {
            return ((Person)this.people.toArray()[0]).getCoordinates();
        }
        throw new IllegalStateException(this.phase + " : No people in the mission.");
    }

    static int getNumberAvailableEVASuitsAtSettlement(Settlement settlement) {
        int result = 0;
        result = settlement.getInventory().findNumUnitsOfClass(EVASuit.class);
        if (result > 0) {
            --result;
        }
        return result;
    }

    public void destroy() {
        if (this.people != null) {
            this.people.clear();
        }
        this.people = null;
        this.name = null;
        this.description = null;
        if (this.phases != null) {
            this.phases.clear();
        }
        this.phases = null;
        this.phase = null;
        this.phaseDescription = null;
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }
}

