/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.AreologyStudyFieldMission;
import org.mars_sim.msp.core.person.ai.mission.BiologyStudyFieldMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.BuildingSalvageMission;
import org.mars_sim.msp.core.person.ai.mission.CollectIce;
import org.mars_sim.msp.core.person.ai.mission.CollectRegolith;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.Exploration;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManagerListener;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.Trade;
import org.mars_sim.msp.core.person.ai.mission.TravelToSettlement;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class MissionManager
implements Serializable {
    private static transient Logger logger = Logger.getLogger(MissionManager.class.getName());
    private List<Mission> missions = new ArrayList<Mission>(0);
    private transient List<MissionManagerListener> listeners = Collections.synchronizedList(new ArrayList(0));
    private Person personCache;
    private MarsClock timeCache;
    private Map<Class<? extends Mission>, Double> missionProbCache;
    private double totalProbCache;
    private Class<? extends Mission>[] potentialMissions = new Class[12];

    public MissionManager() {
        this.potentialMissions[0] = TravelToSettlement.class;
        this.potentialMissions[1] = Exploration.class;
        this.potentialMissions[2] = CollectIce.class;
        this.potentialMissions[3] = RescueSalvageVehicle.class;
        this.potentialMissions[4] = Trade.class;
        this.potentialMissions[5] = CollectRegolith.class;
        this.potentialMissions[6] = Mining.class;
        this.potentialMissions[7] = BuildingConstructionMission.class;
        this.potentialMissions[8] = AreologyStudyFieldMission.class;
        this.potentialMissions[9] = BiologyStudyFieldMission.class;
        this.potentialMissions[10] = BuildingSalvageMission.class;
        this.potentialMissions[11] = EmergencySupplyMission.class;
        this.personCache = null;
        this.timeCache = null;
        this.missionProbCache = new HashMap<Class<? extends Mission>, Double>(this.potentialMissions.length);
        this.totalProbCache = 0.0;
    }

    public void addListener(MissionManagerListener newListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public void removeListener(MissionManagerListener oldListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.listeners.contains(oldListener)) {
            this.listeners.remove(oldListener);
        }
    }

    public int getNumActiveMissions() {
        this.cleanMissions();
        return this.missions.size();
    }

    public List<Mission> getMissions() {
        this.cleanMissions();
        return new ArrayList<Mission>(this.missions);
    }

    public Mission getMission(Person person) {
        Mission result = null;
        for (Mission tempMission : this.missions) {
            if (!tempMission.hasPerson(person)) continue;
            result = tempMission;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMission(Mission newMission) {
        if (newMission == null) {
            throw new IllegalArgumentException("newMission is null");
        }
        if (!this.missions.contains(newMission)) {
            this.missions.add(newMission);
            if (this.listeners == null) {
                this.listeners = Collections.synchronizedList(new ArrayList());
            }
            List<MissionManagerListener> list = this.listeners;
            synchronized (list) {
                Iterator<MissionManagerListener> i = this.listeners.iterator();
                while (i.hasNext()) {
                    i.next().addMission(newMission);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("MissionManager: Added new mission - " + newMission.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMission(Mission oldMission) {
        if (this.missions.contains(oldMission)) {
            this.missions.remove(oldMission);
            if (this.listeners == null) {
                this.listeners = Collections.synchronizedList(new ArrayList());
            }
            List<MissionManagerListener> list = this.listeners;
            synchronized (list) {
                Iterator<MissionManagerListener> i = this.listeners.iterator();
                while (i.hasNext()) {
                    i.next().removeMission(oldMission);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("MissionManager: Removed old mission - " + oldMission.getName());
            }
        }
    }

    public double getTotalMissionProbability(Person person) {
        if (!this.useCache(person)) {
            this.calculateProbability(person);
        }
        return this.totalProbCache;
    }

    public Mission getNewMission(Person person) {
        if (!this.useCache(person)) {
            this.calculateProbability(person);
        }
        double r = RandomUtil.getRandomDouble(this.getTotalMissionProbability(person));
        Class<? extends Mission> selectedMission = null;
        for (Class<? extends Mission> mission : this.missionProbCache.keySet()) {
            double probWeight = this.missionProbCache.get(mission);
            if (selectedMission != null) continue;
            if (r < probWeight) {
                selectedMission = mission;
                continue;
            }
            r -= probWeight;
        }
        Class[] parametersForFindingConstructor = new Class[]{Person.class};
        Object[] parametersForInvokingConstructor = new Object[]{person};
        if (selectedMission != null) {
            try {
                Constructor<? extends Mission> construct = selectedMission.getConstructor(parametersForFindingConstructor);
                return construct.newInstance(parametersForInvokingConstructor);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "MissionManager.getNewMission()", e);
                return null;
            }
        }
        logger.log(Level.SEVERE, "MissionManager.getNewMission() - selected mission is null");
        return null;
    }

    public List<Mission> getMissionsForSettlement(Settlement settlement) {
        if (settlement == null) {
            throw new IllegalArgumentException("settlement is null");
        }
        ArrayList<Mission> settlementMissions = new ArrayList<Mission>();
        for (Mission mission : this.getMissions()) {
            if (mission.isDone() || settlement != mission.getAssociatedSettlement()) continue;
            settlementMissions.add(mission);
        }
        return settlementMissions;
    }

    public Mission getMissionForVehicle(Vehicle vehicle) {
        if (vehicle == null) {
            throw new IllegalArgumentException("vehicle is null");
        }
        Mission result = null;
        for (Mission mission : this.getMissions()) {
            BuildingSalvageMission salvage;
            if (mission.isDone()) continue;
            if (mission instanceof VehicleMission) {
                Rover towingRover;
                if (((VehicleMission)mission).getVehicle() == vehicle) {
                    result = mission;
                }
                if (mission instanceof Mining && ((Mining)mission).getLightUtilityVehicle() == vehicle) {
                    result = mission;
                }
                if (!(mission instanceof Trade) || (towingRover = (Rover)((Trade)mission).getVehicle()) == null || towingRover.getTowedVehicle() != vehicle) continue;
                result = mission;
                continue;
            }
            if (mission instanceof BuildingConstructionMission) {
                BuildingConstructionMission construction = (BuildingConstructionMission)mission;
                if (!construction.getConstructionVehicles().contains(vehicle)) continue;
                result = mission;
                continue;
            }
            if (!(mission instanceof BuildingSalvageMission) || !(salvage = (BuildingSalvageMission)mission).getConstructionVehicles().contains(vehicle)) continue;
            result = mission;
        }
        return result;
    }

    private void cleanMissions() {
        int index = 0;
        while (index < this.missions.size()) {
            Mission tempMission = this.missions.get(index);
            if (tempMission == null || tempMission.isDone()) {
                this.removeMission(tempMission);
                continue;
            }
            ++index;
        }
    }

    private void calculateProbability(Person person) {
        Class[] parametersForFindingMethod = new Class[]{Person.class};
        Object[] parametersForInvokingMethod = new Object[]{person};
        this.totalProbCache = 0.0;
        for (Class<? extends Mission> potentialMission : this.potentialMissions) {
            try {
                Class<? extends Mission> probabilityClass = potentialMission;
                Method probabilityMethod = probabilityClass.getMethod("getNewMissionProbability", parametersForFindingMethod);
                Double probability = (Double)probabilityMethod.invoke(null, parametersForInvokingMethod);
                if (probability >= 0.0 && probability != Double.NaN && probability != Double.POSITIVE_INFINITY) {
                    this.missionProbCache.put(probabilityClass, probability);
                    this.totalProbCache += probability.doubleValue();
                    continue;
                }
                this.missionProbCache.put(probabilityClass, 0.0);
                logger.severe(probabilityClass.getName() + " returning bad mission probability: " + probability);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "MissionManager.getTotalMissionProbability()", e);
            }
        }
        this.timeCache = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        this.personCache = person;
    }

    private boolean useCache(Person person) {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        return currentTime.equals(this.timeCache) && person == this.personCache;
    }

    public void timePassing(double time) {
        Iterator<Mission> i = this.missions.iterator();
        while (i.hasNext()) {
            i.next().timePassing(time);
        }
    }

    public void destroy() {
        this.missions.clear();
        this.missions = null;
        this.listeners.clear();
        this.listeners = null;
        this.personCache = null;
        this.timeCache = null;
        this.missionProbCache.clear();
        this.missionProbCache = null;
        this.potentialMissions = null;
    }
}

