/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.job.Driver;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionHistoricalEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class RescueSalvageVehicle
extends RoverMission
implements Serializable {
    private static Logger logger = Logger.getLogger(RescueSalvageVehicle.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Rescue/Salvage Vehicle";
    private static final int MISSION_MIN_MEMBERS = 2;
    private static final int MISSION_MAX_MEMBERS = 3;
    private static final double BASE_RESCUE_MISSION_WEIGHT = 1000.0;
    private static final double BASE_SALVAGE_MISSION_WEIGHT = 100.0;
    private static final double RESCUE_RESOURCE_BUFFER = 1.0;
    protected static final String RENDEZVOUS = "Rendezvous with vehicle";
    private Vehicle vehicleTarget;
    private boolean rescue = false;

    public RescueSalvageVehicle(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson, 2);
        if (!this.isDone()) {
            this.setStartingSettlement(startingPerson.getSettlement());
            this.setMissionCapacity(3);
            if (this.hasVehicle()) {
                int availableSuitNum;
                this.vehicleTarget = RescueSalvageVehicle.findAvailableBeaconVehicle(this.getStartingSettlement(), this.getVehicle().getRange());
                int capacity = this.getRover().getCrewCapacity();
                if (capacity < 3) {
                    this.setMissionCapacity(capacity);
                }
                if ((availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingPerson.getSettlement())) < this.getMissionCapacity()) {
                    this.setMissionCapacity(availableSuitNum);
                }
            }
            if (this.vehicleTarget != null) {
                if (RescueSalvageVehicle.getRescuePeopleNum(this.vehicleTarget) > 0) {
                    this.rescue = true;
                    this.setMinPeople(1);
                    this.setDescription("Rescue " + this.vehicleTarget.getName());
                } else {
                    this.setDescription("Salvage " + this.vehicleTarget.getName());
                }
                this.addNavpoint(new NavPoint(this.vehicleTarget.getCoordinates(), this.vehicleTarget.getName()));
                this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
                if (!this.isDone()) {
                    this.recruitPeopleForMission(startingPerson);
                }
                if (this.hasVehicle() && !this.isVehicleLoadable()) {
                    this.endMission("Vehicle is not loadable. (RescueSalvageVehicle)");
                }
                this.addPhase(RENDEZVOUS);
                this.setPhase("Embarking");
                this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
            } else {
                this.endMission("No vehicle target.");
            }
        }
    }

    public RescueSalvageVehicle(Collection<Person> members, Settlement startingSettlement, Vehicle vehicleTarget, Rover rover, String description) {
        super(description, (Person)members.toArray()[0], 1, rover);
        this.setStartingSettlement(startingSettlement);
        this.vehicleTarget = vehicleTarget;
        this.setMissionCapacity(this.getRover().getCrewCapacity());
        if (RescueSalvageVehicle.getRescuePeopleNum(vehicleTarget) > 0) {
            this.rescue = true;
        }
        this.addNavpoint(new NavPoint(vehicleTarget.getCoordinates(), vehicleTarget.getName()));
        this.addNavpoint(new NavPoint(startingSettlement.getCoordinates(), startingSettlement, startingSettlement.getName()));
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.addPhase(RENDEZVOUS);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + startingSettlement.getName());
        if (this.hasVehicle() && !this.isVehicleLoadable()) {
            this.endMission("Vehicle is not loadable. (RescueSalvageVehicle)");
        }
    }

    public static double getNewMissionProbability(Person person) {
        double missionProbability = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            boolean missionPossible = true;
            Settlement settlement = person.getSettlement();
            if (!RescueSalvageVehicle.areVehiclesAvailable(settlement, true)) {
                missionPossible = false;
            }
            if (Mission.getNumberAvailableEVASuitsAtSettlement(settlement) < 2) {
                missionPossible = false;
            }
            Vehicle vehicleTarget = null;
            try {
                Vehicle vehicle = RescueSalvageVehicle.getVehicleWithGreatestRange(settlement, true);
                if (vehicle != null) {
                    vehicleTarget = RescueSalvageVehicle.findAvailableBeaconVehicle(settlement, vehicle.getRange());
                    if (vehicleTarget == null) {
                        missionPossible = false;
                    } else if (!RescueSalvageVehicle.isClosestCapableSettlement(settlement, vehicleTarget)) {
                        missionPossible = false;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean rescue = false;
            if (vehicleTarget != null) {
                boolean bl = rescue = RescueSalvageVehicle.getRescuePeopleNum(vehicleTarget) > 0;
                if (!rescue) {
                    if (!RescueSalvageVehicle.minAvailablePeopleAtSettlement(settlement, 3)) {
                        missionPossible = false;
                    }
                    if (!RescueSalvageVehicle.hasBackupRover(settlement)) {
                        missionPossible = false;
                    }
                }
            }
            if (VehicleMission.hasEmbarkingMissions(settlement)) {
                missionPossible = false;
            }
            if (missionPossible) {
                Job job;
                missionProbability = rescue ? 1000.0 : 100.0;
                int crowding = settlement.getCurrentPopulationNum() - settlement.getPopulationCapacity();
                if (crowding > 0) {
                    missionProbability *= (double)(crowding + 1);
                }
                if ((job = person.getMind().getJob()) != null) {
                    missionProbability *= job.getStartMissionProbabilityModifier(RescueSalvageVehicle.class);
                }
            }
        }
        return missionProbability;
    }

    @Override
    protected boolean isUsableVehicle(Vehicle newVehicle) {
        if (newVehicle != null) {
            String status;
            boolean usable = true;
            if (!(newVehicle instanceof Rover)) {
                usable = false;
            }
            if (newVehicle.isReservedForMission()) {
                usable = false;
            }
            if (!(status = newVehicle.getStatus()).equals("Parked") && !status.equals("Periodic Maintenance")) {
                usable = false;
            }
            if (newVehicle.getInventory().getTotalInventoryMass(false) > 0.0) {
                usable = false;
            }
            return usable;
        }
        throw new IllegalArgumentException("isUsableVehicle: newVehicle is null.");
    }

    @Override
    protected void setVehicle(Vehicle newVehicle) {
        super.setVehicle(newVehicle);
        if (this.getVehicle() == newVehicle && newVehicle.isReservedForMaintenance()) {
            newVehicle.setReservedForMaintenance(false);
        }
    }

    public boolean isRescueMission() {
        return this.rescue;
    }

    public Vehicle getVehicleTarget() {
        return this.vehicleTarget;
    }

    @Override
    protected void determineNewPhase() {
        if ("Embarking".equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
            if (this.rescue) {
                logger.info(this.getVehicle().getName() + " starting rescue mission for " + this.vehicleTarget.getName());
            } else {
                logger.info(this.getVehicle().getName() + " starting salvage mission for " + this.vehicleTarget.getName());
            }
        } else if ("Travelling".equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                this.setPhase("Disembarking");
                this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getSettlement().getName());
            } else {
                this.setPhase(RENDEZVOUS);
                if (this.rescue) {
                    this.setPhaseDescription("Rescuing " + this.vehicleTarget.getName());
                } else {
                    this.setPhaseDescription("Salvaging " + this.vehicleTarget.getName());
                }
            }
        } else if (RENDEZVOUS.equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Disembarking".equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (RENDEZVOUS.equals(this.getPhase())) {
            this.rendezvousPhase(person);
        }
    }

    private void rendezvousPhase(Person person) {
        logger.info(this.getVehicle().getName() + " rendezvous with " + this.vehicleTarget.getName());
        if (this.rescue) {
            Map<Resource, Number> rescueResources = this.determineRescueResourcesNeeded(true);
            for (AmountResource amountResource : rescueResources.keySet()) {
                double amount = (Double)rescueResources.get(amountResource);
                Inventory roverInv = this.getRover().getInventory();
                Inventory targetInv = this.vehicleTarget.getInventory();
                double amountNeeded = amount - targetInv.getAmountResourceStored(amountResource, false);
                if (!(amountNeeded > 0.0) || !(roverInv.getAmountResourceStored(amountResource, false) > amountNeeded)) continue;
                roverInv.retrieveAmountResource(amountResource, amountNeeded);
                targetInv.storeAmountResource(amountResource, amountNeeded, true);
            }
        }
        this.setEmergencyBeacon(person, this.vehicleTarget, false);
        this.getRover().setTowedVehicle(this.vehicleTarget);
        this.vehicleTarget.setTowingVehicle(this.getRover());
        this.setPhaseEnded(true);
        MissionHistoricalEvent newEvent = new MissionHistoricalEvent(person, this, "Rescue/Salvage Mission Rendezvous with Target Vehicle");
        Simulation.instance().getEventManager().registerNewEvent(newEvent);
    }

    @Override
    protected void performDisembarkToSettlementPhase(Person person, Settlement disembarkSettlement) {
        if (this.hasVehicle()) {
            this.disembarkTowedVehicles(person, this.getRover(), disembarkSettlement);
        }
        super.performDisembarkToSettlementPhase(person, disembarkSettlement);
    }

    private void disembarkTowedVehicles(Person person, Rover rover, Settlement disembarkSettlement) {
        if (rover.getTowedVehicle() != null) {
            Vehicle towedVehicle = rover.getTowedVehicle();
            rover.setTowedVehicle(null);
            towedVehicle.setTowingVehicle(null);
            Inventory inv = disembarkSettlement.getInventory();
            inv.storeUnit(towedVehicle);
            towedVehicle.determinedSettlementParkedLocationAndFacing();
            logger.info(towedVehicle + " salvaged at " + disembarkSettlement.getName());
            MissionHistoricalEvent salvageEvent = new MissionHistoricalEvent(person, this, "Salvage Vehicle");
            Simulation.instance().getEventManager().registerNewEvent(salvageEvent);
            if (towedVehicle instanceof Crewable) {
                Crewable crewVehicle = (Crewable)((Object)towedVehicle);
                for (Person crewmember : crewVehicle.getCrew()) {
                    towedVehicle.getInventory().retrieveUnit(crewmember);
                    disembarkSettlement.getInventory().storeUnit(crewmember);
                    BuildingManager.addToRandomBuilding(crewmember, disembarkSettlement);
                    crewmember.setAssociatedSettlement(disembarkSettlement);
                    logger.info(crewmember.getName() + " rescued.");
                    MissionHistoricalEvent rescueEvent = new MissionHistoricalEvent(person, this, "Rescue Person");
                    Simulation.instance().getEventManager().registerNewEvent(rescueEvent);
                }
            }
            if (towedVehicle instanceof Rover) {
                this.disembarkTowedVehicles(person, (Rover)towedVehicle, disembarkSettlement);
            }
        }
    }

    private Map<Resource, Number> determineRescueResourcesNeeded(boolean useBuffer) {
        HashMap<Resource, Number> result = new HashMap<Resource, Number>(3);
        double distance = this.vehicleTarget.getCoordinates().getDistance(this.getStartingSettlement().getCoordinates());
        double time = this.getEstimatedTripTime(true, distance);
        double timeSols = time / 1000.0;
        int peopleNum = RescueSalvageVehicle.getRescuePeopleNum(this.vehicleTarget);
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenAmount = PhysicalCondition.getOxygenConsumptionRate() * timeSols * (double)peopleNum;
        if (useBuffer) {
            oxygenAmount *= 3.0;
        }
        result.put(oxygen, oxygenAmount);
        AmountResource water = AmountResource.findAmountResource("water");
        double waterAmount = PhysicalCondition.getWaterConsumptionRate() * timeSols * (double)peopleNum;
        if (useBuffer) {
            waterAmount *= 3.0;
        }
        result.put(water, waterAmount);
        AmountResource food = AmountResource.findAmountResource("food");
        double foodAmount = PhysicalCondition.getFoodConsumptionRate() * timeSols * (double)peopleNum;
        if (useBuffer) {
            foodAmount *= 3.0;
        }
        result.put(food, foodAmount);
        return result;
    }

    public static Vehicle findAvailableBeaconVehicle(Settlement settlement, double range) {
        double vehicleRange;
        Vehicle vehicle2;
        Vehicle result = null;
        double halfRange = range / 2.0;
        ConcurrentLinkedQueue<Vehicle> emergencyBeaconVehicles = new ConcurrentLinkedQueue<Vehicle>();
        ConcurrentLinkedQueue<Vehicle> vehiclesNeedingRescue = new ConcurrentLinkedQueue<Vehicle>();
        for (Vehicle vehicle2 : Simulation.instance().getUnitManager().getVehicles()) {
            if (!vehicle2.isEmergencyBeacon() || RescueSalvageVehicle.isVehicleAlreadyMissionTarget(vehicle2)) continue;
            emergencyBeaconVehicles.add(vehicle2);
            if (!(vehicle2 instanceof Crewable) || ((Crewable)((Object)vehicle2)).getCrewNum() <= 0) continue;
            vehiclesNeedingRescue.add(vehicle2);
        }
        if (vehiclesNeedingRescue.size() > 0 && (vehicle2 = RescueSalvageVehicle.findClosestVehicle(settlement.getCoordinates(), vehiclesNeedingRescue)) != null && (vehicleRange = settlement.getCoordinates().getDistance(vehicle2.getCoordinates())) <= halfRange) {
            result = vehicle2;
        }
        if (result == null && emergencyBeaconVehicles.size() > 0 && (vehicle2 = RescueSalvageVehicle.findClosestVehicle(settlement.getCoordinates(), emergencyBeaconVehicles)) != null && (vehicleRange = settlement.getCoordinates().getDistance(vehicle2.getCoordinates())) <= halfRange) {
            result = vehicle2;
        }
        return result;
    }

    private static boolean isVehicleAlreadyMissionTarget(Vehicle vehicle) {
        boolean result = false;
        MissionManager manager = Simulation.instance().getMissionManager();
        Iterator<Mission> i = manager.getMissions().iterator();
        while (i.hasNext() && !result) {
            Vehicle vehicleTarget;
            Mission mission = i.next();
            if (!(mission instanceof RescueSalvageVehicle) || vehicle != (vehicleTarget = ((RescueSalvageVehicle)mission).vehicleTarget)) continue;
            result = true;
        }
        return result;
    }

    private static Vehicle findClosestVehicle(Coordinates location, Collection<Vehicle> vehicles) {
        Vehicle closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Vehicle vehicle : vehicles) {
            double vehicleDistance = location.getDistance(vehicle.getCoordinates());
            if (!(vehicleDistance < closestDistance)) continue;
            closest = vehicle;
            closestDistance = vehicleDistance;
        }
        return closest;
    }

    private static int getRescuePeopleNum(Vehicle vehicle) {
        int result = 0;
        if (vehicle instanceof Crewable) {
            result = ((Crewable)((Object)vehicle)).getCrewNum();
        }
        return result;
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.getStartingSettlement();
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForRemainingMission(boolean useBuffer) {
        Map<Resource, Number> result = super.getResourcesNeededForRemainingMission(useBuffer);
        if (this.rescue && this.getRover().getTowedVehicle() == null) {
            Map<Resource, Number> rescueResources = this.determineRescueResourcesNeeded(useBuffer);
            for (Resource resource : rescueResources.keySet()) {
                if (resource instanceof AmountResource) {
                    double amount = (Double)rescueResources.get(resource);
                    if (result.containsKey(resource)) {
                        amount += ((Double)result.get(resource)).doubleValue();
                    }
                    if (useBuffer) {
                        amount *= 1.0;
                    }
                    result.put(resource, amount);
                    continue;
                }
                int num = (Integer)rescueResources.get(resource);
                if (result.containsKey(resource)) {
                    num += ((Integer)result.get(resource)).intValue();
                }
                result.put(resource, num);
            }
        }
        return result;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        HashMap<Class, Integer> result;
        if (this.equipmentNeededCache != null) {
            return this.equipmentNeededCache;
        }
        this.equipmentNeededCache = result = new HashMap<Class, Integer>();
        return result;
    }

    @Override
    protected double getMissionQualification(Person person) {
        double result = 0.0;
        if (this.isCapableOfMission(person)) {
            result = super.getMissionQualification(person);
            if (person.getMind().getJob() instanceof Driver) {
                result += 1.0;
            }
        }
        return result;
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.getStartingSettlement();
    }

    public static boolean isClosestCapableSettlement(Settlement thisSettlement, Vehicle thisVehicle) {
        boolean result = true;
        double distance = thisSettlement.getCoordinates().getDistance(thisVehicle.getCoordinates());
        Iterator<Settlement> iS = Simulation.instance().getUnitManager().getSettlements().iterator();
        while (iS.hasNext() && result) {
            double settlementDistance;
            Settlement settlement = iS.next();
            if (settlement == thisSettlement || !((settlementDistance = settlement.getCoordinates().getDistance(thisVehicle.getCoordinates())) < distance) || settlement.getCurrentPopulationNum() < 2) continue;
            Iterator<Vehicle> iV = settlement.getParkedVehicles().iterator();
            while (iV.hasNext() && result) {
                Vehicle vehicle = iV.next();
                if (!(vehicle instanceof Rover) || !(vehicle.getRange() >= settlementDistance * 2.0)) continue;
                result = false;
            }
        }
        return result;
    }

    @Override
    protected void recruitPeopleForMission(Person startingPerson) {
        super.recruitPeopleForMission(startingPerson);
        if (!this.rescue && !RescueSalvageVehicle.atLeastOnePersonRemainingAtSettlement(this.getStartingSettlement(), startingPerson)) {
            Object[] array = this.getPeople().toArray();
            Person lastPerson = null;
            int amount = this.getPeopleNumber() - 1;
            if (amount > 0 && amount < array.length) {
                lastPerson = (Person)array[amount];
            }
            if (lastPerson != null) {
                lastPerson.getMind().setMission(null);
                if (this.getPeopleNumber() < this.getMinPeople()) {
                    this.endMission("Not enough members.");
                }
            }
        }
    }

    public Map<Resource, Number> getResourcesToLoad() {
        HashMap<Resource, Number> result = new HashMap<Resource, Number>(4);
        Inventory inv = this.getVehicle().getInventory();
        result.put(this.getVehicle().getFuelType(), inv.getAmountResourceCapacity(this.getVehicle().getFuelType(), false));
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        result.put(oxygen, inv.getAmountResourceCapacity(oxygen, false));
        AmountResource water = AmountResource.findAmountResource("water");
        result.put(water, inv.getAmountResourceCapacity(water, false));
        AmountResource food = AmountResource.findAmountResource("food");
        result.put(food, inv.getAmountResourceCapacity(food, false));
        result.putAll(this.getPartsNeededForTrip(this.getTotalRemainingDistance()));
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.vehicleTarget = null;
    }
}

