/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.DriveGroundVehicle;
import org.mars_sim.msp.core.person.ai.task.EnterAirlock;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.OperateVehicle;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleGarage;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.VehicleMaintenance;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public abstract class RoverMission
extends VehicleMission {
    private static Logger logger = Logger.getLogger(RoverMission.class.getName());
    public static final String STARTING_SETTLEMENT_EVENT = "starting settlement";
    protected static final int MIN_PEOPLE = 2;
    protected static final double MIN_STARTING_SETTLEMENT_METHANE = 1000.0;
    private Settlement startingSettlement;

    protected RoverMission(String name, Person startingPerson) {
        super(name, startingPerson, 2);
    }

    protected RoverMission(String name, Person startingPerson, int minPeople) {
        super(name, startingPerson, minPeople);
    }

    protected RoverMission(String name, Person startingPerson, int minPeople, Rover rover) {
        super(name, startingPerson, minPeople, rover);
    }

    public final Rover getRover() {
        return (Rover)this.getVehicle();
    }

    protected final void setStartingSettlement(Settlement startingSettlement) {
        this.startingSettlement = startingSettlement;
        this.fireMissionUpdate(STARTING_SETTLEMENT_EVENT);
    }

    public final Settlement getStartingSettlement() {
        return this.startingSettlement;
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
    }

    protected static Vehicle getVehicleWithGreatestRange(Settlement settlement, boolean allowMaintReserved) {
        Vehicle result = null;
        for (Vehicle vehicle : settlement.getParkedVehicles()) {
            boolean usable = true;
            if (vehicle.isReservedForMission()) {
                usable = false;
            }
            if (!allowMaintReserved && vehicle.isReserved()) {
                usable = false;
            }
            if (!vehicle.getStatus().equals("Parked")) {
                usable = false;
            }
            if (vehicle.getInventory().getTotalInventoryMass(false) > 0.0) {
                usable = false;
            }
            if (!(vehicle instanceof Rover)) {
                usable = false;
            }
            if (!usable) continue;
            if (result == null) {
                result = vehicle;
                continue;
            }
            if (!(vehicle.getRange() > result.getRange())) continue;
            result = vehicle;
        }
        return result;
    }

    protected static boolean areVehiclesAvailable(Settlement settlement, boolean allowMaintReserved) {
        boolean result = false;
        for (Vehicle vehicle : settlement.getParkedVehicles()) {
            boolean usable = true;
            if (vehicle.isReservedForMission()) {
                usable = false;
            }
            if (!allowMaintReserved && vehicle.isReserved()) {
                usable = false;
            }
            if (!vehicle.getStatus().equals("Parked")) {
                usable = false;
            }
            if (!(vehicle instanceof Rover)) {
                usable = false;
            }
            if (vehicle.getInventory().getTotalInventoryMass(false) > 0.0) {
                usable = false;
            }
            if (!usable) continue;
            result = true;
        }
        return result;
    }

    @Override
    protected boolean isUsableVehicle(Vehicle newVehicle) {
        boolean usable = super.isUsableVehicle(newVehicle);
        if (!(newVehicle instanceof Rover)) {
            usable = false;
        }
        return usable;
    }

    protected final boolean isEveryoneInRover() {
        boolean result = true;
        Iterator<Person> i = this.getPeople().iterator();
        while (i.hasNext()) {
            if (i.next().getLocationSituation().equals("In Vehicle")) continue;
            result = false;
        }
        return result;
    }

    protected final boolean isNoOneInRover() {
        boolean result = true;
        Iterator<Person> i = this.getPeople().iterator();
        while (i.hasNext()) {
            if (!i.next().getLocationSituation().equals("In Vehicle")) continue;
            result = false;
        }
        return result;
    }

    protected boolean isRoverInAGarage() {
        return BuildingManager.getBuilding(this.getVehicle()) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void performEmbarkFromSettlementPhase(Person person) {
        Settlement settlement = this.getVehicle().getSettlement();
        if (settlement == null) {
            throw new IllegalStateException(this.getPhase() + " : Vehicle is not at a settlement.");
        }
        if (BuildingManager.getBuilding(this.getVehicle()) == null) {
            BuildingManager.addToRandomBuilding((Rover)this.getVehicle(), this.getVehicle().getSettlement());
        }
        if (!this.loadedFlag) {
            if (this.isVehicleLoaded()) {
                this.loadedFlag = true;
                return;
            }
            if (!this.isVehicleLoadable()) {
                this.endMission("Vehicle is not loadable (RoverMission).");
                return;
            }
            if (!RandomUtil.lessThanRandPercent(75)) return;
            if (BuildingManager.getBuilding(this.getVehicle()) != null) {
                this.assignTask(person, new LoadVehicleGarage(person, this.getVehicle(), this.getRequiredResourcesToLoad(), this.getOptionalResourcesToLoad(), this.getRequiredEquipmentToLoad(), this.getOptionalEquipmentToLoad()));
                return;
            }
            SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
            if (!(surface.getSurfaceSunlight(person.getCoordinates()) > 0.0)) {
                if (!surface.inDarkPolarRegion(person.getCoordinates())) return;
            }
            this.assignTask(person, new LoadVehicleEVA(person, this.getVehicle(), this.getRequiredResourcesToLoad(), this.getOptionalResourcesToLoad(), this.getRequiredEquipmentToLoad(), this.getOptionalEquipmentToLoad()));
            return;
        }
        if (!person.getLocationSituation().equals("In Vehicle") && !person.getLocationSituation().equals("Buried")) {
            if (this.isRoverInAGarage()) {
                if (!this.getVehicle().getInventory().canStoreUnit(person, false)) {
                    this.endMission("Crew member " + person + " cannot be loaded in rover " + this.getVehicle());
                    return;
                }
                if (settlement.getInventory().containsUnit(person)) {
                    settlement.getInventory().retrieveUnit(person);
                }
                this.getVehicle().getInventory().storeUnit(person);
                if (settlement.getInventory().findNumUnitsOfClass(EVASuit.class) > 0) {
                    EVASuit suit = (EVASuit)settlement.getInventory().findUnitOfClass(EVASuit.class);
                    if (!this.getVehicle().getInventory().canStoreUnit(suit, false)) {
                        this.endMission("Equipment " + suit + " cannot be loaded in rover " + this.getVehicle());
                        return;
                    }
                    settlement.getInventory().retrieveUnit(suit);
                    this.getVehicle().getInventory().storeUnit(suit);
                }
                Point2D.Double vehicleLoc = LocalAreaUtil.getRandomInteriorLocation(this.getVehicle());
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(vehicleLoc.getX(), vehicleLoc.getY(), this.getVehicle());
                person.setXLocation(settlementLoc.getX());
                person.setYLocation(settlementLoc.getY());
            } else if (person.getLocationSituation().equals("In Settlement")) {
                if (ExitAirlock.canExitAirlock(person, this.startingSettlement.getAvailableAirlock())) {
                    this.assignTask(person, new ExitAirlock(person, this.startingSettlement.getAvailableAirlock()));
                } else {
                    logger.info(person + " unable to exit airlock at " + this.startingSettlement + " to rover " + this.getRover() + " due to health problems or being unable to obtain a functioning EVA suit.");
                    this.endMission(person + " unable to exit airlock from " + this.startingSettlement + " due to health problems or being unable to obtain a functioning EVA suit.");
                }
            } else if (person.getLocationSituation().equals("Outside")) {
                this.assignTask(person, new EnterAirlock(person, this.getRover().getAirlock()));
            }
        }
        if (this.isDone()) return;
        if (!this.loadedFlag) return;
        if (!this.isEveryoneInRover()) return;
        Building garageBuilding = BuildingManager.getBuilding(this.getVehicle());
        if (garageBuilding != null) {
            VehicleMaintenance garage = (VehicleMaintenance)garageBuilding.getFunction("Ground Vehicle Maintenance");
            garage.removeVehicle(this.getVehicle());
        }
        settlement.getInventory().retrieveUnit(this.getVehicle());
        this.setPhaseEnded(true);
    }

    @Override
    protected void performDisembarkToSettlementPhase(Person person, Settlement disembarkSettlement) {
        Rover rover;
        Building garageBuilding = null;
        VehicleMaintenance garage = null;
        if (this.getVehicle() != null && this.getVehicle().getSettlement() == null) {
            disembarkSettlement.getInventory().storeUnit(this.getVehicle());
            this.getVehicle().determinedSettlementParkedLocationAndFacing();
            BuildingManager.addToRandomBuilding((GroundVehicle)this.getVehicle(), disembarkSettlement);
            garageBuilding = BuildingManager.getBuilding(this.getVehicle());
            if (garageBuilding != null) {
                garage = (VehicleMaintenance)garageBuilding.getFunction("Ground Vehicle Maintenance");
            }
        }
        if (person.getLocationSituation().equals("In Vehicle")) {
            if (this.isRoverInAGarage()) {
                if (this.getVehicle() != null) {
                    this.getVehicle().getInventory().retrieveUnit(person);
                    disembarkSettlement.getInventory().storeUnit(person);
                    garageBuilding = BuildingManager.getBuilding(this.getVehicle());
                    BuildingManager.addPersonToBuilding(person, garageBuilding);
                }
            } else if (ExitAirlock.canExitAirlock(person, this.getRover().getAirlock())) {
                this.assignTask(person, new ExitAirlock(person, this.getRover().getAirlock()));
            } else {
                logger.info(person + " unable to exit " + this.getRover() + " through airlock to settlement " + disembarkSettlement + " due to health problems or being unable to obtain a functioning EVA suit.  " + "Using emergency exit procedure.");
                this.getVehicle().getInventory().retrieveUnit(person);
                disembarkSettlement.getInventory().storeUnit(person);
                BuildingManager.addToRandomBuilding(person, disembarkSettlement);
            }
        } else if (person.getLocationSituation().equals("Outside")) {
            this.assignTask(person, new EnterAirlock(person, disembarkSettlement.getAvailableAirlock()));
        }
        if ((rover = (Rover)this.getVehicle()) != null) {
            if (this.isNoOneInRover() && rover.getCrewNum() > 0) {
                for (Person crewmember : rover.getCrew()) {
                    rover.getInventory().retrieveUnit(crewmember);
                    disembarkSettlement.getInventory().storeUnit(crewmember);
                    BuildingManager.addToRandomBuilding(crewmember, disembarkSettlement);
                }
            }
            if (this.isNoOneInRover()) {
                boolean roverUnloaded;
                boolean bl = roverUnloaded = rover.getInventory().getTotalInventoryMass(false) == 0.0;
                if (!roverUnloaded) {
                    if (RandomUtil.lessThanRandPercent(50)) {
                        if (BuildingManager.getBuilding(rover) != null) {
                            this.assignTask(person, new UnloadVehicleGarage(person, rover));
                        } else {
                            SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
                            if (surface.getSurfaceSunlight(person.getCoordinates()) > 0.0 || surface.inDarkPolarRegion(person.getCoordinates())) {
                                this.assignTask(person, new UnloadVehicleEVA(person, rover));
                            }
                        }
                        return;
                    }
                } else {
                    if (this.isRoverInAGarage()) {
                        garageBuilding = BuildingManager.getBuilding(this.getVehicle());
                        garage = (VehicleMaintenance)garageBuilding.getFunction("Ground Vehicle Maintenance");
                        garage.removeVehicle(this.getVehicle());
                    }
                    this.leaveVehicle();
                    this.setPhaseEnded(true);
                }
            }
        } else {
            this.setPhaseEnded(true);
        }
    }

    @Override
    protected OperateVehicle getOperateVehicleTask(Person person, String lastOperateVehicleTaskPhase) {
        DriveGroundVehicle result = null;
        result = lastOperateVehicleTaskPhase != null ? new DriveGroundVehicle(person, this.getRover(), this.getNextNavpoint().getLocation(), this.getCurrentLegStartingTime(), this.getCurrentLegDistance(), lastOperateVehicleTaskPhase) : new DriveGroundVehicle(person, this.getRover(), this.getNextNavpoint().getLocation(), this.getCurrentLegStartingTime(), this.getCurrentLegDistance());
        return result;
    }

    protected static boolean atLeastOnePersonRemainingAtSettlement(Settlement settlement, Person person) {
        boolean result = false;
        if (settlement != null) {
            for (Person inhabitant : settlement.getInhabitants()) {
                if (inhabitant == person || inhabitant.getMind().hasActiveMission()) continue;
                result = true;
            }
        }
        return result;
    }

    protected static boolean minAvailablePeopleAtSettlement(Settlement settlement, int minNum) {
        boolean result = false;
        if (settlement != null) {
            int numAvailable = 0;
            for (Person inhabitant : settlement.getInhabitants()) {
                if (inhabitant.getMind().hasActiveMission()) continue;
                ++numAvailable;
            }
            if (numAvailable >= minNum) {
                result = true;
            }
        }
        return result;
    }

    protected final boolean hasDangerousMedicalProblemAtAssociatedSettlement() {
        Person person;
        boolean result = false;
        if (this.getAssociatedSettlement() != null && this.getAssociatedSettlement().getCurrentPopulationNum() == 1 && (person = (Person)this.getAssociatedSettlement().getInhabitants().toArray()[0]).getPhysicalCondition().hasSeriousMedicalProblems()) {
            result = true;
        }
        return result;
    }

    @Override
    protected final boolean hasEmergency() {
        boolean result = super.hasEmergency();
        if (this.hasDangerousMedicalProblemAtAssociatedSettlement()) {
            result = true;
        }
        return result;
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForTrip(boolean useBuffer, double distance) {
        Map<Resource, Number> result = super.getResourcesNeededForTrip(useBuffer, distance);
        double time = this.getEstimatedTripTime(useBuffer, distance);
        double timeSols = time / 1000.0;
        int crewNum = this.getPeopleNumber();
        double oxygenAmount = PhysicalCondition.getOxygenConsumptionRate() * timeSols * (double)crewNum;
        if (useBuffer) {
            oxygenAmount *= 3.0;
        }
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        result.put(oxygen, oxygenAmount);
        double waterAmount = PhysicalCondition.getWaterConsumptionRate() * timeSols * (double)crewNum;
        if (useBuffer) {
            waterAmount *= 3.0;
        }
        AmountResource water = AmountResource.findAmountResource("water");
        result.put(water, waterAmount);
        double foodAmount = PhysicalCondition.getFoodConsumptionRate() * timeSols * (double)crewNum;
        if (useBuffer) {
            foodAmount *= 3.0;
        }
        AmountResource food = AmountResource.findAmountResource("food");
        result.put(food, foodAmount);
        return result;
    }

    @Override
    public void endMission(String reason) {
        for (Person person : this.getPeople()) {
            if (!person.getLocationSituation().equals("In Settlement")) continue;
            person.setAssociatedSettlement(person.getSettlement());
        }
        super.endMission(reason);
    }

    protected static boolean hasBackupRover(Settlement settlement) {
        int availableVehicleNum = 0;
        for (Vehicle vehicle : settlement.getParkedVehicles()) {
            if (!(vehicle instanceof Rover) || vehicle.isReservedForMission()) continue;
            ++availableVehicleNum;
        }
        return availableVehicleNum >= 2;
    }

    protected static boolean hasEnoughBasicResources(Settlement settlement) {
        boolean hasBasicResources = true;
        Inventory inv = settlement.getInventory();
        try {
            AmountResource methane;
            AmountResource food;
            AmountResource water;
            AmountResource oxygen = AmountResource.findAmountResource("oxygen");
            if (inv.getAmountResourceStored(oxygen, false) < 50.0) {
                hasBasicResources = false;
            }
            if (inv.getAmountResourceStored(water = AmountResource.findAmountResource("water"), false) < 50.0) {
                hasBasicResources = false;
            }
            if (inv.getAmountResourceStored(food = AmountResource.findAmountResource("food"), false) < 50.0) {
                hasBasicResources = false;
            }
            if (inv.getAmountResourceStored(methane = AmountResource.findAmountResource("methane"), false) < 100.0) {
                hasBasicResources = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return hasBasicResources;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.startingSettlement = null;
    }
}

