/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.Barrel;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.equipment.GasCanister;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.Trade;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.Phase;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.CreditManager;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public final class TradeUtil {
    private static Logger logger = Logger.getLogger(TradeUtil.class.getName());
    public static final double SELL_CREDIT_LIMIT = 1.0E7;
    private static final double MISSION_BASE_MASS = 1000.0;
    private static final int MIN_LIFE_SUPPORT_RESOURCES = 100;
    private static final int MIN_REPAIR_PARTS = 20;
    private static final Map<Class, Equipment> equipmentGoodCache = new HashMap<Class, Equipment>(5);
    static Settlement bestTradeSettlementCache = null;
    private static final Map<Class, Equipment> containerTypeCache = new HashMap<Class, Equipment>(3);

    private TradeUtil() {
    }

    static double getBestTradeProfit(Settlement startingSettlement, Rover rover) {
        double bestProfit = 0.0;
        Settlement bestSettlement = null;
        for (Settlement settlement : Simulation.instance().getUnitManager().getSettlements()) {
            double profit;
            boolean withinRange;
            if (settlement == startingSettlement) continue;
            boolean hasCurrentTradeMission = TradeUtil.hasCurrentTradeMission(startingSettlement, settlement);
            double settlementRange = settlement.getCoordinates().getDistance(startingSettlement.getCoordinates());
            boolean bl = withinRange = settlementRange <= rover.getRange() * 0.8;
            if (hasCurrentTradeMission || !withinRange || !((profit = TradeUtil.getEstimatedTradeProfit(startingSettlement, rover, settlement)) > bestProfit)) continue;
            bestProfit = profit;
            bestSettlement = settlement;
        }
        bestTradeSettlementCache = bestSettlement;
        return bestProfit;
    }

    private static boolean hasCurrentTradeMission(Settlement settlement1, Settlement settlement2) {
        boolean result = false;
        MissionManager manager = Simulation.instance().getMissionManager();
        for (Mission mission : manager.getMissions()) {
            if (!(mission instanceof Trade)) continue;
            Trade tradeMission = (Trade)mission;
            Settlement startingSettlement = tradeMission.getStartingSettlement();
            Settlement tradingSettlement = tradeMission.getTradingSettlement();
            if (startingSettlement.equals(settlement1) && tradingSettlement.equals(settlement2)) {
                result = true;
                break;
            }
            if (!startingSettlement.equals(settlement2) || !tradingSettlement.equals(settlement1)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static double getEstimatedTradeProfit(Settlement startingSettlement, Rover rover, Settlement tradingSettlement) {
        double revenue = TradeUtil.getEstimatedTradeRevenue(startingSettlement, rover, tradingSettlement);
        double distance = startingSettlement.getCoordinates().getDistance(tradingSettlement.getCoordinates()) * 2.0;
        double cost = TradeUtil.getEstimatedMissionCost(startingSettlement, rover, distance);
        return revenue - cost;
    }

    private static double getEstimatedTradeRevenue(Settlement startingSettlement, Rover rover, Settlement tradingSettlement) {
        CreditManager creditManager = Simulation.instance().getCreditManager();
        double credit = creditManager.getCredit(startingSettlement, tradingSettlement);
        Map<Good, Integer> buyLoad = null;
        buyLoad = credit > -1.0E7 ? TradeUtil.getDesiredBuyLoad(startingSettlement, rover, tradingSettlement) : new HashMap<Good, Integer>(0);
        Map<Good, Integer> sellLoad = null;
        sellLoad = credit < 1.0E7 ? TradeUtil.determineBestSellLoad(startingSettlement, rover, tradingSettlement) : new HashMap<Good, Integer>(0);
        double sellingValueHome = TradeUtil.determineLoadValue(sellLoad, startingSettlement, false);
        double sellingValueRemote = TradeUtil.determineLoadValue(sellLoad, tradingSettlement, true);
        double sellingProfit = sellingValueRemote - sellingValueHome;
        double buyingValueHome = TradeUtil.determineLoadValue(buyLoad, startingSettlement, true);
        double buyingValueRemote = TradeUtil.determineLoadValue(buyLoad, tradingSettlement, false);
        double buyingProfit = buyingValueHome - buyingValueRemote;
        double totalProfit = sellingProfit + buyingProfit;
        return totalProfit;
    }

    public static Map<Good, Integer> getDesiredBuyLoad(Settlement startingSettlement, Rover rover, Settlement tradingSettlement) {
        Map<Good, Integer> buyLoad = TradeUtil.determineLoad(startingSettlement, tradingSettlement, rover, Double.POSITIVE_INFINITY);
        return buyLoad;
    }

    static Map<Good, Integer> determineBestSellLoad(Settlement startingSettlement, Rover rover, Settlement tradingSettlement) {
        Map<Good, Integer> sellLoad = TradeUtil.determineLoad(tradingSettlement, startingSettlement, rover, Double.POSITIVE_INFINITY);
        return sellLoad;
    }

    public static Map<Good, Integer> determineLoad(Settlement buyingSettlement, Settlement sellingSettlement, Rover rover, double maxBuyValue) {
        HashMap<Good, Integer> tradeList = new HashMap<Good, Integer>();
        boolean hasRover = false;
        GoodsManager buyerGoodsManager = buyingSettlement.getGoodsManager();
        buyerGoodsManager.prepareForLoadCalculation();
        GoodsManager sellerGoodsManager = sellingSettlement.getGoodsManager();
        sellerGoodsManager.prepareForLoadCalculation();
        double massCapacity = rover.getInventory().getGeneralCapacity();
        double missionPartsMass = 1000.0;
        if (massCapacity < missionPartsMass) {
            missionPartsMass = massCapacity;
        }
        massCapacity -= missionPartsMass;
        Set<Part> repairParts = rover.getMalfunctionManager().getRepairPartProbabilities().keySet();
        boolean done = false;
        double buyerLoadValue = 0.0;
        Good previousGood = null;
        Set<Good> nonTradeGoods = Collections.emptySet();
        while (!done) {
            double remainingBuyValue = maxBuyValue - buyerLoadValue;
            Good good = TradeUtil.findBestTradeGood(sellingSettlement, buyingSettlement, tradeList, nonTradeGoods, massCapacity, hasRover, rover, previousGood, false, repairParts, remainingBuyValue);
            if (good != null) {
                try {
                    boolean isAmountResource = good.getCategory().equals("amount resource");
                    boolean isItemResource = good.getCategory().equals("item resource");
                    if (isAmountResource) {
                        AmountResource resource = (AmountResource)good.getObject();
                        Equipment container = TradeUtil.getAvailableContainerForResource(resource, sellingSettlement, tradeList);
                        if (container != null) {
                            Good containerGood = GoodsUtil.getEquipmentGood(container.getClass());
                            massCapacity -= container.getBaseMass();
                            int containerNum = 0;
                            if (tradeList.containsKey(containerGood)) {
                                containerNum = (Integer)tradeList.get(containerGood);
                            }
                            double containerSupply = buyerGoodsManager.getNumberOfGoodForSettlement(containerGood);
                            double totalContainerNum = (double)containerNum + containerSupply;
                            buyerLoadValue += buyerGoodsManager.getGoodValuePerItem(containerGood, totalContainerNum);
                            tradeList.put(containerGood, containerNum + 1);
                        } else {
                            logger.warning("container for " + resource.getName() + " not available.");
                        }
                    }
                    int itemResourceNum = 0;
                    if (isItemResource) {
                        itemResourceNum = TradeUtil.getNumItemResourcesToTrade(good, sellingSettlement, buyingSettlement, tradeList, massCapacity, remainingBuyValue);
                    }
                    if (good.getCategory().equals("vehicle")) {
                        hasRover = true;
                    } else {
                        int number = 1;
                        if (isAmountResource) {
                            number = (int)TradeUtil.getResourceTradeAmount((AmountResource)good.getObject());
                        } else if (isItemResource) {
                            number = itemResourceNum;
                        }
                        massCapacity -= GoodsUtil.getGoodMassPerItem(good) * (double)number;
                    }
                    int currentNum = 0;
                    if (tradeList.containsKey(good)) {
                        currentNum = (Integer)tradeList.get(good);
                    }
                    double supply = buyerGoodsManager.getNumberOfGoodForSettlement(good);
                    double goodNum = 1.0;
                    if (isAmountResource) {
                        goodNum = TradeUtil.getResourceTradeAmount((AmountResource)good.getObject());
                    }
                    if (isItemResource) {
                        goodNum = itemResourceNum;
                    }
                    double buyGoodValue = buyerGoodsManager.getGoodValuePerItem(good, supply + (double)currentNum + goodNum);
                    if (isAmountResource) {
                        double tradeAmount = TradeUtil.getResourceTradeAmount((AmountResource)good.getObject());
                        buyGoodValue *= tradeAmount;
                    }
                    if (isItemResource) {
                        buyGoodValue *= (double)itemResourceNum;
                    }
                    buyerLoadValue += buyGoodValue;
                    int newNumber = currentNum + (int)goodNum;
                    tradeList.put(good, newNumber);
                }
                catch (Exception e) {
                    done = true;
                }
            } else {
                done = true;
            }
            previousGood = good;
        }
        return tradeList;
    }

    public static double determineLoadValue(Map<Good, Integer> load, Settlement settlement, boolean buy) {
        double result = 0.0;
        GoodsManager manager = settlement.getGoodsManager();
        for (Good good : load.keySet()) {
            int goodNumber = load.get(good);
            double supply = manager.getNumberOfGoodForSettlement(good);
            double multiplier = 1.0;
            if (good.getCategory().equals("amount resource")) {
                double tradeAmount = TradeUtil.getResourceTradeAmount((AmountResource)good.getObject());
                goodNumber /= (int)tradeAmount;
                multiplier = tradeAmount;
            }
            for (int x = 0; x < goodNumber; ++x) {
                double supplyAmount = 0.0;
                if (buy) {
                    supplyAmount = supply + (double)x;
                } else {
                    supplyAmount = supply - (double)x;
                    if (supplyAmount < 0.0) {
                        supplyAmount = 0.0;
                    }
                }
                double value = manager.getGoodValuePerItem(good, supplyAmount) * multiplier;
                result += value;
            }
        }
        return result;
    }

    private static Good findBestTradeGood(Settlement sellingSettlement, Settlement buyingSettlement, Map<Good, Integer> tradedGoods, Set<Good> nonTradeGoods, double remainingCapacity, boolean hasVehicle, Rover missionRover, Good previousGood, boolean allowNegValue, Set<Part> repairParts, double maxBuyValue) {
        double previousGoodValue;
        Good result = null;
        if (previousGood != null && (previousGoodValue = TradeUtil.getTradeValue(previousGood, sellingSettlement, buyingSettlement, tradedGoods, remainingCapacity, hasVehicle, missionRover, allowNegValue, repairParts)) > 0.0 && previousGoodValue < maxBuyValue) {
            result = previousGood;
        }
        if (result == null) {
            double bestValue = 0.0;
            if (allowNegValue) {
                bestValue = Double.NEGATIVE_INFINITY;
            }
            for (Good good : GoodsUtil.getGoodsList()) {
                double tradeValue;
                if (nonTradeGoods.contains(good) || !((tradeValue = TradeUtil.getTradeValue(good, sellingSettlement, buyingSettlement, tradedGoods, remainingCapacity, hasVehicle, missionRover, allowNegValue, repairParts)) > bestValue) || !(tradeValue < maxBuyValue)) continue;
                result = good;
                bestValue = tradeValue;
            }
        }
        return result;
    }

    private static int getNumItemResourcesToTrade(Good itemResourceGood, Settlement sellingSettlement, Settlement buyingSettlement, Map<Good, Integer> tradeList, double remainingCapacity, double maxBuyValue) {
        int result = 0;
        ItemResource item = (ItemResource)itemResourceGood.getObject();
        int sellingInventory = sellingSettlement.getInventory().getItemResourceNum(item);
        int buyingInventory = buyingSettlement.getInventory().getItemResourceNum(item);
        int numberTraded = 0;
        if (tradeList.containsKey(itemResourceGood)) {
            numberTraded = tradeList.get(itemResourceGood);
        }
        int roverLimit = (int)(remainingCapacity / item.getMassPerItem());
        int totalTraded = numberTraded;
        double totalBuyingValue = 0.0;
        boolean limitReached = false;
        while (!limitReached) {
            double sellingSupplyAmount = sellingInventory - totalTraded - 1;
            double sellingValue = sellingSettlement.getGoodsManager().getGoodValuePerItem(itemResourceGood, sellingSupplyAmount);
            double buyingSupplyAmount = buyingInventory + totalTraded + 1;
            double buyingValue = buyingSettlement.getGoodsManager().getGoodValuePerItem(itemResourceGood, buyingSupplyAmount);
            if (buyingValue <= sellingValue) {
                limitReached = true;
            }
            if (totalTraded + 1 > sellingInventory) {
                limitReached = true;
            }
            if (totalTraded + 1 > roverLimit) {
                limitReached = true;
            }
            if (totalBuyingValue + buyingValue >= maxBuyValue) {
                limitReached = true;
            }
            if (limitReached) continue;
            totalTraded = numberTraded + ++result;
            totalBuyingValue += buyingValue;
        }
        if (result == 0) {
            result = 1;
        }
        return result;
    }

    private static double getTradeValue(Good good, Settlement sellingSettlement, Settlement buyingSettlement, Map<Good, Integer> tradedGoods, double remainingCapacity, boolean hasVehicle, Rover missionRover, boolean allowNegValue, Set<Part> repairParts) {
        boolean hasBuyValue;
        double sellingInventory;
        double sellingSupplyAmount;
        double result = Double.NEGATIVE_INFINITY;
        double amountTraded = 0.0;
        if (tradedGoods.containsKey(good)) {
            amountTraded += tradedGoods.get(good).doubleValue();
        }
        if ((sellingSupplyAmount = (sellingInventory = TradeUtil.getNumInInventory(good, sellingSettlement.getInventory())) - amountTraded - 1.0) < 0.0) {
            sellingSupplyAmount = 0.0;
        }
        double sellingValue = sellingSettlement.getGoodsManager().getGoodValuePerItem(good, sellingSupplyAmount);
        if (good.getCategory().equals("amount resource")) {
            sellingValue *= TradeUtil.getResourceTradeAmount((AmountResource)good.getObject());
        }
        boolean allTraded = sellingInventory <= amountTraded;
        double buyingInventory = TradeUtil.getNumInInventory(good, buyingSettlement.getInventory());
        double buyingSupplyAmount = buyingInventory + amountTraded + 1.0;
        if (buyingSupplyAmount < 0.0) {
            buyingSupplyAmount = 0.0;
        }
        double buyingValue = buyingSettlement.getGoodsManager().getGoodValuePerItem(good, buyingSupplyAmount);
        if (good.getCategory().equals("amount resource")) {
            buyingValue *= TradeUtil.getResourceTradeAmount((AmountResource)good.getObject());
        }
        boolean profitable = buyingValue > sellingValue;
        boolean bl = hasBuyValue = buyingValue > 0.0;
        if ((allowNegValue || profitable) && hasBuyValue && !allTraded) {
            AmountResource resource;
            boolean isRoverCapacity = TradeUtil.hasCapacityInInventory(good, remainingCapacity, hasVehicle);
            boolean isContainerAvailable = true;
            if (good.getCategory().equals("amount resource")) {
                Equipment container = TradeUtil.getAvailableContainerForResource((AmountResource)good.getObject(), sellingSettlement, tradedGoods);
                isContainerAvailable = container != null;
            }
            boolean isMissionRover = false;
            if (good.getCategory().equals("vehicle") && good.getName().toLowerCase().equals(missionRover.getDescription().toLowerCase()) && sellingInventory == 1.0) {
                isMissionRover = true;
            }
            boolean enoughResourceForContainer = true;
            if (good.getCategory().equals("amount resource")) {
                enoughResourceForContainer = sellingSupplyAmount >= TradeUtil.getResourceTradeAmount((AmountResource)good.getObject());
            }
            boolean enoughEVASuits = true;
            if (good.getClassType() == EVASuit.class) {
                double remainingSuits = sellingInventory - amountTraded;
                int requiredSuits = 4;
                enoughEVASuits = remainingSuits > (double)requiredSuits;
            }
            boolean enoughRepairParts = true;
            if (good.getCategory().equals("item resource") && repairParts.contains(good.getObject()) && sellingSupplyAmount < 20.0) {
                enoughRepairParts = false;
            }
            boolean enoughLifeSupportResources = true;
            if (good.getCategory().equals("amount resource") && (resource = (AmountResource)good.getObject()).isLifeSupport() && sellingSupplyAmount < 100.0) {
                enoughLifeSupportResources = false;
            }
            if (isRoverCapacity && isContainerAvailable && !isMissionRover && enoughResourceForContainer && enoughEVASuits && enoughRepairParts && enoughLifeSupportResources) {
                result = buyingValue - sellingValue;
            }
        }
        return result;
    }

    private static boolean hasCapacityInInventory(Good good, double remainingCapacity, boolean hasVehicle) {
        boolean result = false;
        if (good.getCategory().equals("amount resource")) {
            AmountResource resource = (AmountResource)good.getObject();
            result = remainingCapacity >= TradeUtil.getResourceTradeAmount(resource);
        } else if (good.getCategory().equals("item resource")) {
            result = remainingCapacity >= ((ItemResource)good.getObject()).getMassPerItem();
        } else if (good.getCategory().equals("equipment")) {
            Class type = good.getClassType();
            if (!equipmentGoodCache.containsKey(type)) {
                equipmentGoodCache.put(type, EquipmentFactory.getEquipment(type, new Coordinates(0.0, 0.0), true));
            }
            result = remainingCapacity >= equipmentGoodCache.get(type).getBaseMass();
        } else if (good.getCategory().equals("vehicle")) {
            result = !hasVehicle;
        }
        return result;
    }

    public static double getNumInInventory(Good good, Inventory inventory) {
        if (good.getCategory().equals("amount resource")) {
            return inventory.getAmountResourceStored((AmountResource)good.getObject(), false);
        }
        if (good.getCategory().equals("item resource")) {
            return inventory.getItemResourceNum((ItemResource)good.getObject());
        }
        if (good.getCategory().equals("equipment")) {
            return inventory.findNumEmptyUnitsOfClass(good.getClassType(), false);
        }
        if (good.getCategory().equals("vehicle")) {
            int count = 0;
            for (Vehicle vehicle : inventory.findAllUnitsOfClass(good.getClassType())) {
                if (!vehicle.getDescription().equalsIgnoreCase(good.getName()) || vehicle.isReserved()) continue;
                ++count;
            }
            return count;
        }
        return 0.0;
    }

    private static Equipment getAvailableContainerForResource(AmountResource resource, Settlement settlement, Map<Good, Integer> tradedGoods) {
        Equipment result = null;
        Class containerType = null;
        if (resource.getPhase().equals(Phase.SOLID)) {
            containerType = Bag.class;
        } else if (resource.getPhase().equals(Phase.LIQUID)) {
            containerType = Barrel.class;
        } else if (resource.getPhase().equals(Phase.GAS)) {
            containerType = GasCanister.class;
        }
        Inventory settlementInv = settlement.getInventory();
        int containersStored = settlementInv.findNumEmptyUnitsOfClass(containerType, false);
        Good containerGood = GoodsUtil.getEquipmentGood(containerType);
        int containersTraded = 0;
        if (tradedGoods.containsKey(containerGood)) {
            containersTraded = tradedGoods.get(containerGood);
        }
        if (containersStored > containersTraded) {
            result = (Equipment)settlementInv.findUnitOfClass(containerType);
        }
        return result;
    }

    public static double getEstimatedMissionCost(Settlement startingSettlement, Rover rover, double distance) {
        HashMap<Good, Integer> neededResources = new HashMap<Good, Integer>(4);
        Good fuelGood = GoodsUtil.getResourceGood(rover.getFuelType());
        double efficiency = rover.getFuelEfficiency();
        neededResources.put(fuelGood, (int)VehicleMission.getFuelNeededForTrip(distance, efficiency, true));
        double averageSpeed = rover.getBaseSpeed() / 2.0;
        double averageSpeedMillisol = averageSpeed / MarsClock.convertSecondsToMillisols(3600.0);
        double tripTimeSols = (distance / averageSpeedMillisol + 1000.0) / 1000.0;
        double oxygenAmount = PhysicalCondition.getOxygenConsumptionRate() * tripTimeSols * 2.0 * 3.0;
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        Good oxygenGood = GoodsUtil.getResourceGood(oxygen);
        neededResources.put(oxygenGood, (int)oxygenAmount);
        double waterAmount = PhysicalCondition.getWaterConsumptionRate() * tripTimeSols * 2.0 * 3.0;
        AmountResource water = AmountResource.findAmountResource("water");
        Good waterGood = GoodsUtil.getResourceGood(water);
        neededResources.put(waterGood, (int)waterAmount);
        double foodAmount = PhysicalCondition.getFoodConsumptionRate() * tripTimeSols * 2.0 * 3.0;
        AmountResource food = AmountResource.findAmountResource("food");
        Good foodGood = GoodsUtil.getResourceGood(food);
        neededResources.put(foodGood, (int)foodAmount);
        return TradeUtil.determineLoadValue(neededResources, startingSettlement, false);
    }

    private static double getResourceTradeAmount(AmountResource resource) {
        double result = 0.0;
        Class containerType = null;
        if (resource.getPhase().equals(Phase.SOLID)) {
            containerType = Bag.class;
        } else if (resource.getPhase().equals(Phase.LIQUID)) {
            containerType = Barrel.class;
        } else if (resource.getPhase().equals(Phase.GAS)) {
            containerType = GasCanister.class;
        }
        Equipment container = null;
        if (containerTypeCache.containsKey(containerType)) {
            container = containerTypeCache.get(containerType);
        } else {
            container = EquipmentFactory.getEquipment(containerType, new Coordinates(0.0, 0.0), true);
            containerTypeCache.put(containerType, container);
        }
        result = container.getInventory().getAmountResourceCapacity(resource, false);
        return result;
    }
}

