/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.UnitEvent;
import org.mars_sim.msp.core.UnitListener;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionHistoricalEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.TravelMission;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.OperateVehicle;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleOperator;

public abstract class VehicleMission
extends TravelMission
implements UnitListener {
    private static Logger logger = Logger.getLogger(VehicleMission.class.getName());
    public static final String VEHICLE_EVENT = "vehicle";
    public static final String OPERATOR_EVENT = "operator";
    public static final String EMBARKING = "Embarking";
    public static final String TRAVELLING = "Travelling";
    public static final String DISEMBARKING = "Disembarking";
    private static final double BUFFER_DISTANCE = 50.0;
    private static final double PARTS_NUMBER_MODIFIER = 2.0;
    private Vehicle vehicle;
    private VehicleOperator lastOperator;
    protected boolean loadedFlag = false;
    private double startingTravelledDistance;
    private OperateVehicle operateVehicleTask;
    protected Map<Class, Integer> equipmentNeededCache;

    protected VehicleMission(String name, Person startingPerson, int minPeople) {
        super(name, startingPerson, minPeople);
        this.addPhase(EMBARKING);
        this.addPhase(TRAVELLING);
        this.addPhase(DISEMBARKING);
        if (!this.reserveVehicle(startingPerson)) {
            this.endMission("No reservable vehicles.");
        }
    }

    protected VehicleMission(String name, Person startingPerson, int minPeople, Vehicle vehicle) {
        super(name, startingPerson, minPeople);
        this.addPhase(EMBARKING);
        this.addPhase(TRAVELLING);
        this.addPhase(DISEMBARKING);
        this.setVehicle(vehicle);
    }

    public final Vehicle getVehicle() {
        return this.vehicle;
    }

    protected void setVehicle(Vehicle newVehicle) {
        if (newVehicle != null) {
            boolean usable = false;
            usable = this.isUsableVehicle(newVehicle);
            if (usable) {
                this.vehicle = newVehicle;
                this.startingTravelledDistance = this.vehicle.getTotalDistanceTraveled();
                newVehicle.setReservedForMission(true);
                this.vehicle.addUnitListener(this);
                this.fireMissionUpdate(VEHICLE_EVENT);
            }
            if (!usable) {
                throw new IllegalStateException(this.getPhase() + " : newVehicle is not usable for this mission.");
            }
        } else {
            throw new IllegalArgumentException("newVehicle is null.");
        }
    }

    public final boolean hasVehicle() {
        return this.vehicle != null;
    }

    protected final void leaveVehicle() {
        if (this.hasVehicle()) {
            this.vehicle.setReservedForMission(false);
            this.vehicle.removeUnitListener(this);
            this.vehicle = null;
            this.fireMissionUpdate(VEHICLE_EVENT);
        }
    }

    protected boolean isUsableVehicle(Vehicle newVehicle) {
        if (newVehicle != null) {
            boolean usable = true;
            if (newVehicle.isReserved()) {
                usable = false;
            }
            if (!newVehicle.getStatus().equals("Parked")) {
                usable = false;
            }
            if (newVehicle.getInventory().getTotalInventoryMass(false) > 0.0) {
                usable = false;
            }
            return usable;
        }
        throw new IllegalArgumentException("isUsableVehicle: newVehicle is null.");
    }

    protected int compareVehicles(Vehicle firstVehicle, Vehicle secondVehicle) {
        if (this.isUsableVehicle(firstVehicle)) {
            if (this.isUsableVehicle(secondVehicle)) {
                return 0;
            }
            return 1;
        }
        if (this.isUsableVehicle(secondVehicle)) {
            return -1;
        }
        return 0;
    }

    protected final boolean reserveVehicle(Person person) {
        ConcurrentLinkedQueue<Vehicle> bestVehicles = new ConcurrentLinkedQueue<Vehicle>();
        for (Vehicle availableVehicle : this.getAvailableVehicles(person.getSettlement())) {
            if (bestVehicles.size() > 0) {
                int comparison = this.compareVehicles(availableVehicle, (Vehicle)bestVehicles.toArray()[0]);
                if (comparison == 0) {
                    bestVehicles.add(availableVehicle);
                    continue;
                }
                if (comparison != 1) continue;
                bestVehicles.clear();
                bestVehicles.add(availableVehicle);
                continue;
            }
            bestVehicles.add(availableVehicle);
        }
        if (bestVehicles.size() > 0) {
            int bestVehicleIndex = RandomUtil.getRandomInt(bestVehicles.size() - 1);
            try {
                this.setVehicle((Vehicle)bestVehicles.toArray()[bestVehicleIndex]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return this.hasVehicle();
    }

    private Collection<Vehicle> getAvailableVehicles(Settlement settlement) {
        ConcurrentLinkedQueue<Vehicle> result = new ConcurrentLinkedQueue<Vehicle>();
        for (Vehicle vehicle : settlement.getParkedVehicles()) {
            if (!this.isUsableVehicle(vehicle)) continue;
            result.add(vehicle);
        }
        return result;
    }

    @Override
    public void endMission(String reason) {
        if (this.hasVehicle() && this.vehicle.getSettlement() == null) {
            this.setEmergencyBeacon(null, this.vehicle, true);
        }
        this.leaveVehicle();
        super.endMission(reason);
    }

    public final boolean isVehicleLoaded() {
        if (this.vehicle == null) {
            throw new IllegalStateException(this.getPhase() + " : vehicle is null");
        }
        try {
            return LoadVehicleGarage.isFullyLoaded(this.getRequiredResourcesToLoad(), this.getOptionalResourcesToLoad(), this.getRequiredEquipmentToLoad(), this.getOptionalEquipmentToLoad(), this.vehicle, this.vehicle.getSettlement());
        }
        catch (Exception e) {
            throw new IllegalStateException(this.getPhase(), e);
        }
    }

    public final boolean isVehicleLoadable() {
        Map<Resource, Number> resources = this.getRequiredResourcesToLoad();
        Map<Class, Integer> equipment = this.getRequiredEquipmentToLoad();
        Vehicle vehicle = this.vehicle;
        Settlement settlement = vehicle.getSettlement();
        double tripTime = this.getEstimatedRemainingMissionTime(true);
        boolean vehicleCapacity = LoadVehicleGarage.enoughCapacityForSupplies(resources, equipment, vehicle, settlement);
        boolean settlementSupplies = LoadVehicleGarage.hasEnoughSupplies(settlement, vehicle, resources, equipment, this.getPeopleNumber(), tripTime);
        if (!vehicleCapacity) {
            logger.info("Vehicle doesn't have capacity.");
        }
        if (!settlementSupplies) {
            logger.info("Settlement doesn't have supplies.");
        }
        return vehicleCapacity && settlementSupplies;
    }

    public static double getFuelNeededForTrip(double tripDistance, double fuelEfficiency, boolean useBuffer) {
        double result = tripDistance / fuelEfficiency;
        if (useBuffer) {
            result *= 1.7;
            result += 50.0 / fuelEfficiency;
        }
        return result;
    }

    @Override
    protected void determineNewPhase() {
        if (EMBARKING.equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase(TRAVELLING);
            this.setPhaseDescription("Travelling to " + this.getNextNavpoint().getDescription());
        } else if (TRAVELLING.equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                this.setPhase(DISEMBARKING);
                this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getDescription());
            }
        } else if (DISEMBARKING.equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (EMBARKING.equals(this.getPhase())) {
            this.performEmbarkFromSettlementPhase(person);
        } else if (TRAVELLING.equals(this.getPhase())) {
            this.performTravelPhase(person);
        } else if (DISEMBARKING.equals(this.getPhase())) {
            this.performDisembarkToSettlementPhase(person, this.getCurrentNavpoint().getSettlement());
        }
    }

    @Override
    protected final void performTravelPhase(Person person) {
        NavPoint destination = this.getNextNavpoint();
        boolean reachedDestination = this.vehicle.getCoordinates().equals(destination.getLocation());
        boolean malfunction = this.vehicle.getMalfunctionManager().hasMalfunction();
        if (!reachedDestination && !malfunction) {
            if (person != this.lastOperator) {
                if (this.vehicle.getOperator() == null) {
                    this.operateVehicleTask = this.operateVehicleTask != null ? this.getOperateVehicleTask(person, this.operateVehicleTask.getTopPhase()) : this.getOperateVehicleTask(person, null);
                    this.assignTask(person, this.operateVehicleTask);
                    this.lastOperator = person;
                } else if (!this.operateVehicleTask.getDestination().equals(destination.getLocation())) {
                    this.operateVehicleTask.setDestination(destination.getLocation());
                    this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
                }
            } else {
                this.lastOperator = null;
            }
        }
        if (reachedDestination) {
            this.reachedNextNode();
            this.setPhaseEnded(true);
        }
        if (!this.hasEnoughResourcesForRemainingMission(false) || this.hasEmergency()) {
            this.determineEmergencyDestination(person);
        }
        if (this.hasUnrepairableMalfunction()) {
            this.endMission("unrepairable malfunction");
        }
    }

    protected abstract OperateVehicle getOperateVehicleTask(Person var1, String var2);

    protected abstract void performEmbarkFromSettlementPhase(Person var1);

    protected abstract void performDisembarkToSettlementPhase(Person var1, Settlement var2);

    @Override
    public final MarsClock getLegETA() {
        if (TRAVELLING.equals(this.getPhase()) && this.operateVehicleTask != null) {
            return this.operateVehicleTask.getETA();
        }
        return null;
    }

    @Override
    public final double getEstimatedTripTime(boolean useBuffer, double distance) {
        double averageSpeed = this.getAverageVehicleSpeedForOperators();
        double millisolsInHour = MarsClock.convertSecondsToMillisols(3600.0);
        double averageSpeedMillisol = averageSpeed / millisolsInHour;
        double result = distance / averageSpeedMillisol;
        if (useBuffer) {
            result += 1000.0;
        }
        return result;
    }

    @Override
    public double getEstimatedRemainingMissionTime(boolean useBuffer) {
        return this.getEstimatedTripTime(useBuffer, this.getTotalRemainingDistance());
    }

    protected final double getAverageVehicleSpeedForOperators() {
        double totalSpeed = 0.0;
        Iterator<Person> i = this.getPeople().iterator();
        while (i.hasNext()) {
            totalSpeed += this.getAverageVehicleSpeedForOperator(i.next());
        }
        return totalSpeed / (double)this.getPeopleNumber();
    }

    private double getAverageVehicleSpeedForOperator(Person person) {
        return OperateVehicle.getAverageVehicleSpeed(this.vehicle, person);
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForRemainingMission(boolean useBuffer) {
        return this.getResourcesNeededForTrip(useBuffer, this.getTotalRemainingDistance());
    }

    public Map<Resource, Number> getResourcesNeededForTrip(boolean useBuffer, double distance) {
        HashMap<Resource, Number> result = new HashMap<Resource, Number>();
        if (this.vehicle != null) {
            result.put(this.vehicle.getFuelType(), VehicleMission.getFuelNeededForTrip(distance, this.vehicle.getFuelEfficiency(), useBuffer));
        }
        return result;
    }

    protected Map<Resource, Number> getPartsNeededForTrip(double distance) {
        HashMap<Resource, Number> result = new HashMap<Resource, Number>();
        if (this.vehicle != null) {
            double drivingTime = this.getEstimatedTripTime(false, distance);
            double numberAccidents = drivingTime * 0.001;
            double numberMalfunctions = numberAccidents * 2.0;
            Map<Part, Double> parts = this.vehicle.getMalfunctionManager().getRepairPartProbabilities();
            for (Part part : parts.keySet()) {
                int number = (int)Math.round(parts.get(part) * numberMalfunctions * 2.0);
                if (number <= 0) continue;
                result.put(part, number);
            }
        }
        return result;
    }

    protected final boolean hasEnoughResourcesForRemainingMission(boolean useBuffers) {
        return this.hasEnoughResources(this.getResourcesNeededForRemainingMission(useBuffers));
    }

    private boolean hasEnoughResources(Map<Resource, Number> neededResources) {
        boolean result = true;
        Inventory inv = this.vehicle.getInventory();
        Iterator<Resource> iR = neededResources.keySet().iterator();
        while (iR.hasNext() && result) {
            Resource resource = iR.next();
            if (resource instanceof AmountResource) {
                double amount = (Double)neededResources.get(resource);
                double amountStored = inv.getAmountResourceStored((AmountResource)resource, false);
                if (!(amountStored < amount)) continue;
                logger.severe(this.vehicle.getName() + " does not have enough " + resource + " to continue with " + this.getName() + " (required: " + amount + " kg, stored: " + amountStored + " kg)");
                result = false;
                continue;
            }
            if (resource instanceof ItemResource) {
                int num = (Integer)neededResources.get(resource);
                int numStored = inv.getItemResourceNum((ItemResource)resource);
                if (numStored >= num) continue;
                logger.severe(this.vehicle.getName() + " does not have enough " + resource + " to continue with " + this.getName() + " (required: " + num + ", stored: " + numStored + ")");
                result = false;
                continue;
            }
            throw new IllegalStateException(this.getPhase() + " : Unknown resource type: " + resource);
        }
        return result;
    }

    protected final void determineEmergencyDestination(Person person) {
        Settlement newDestination = this.findClosestSettlement();
        if (newDestination != null) {
            double distance = this.getCurrentMissionLocation().getDistance(newDestination.getCoordinates());
            if (this.hasEnoughResources(this.getResourcesNeededForTrip(false, distance)) && !this.hasEmergencyAllCrew()) {
                boolean sameDestination = false;
                NavPoint nextNav = this.getNextNavpoint();
                if (nextNav != null && newDestination == nextNav.getSettlement()) {
                    sameDestination = true;
                }
                if (!sameDestination) {
                    logger.info(this.vehicle.getName() + " setting emergency destination to " + newDestination.getName() + ".");
                    MissionHistoricalEvent newEvent = new MissionHistoricalEvent(person, this, "Changing To Emergency Destination");
                    Simulation.instance().getEventManager().registerNewEvent(newEvent);
                    this.clearRemainingNavpoints();
                    this.addNavpoint(new NavPoint(newDestination.getCoordinates(), newDestination, "emergency destination: " + newDestination.getName()));
                    this.associateAllMembersWithSettlement(newDestination);
                }
            } else {
                this.endMission("Not enough resources to continue.");
            }
        } else {
            this.endMission("No emergency settlement destination found.");
        }
    }

    public void setEmergencyBeacon(Person person, Vehicle vehicle, boolean beaconOn) {
        MissionHistoricalEvent newEvent = new MissionHistoricalEvent(person, this, "Emergency Beacon Turned On");
        Simulation.instance().getEventManager().registerNewEvent(newEvent);
        if (beaconOn) {
            logger.info("Emergency beacon activated on " + vehicle.getName());
        } else {
            logger.info("Emergency beacon deactivated on " + vehicle.getName());
        }
        vehicle.setEmergencyBeacon(beaconOn);
    }

    @Override
    public void updateTravelDestination() {
        if (this.operateVehicleTask != null) {
            this.operateVehicleTask.setDestination(this.getNextNavpoint().getLocation());
        }
        this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
    }

    public final Settlement findClosestSettlement() {
        Settlement result = null;
        Coordinates location = this.getCurrentMissionLocation();
        double closestDistance = Double.MAX_VALUE;
        for (Settlement settlement : Simulation.instance().getUnitManager().getSettlements()) {
            double distance = settlement.getCoordinates().getDistance(location);
            if (!(distance < closestDistance)) continue;
            result = settlement;
            closestDistance = distance;
        }
        return result;
    }

    @Override
    public final double getTotalDistanceTravelled() {
        if (this.vehicle != null) {
            return this.vehicle.getTotalDistanceTraveled() - this.startingTravelledDistance;
        }
        return 0.0;
    }

    @Override
    public void timePassing(double time) {
        if (this.hasVehicle() && !this.vehicle.hasUnitListener(this)) {
            this.vehicle.addUnitListener(this);
        }
    }

    @Override
    public void unitUpdate(UnitEvent event) {
        String type = event.getType();
        if (type.equals("location")) {
            this.fireMissionUpdate("distance");
        } else if (type.equals("name")) {
            this.fireMissionUpdate(VEHICLE_EVENT);
        }
    }

    public Map<Resource, Number> getRequiredResourcesToLoad() {
        return this.getResourcesNeededForRemainingMission(true);
    }

    public Map<Resource, Number> getOptionalResourcesToLoad() {
        return this.getPartsNeededForTrip(this.getTotalRemainingDistance());
    }

    public Map<Class, Integer> getRequiredEquipmentToLoad() {
        return this.getEquipmentNeededForRemainingMission(true);
    }

    public Map<Class, Integer> getOptionalEquipmentToLoad() {
        return new HashMap<Class, Integer>(0);
    }

    private boolean hasUnrepairableMalfunction() {
        boolean result = false;
        if (this.vehicle != null) {
            this.vehicle.getMalfunctionManager();
            for (Malfunction malfunction : this.vehicle.getMalfunctionManager().getMalfunctions()) {
                Map<Part, Integer> parts = malfunction.getRepairParts();
                for (Part part : parts.keySet()) {
                    int number = parts.get(part);
                    if (this.vehicle.getInventory().getItemResourceNum(part) >= number) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    protected static boolean hasEmbarkingMissions(Settlement settlement) {
        boolean result = false;
        MissionManager manager = Simulation.instance().getMissionManager();
        Iterator<Mission> i = manager.getMissionsForSettlement(settlement).iterator();
        while (i.hasNext()) {
            if (!EMBARKING.equals(i.next().getPhase())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.vehicle = null;
        this.lastOperator = null;
        this.operateVehicleTask = null;
        if (this.equipmentNeededCache != null) {
            this.equipmentNeededCache.clear();
        }
        this.equipmentNeededCache = null;
    }
}

