/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.social;

import com.phoenixst.plexus.DefaultGraph;
import com.phoenixst.plexus.EdgePredicate;
import com.phoenixst.plexus.EdgePredicateFactory;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.Traverser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.Predicate;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.PersonalityType;
import org.mars_sim.msp.core.person.ai.social.Relationship;
import org.mars_sim.msp.core.structure.Settlement;

public class RelationshipManager
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.person.ai.social.RelationshipManager";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private static final double BASE_RELATIONSHIP_CHANGE_PROBABILITY = 0.1;
    private static final double BASE_RELATIONSHIP_CHANGE_AMOUNT = 0.1;
    private static final double BASE_STRESS_MODIFIER = 0.1;
    private static final double BASE_OPINION_MODIFIER = 0.2;
    private static final double BASE_CONVERSATION_MODIFIER = 0.2;
    private static final double BASE_ATTRACTIVENESS_MODIFIER = 0.1;
    private static final double BASE_GENDER_BONDING_MODIFIER = 0.02;
    private static final double PERSONALITY_DIFF_MODIFIER = 0.1;
    private static final double SETTLER_MODIFIER = 0.02;
    private Graph relationshipGraph = new DefaultGraph();
    int count = 0;

    public void addInitialSettler(Person person, Settlement settlement) {
        this.addPerson(person, settlement.getInhabitants());
    }

    public void addNewImmigrant(Person person, Collection<Person> immigrantGroup) {
        this.addPerson(person, immigrantGroup);
    }

    private void addPerson(Person person, Collection<Person> initialGroup) {
        if (person == null || initialGroup == null) {
            throw new IllegalArgumentException("RelationshipManager.addPerson(): null parameter.");
        }
        if (!this.relationshipGraph.containsNode((Object)person)) {
            this.relationshipGraph.addNode((Object)person);
            for (Person person2 : initialGroup) {
                if (person2 == person) continue;
                this.addRelationship(person, person2, "Existing Relationship");
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest(person.getName() + " and " + person2.getName() + " have existing relationship.  " + this.count);
            }
        }
    }

    public void addRelationship(Person person1, Person person2, String relationshipType) {
        try {
            Relationship relationship = new Relationship(person1, person2, relationshipType);
            this.relationshipGraph.addEdge((Object)relationship, (Object)person1, (Object)person2, false);
            ++this.count;
        }
        catch (NoSuchNodeException e) {
            // empty catch block
        }
    }

    public boolean hasRelationship(Person person1, Person person2) {
        EdgePredicate edgePredicate = EdgePredicateFactory.createEqualsNodes((Object)person1, (Object)person2, (int)1);
        return this.relationshipGraph.getEdge((Predicate)edgePredicate) != null;
    }

    public Relationship getRelationship(Person person1, Person person2) {
        Relationship result = null;
        if (this.hasRelationship(person1, person2)) {
            EdgePredicate edgePredicate = EdgePredicateFactory.createEqualsNodes((Object)person1, (Object)person2, (int)1);
            result = (Relationship)this.relationshipGraph.getEdge((Predicate)edgePredicate).getUserObject();
        }
        return result;
    }

    public List<Relationship> getAllRelationships(Person person) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        Traverser traverser = this.relationshipGraph.traverser((Object)person, GraphUtils.UNDIRECTED_TRAVERSER_PREDICATE);
        while (traverser.hasNext()) {
            traverser.next();
            Relationship relationship = (Relationship)traverser.getEdge().getUserObject();
            result.add(relationship);
        }
        return result;
    }

    public Collection<Person> getAllKnownPeople(Person person) {
        ConcurrentLinkedQueue<Person> result = new ConcurrentLinkedQueue<Person>();
        Traverser traverser = this.relationshipGraph.traverser((Object)person, GraphUtils.UNDIRECTED_TRAVERSER_PREDICATE);
        while (traverser.hasNext()) {
            Person knownPerson = (Person)traverser.next();
            result.add(knownPerson);
        }
        return result;
    }

    public double getOpinionOfPerson(Person person1, Person person2) {
        double result = 50.0;
        if (this.hasRelationship(person1, person2)) {
            Relationship relationship = this.getRelationship(person1, person2);
            result = relationship.getPersonOpinion(person1);
        }
        return result;
    }

    public double getAverageOpinionOfPeople(Person person1, Collection<Person> people) {
        if (people == null) {
            throw new IllegalArgumentException("people is null");
        }
        if (people.size() > 0) {
            double result = 0.0;
            for (Person person2 : people) {
                result += this.getOpinionOfPerson(person1, person2);
            }
            return result /= (double)people.size();
        }
        return 50.0;
    }

    public void timePassing(Person person, double time) {
        this.updateRelationships(person, time);
        this.modifyStress(person, time);
    }

    private void updateRelationships(Person person, double time) {
        double personStress = person.getPhysicalCondition().getStress();
        Collection<Person> localGroup = person.getLocalGroup();
        Iterator<Person> i = localGroup.iterator();
        int count2 = 0;
        while (i.hasNext()) {
            boolean oppositeGenders;
            double stressProbModifier;
            double changeProbability;
            Person localPerson = i.next();
            double localPersonStress = localPerson.getPhysicalCondition().getStress();
            if (!this.hasRelationship(person, localPerson)) {
                this.addRelationship(person, localPerson, "First Impression");
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(person.getName() + " and " + localPerson.getName() + " meet for the first time.  " + this.count);
                }
            }
            if (!RandomUtil.lessThanRandPercent((changeProbability = 0.1 * time) * (stressProbModifier = 1.0 + (personStress + localPersonStress) / 100.0))) continue;
            double changeAmount = RandomUtil.getRandomDouble(0.1) * time;
            if (RandomUtil.lessThanRandPercent(50)) {
                changeAmount = 0.0 - changeAmount;
            }
            double otherOpinionModifier = (this.getOpinionOfPerson(localPerson, person) - this.getOpinionOfPerson(person, localPerson)) / 100.0;
            changeAmount += RandomUtil.getRandomDouble(otherOpinionModifier *= 0.2 * time);
            double conversation = localPerson.getNaturalAttributeManager().getAttribute("Conversation");
            double conversationModifier = (conversation - 50.0) / 50.0;
            changeAmount += RandomUtil.getRandomDouble(conversationModifier *= 0.2 * time);
            double attractiveness = localPerson.getNaturalAttributeManager().getAttribute("Attractiveness");
            double attractivenessModifier = (attractiveness - 50.0) / 50.0;
            attractivenessModifier *= 0.1 * time;
            boolean bl = oppositeGenders = !person.getGender().equals(localPerson.getGender());
            if (oppositeGenders) {
                RandomUtil.getRandomDouble(changeAmount += attractivenessModifier);
            }
            double genderBondingModifier = 0.02 * time;
            if (!oppositeGenders) {
                RandomUtil.getRandomDouble(changeAmount += genderBondingModifier);
            }
            PersonalityType personPersonality = person.getMind().getPersonalityType();
            PersonalityType localPersonality = localPerson.getMind().getPersonalityType();
            double personalityDiffModifier = (2.0 - (double)personPersonality.getPersonalityDifference(localPersonality.getTypeString())) / 2.0;
            changeAmount += RandomUtil.getRandomDouble(personalityDiffModifier *= 0.1 * time);
            double settlerModifier = 0.02 * time;
            changeAmount += RandomUtil.getRandomDouble(settlerModifier);
            double stressChangeModifier = 1.0 + (personStress + localPersonStress) / 100.0;
            changeAmount *= stressChangeModifier;
            Relationship relationship = this.getRelationship(person, localPerson);
            if (relationship != null) {
                relationship.setPersonOpinion(person, relationship.getPersonOpinion(person) + changeAmount);
            }
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest(person.getName() + " has changed opinion of " + localPerson.getName() + " by " + changeAmount);
        }
        ++count2;
    }

    private void modifyStress(Person person, double time) {
        double stressModifier = 0.0;
        Iterator<Person> i = person.getLocalGroup().iterator();
        while (i.hasNext()) {
            stressModifier -= (this.getOpinionOfPerson(person, i.next()) - 50.0) / 50.0;
        }
        stressModifier = stressModifier * 0.1 * time;
        PhysicalCondition condition = person.getPhysicalCondition();
        condition.setStress(condition.getStress() + stressModifier);
    }

    public void destroy() {
        this.relationshipGraph = null;
    }
}

