/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.vehicle.Rover;

public class AreologyStudyFieldWork
extends EVAOperation
implements Serializable {
    private static final String FIELD_WORK = "Performing Field Work";
    private Person leadResearcher;
    private ScientificStudy study;
    private Rover rover;

    public AreologyStudyFieldWork(Person person, Person leadResearcher, ScientificStudy study, Rover rover) {
        super("Areology Study Field Work", person);
        this.leadResearcher = leadResearcher;
        this.study = study;
        this.rover = rover;
        this.addPhase(FIELD_WORK);
    }

    public static boolean canResearchSite(Person person, Rover rover) {
        boolean exitable = ExitAirlock.canExitAirlock(person, rover.getAirlock());
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        boolean sunlight = surface.getSurfaceSunlight(rover.getCoordinates()) > 0.0;
        boolean darkRegion = surface.inDarkPolarRegion(rover.getCoordinates());
        boolean medical = person.getPerformanceRating() < 0.5;
        return exitable && (sunlight || darkRegion) && !medical;
    }

    private double exitRover(double time) {
        try {
            time = this.exitAirlock(time, this.rover.getAirlock());
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(FIELD_WORK);
        }
        return time;
    }

    private double enterRover(double time) {
        time = this.enterAirlock(time, this.rover.getAirlock());
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
            return time;
        }
        return 0.0;
    }

    private double fieldWorkPhase(double time) {
        this.checkForAccident(time);
        if (this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        this.addResearchWorkTime(time);
        this.addExperience(time);
        return 0.0;
    }

    private void addResearchWorkTime(double time) {
        double effectiveFieldWorkTime = time;
        int skill = this.getEffectiveSkillLevel();
        if (skill == 0) {
            effectiveFieldWorkTime /= 2.0;
        }
        if (skill > 1) {
            effectiveFieldWorkTime += effectiveFieldWorkTime * (0.2 * (double)skill);
        }
        if (!this.person.equals(this.leadResearcher)) {
            effectiveFieldWorkTime /= 2.0;
        }
        if (this.study.getPrimaryResearcher().equals(this.leadResearcher)) {
            this.study.addPrimaryResearchWorkTime(effectiveFieldWorkTime);
        } else {
            this.study.addCollaborativeResearchWorkTime(this.leadResearcher, effectiveFieldWorkTime);
        }
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (FIELD_WORK.equals(this.getPhase())) {
            double areologyExperience = time / 10.0;
            areologyExperience += areologyExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Areology", areologyExperience);
        }
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add("Areology");
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int areologySkill = manager.getEffectiveSkillLevel("Areology");
        return (int)Math.round((double)(EVAOperationsSkill + areologySkill) / 2.0);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitRover(time);
        }
        if (FIELD_WORK.equals(this.getPhase())) {
            return this.fieldWorkPhase(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterRover(time);
        }
        return time;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.leadResearcher = null;
        this.study = null;
        this.rover = null;
    }
}

