/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.vehicle.Rover;

public class CollectResources
extends EVAOperation
implements Serializable {
    private static final String COLLECT_RESOURCES = "Collecting Resources";
    protected Rover rover;
    protected double collectionRate;
    protected double targettedAmount;
    protected double startingCargo;
    protected AmountResource resourceType;
    protected Class containerType;

    public CollectResources(String taskName, Person person, Rover rover, AmountResource resourceType, double collectionRate, double targettedAmount, double startingCargo, Class containerType) {
        super(taskName, person);
        this.rover = rover;
        this.collectionRate = collectionRate;
        this.targettedAmount = targettedAmount;
        this.startingCargo = startingCargo;
        this.resourceType = resourceType;
        this.containerType = containerType;
        this.addPhase(COLLECT_RESOURCES);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitRover(time);
        }
        if (COLLECT_RESOURCES.equals(this.getPhase())) {
            return this.collectResources(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterRover(time);
        }
        return time;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (COLLECT_RESOURCES.equals(this.getPhase())) {
            double areologyExperience = time / 10.0;
            areologyExperience += areologyExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Areology", areologyExperience);
        }
    }

    private double exitRover(double time) {
        try {
            time = this.exitAirlock(time, this.rover.getAirlock());
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            if (!this.hasContainers()) {
                this.takeContainer();
            }
            if (this.hasContainers()) {
                this.setPhase(COLLECT_RESOURCES);
            } else {
                this.setPhase("Enter Airlock");
            }
        }
        return time;
    }

    private boolean hasContainers() {
        return this.person.getInventory().containsUnitClass(this.containerType);
    }

    private void takeContainer() {
        Unit container = CollectResources.findLeastFullContainer(this.rover.getInventory(), this.containerType, this.resourceType);
        if (container != null && this.person.getInventory().canStoreUnit(container, false)) {
            this.rover.getInventory().retrieveUnit(container);
            this.person.getInventory().storeUnit(container);
        }
    }

    private static Unit findLeastFullContainer(Inventory inv, Class containerType, AmountResource resource) {
        Unit result = null;
        double mostCapacity = 0.0;
        for (Unit container : inv.findAllUnitsOfClass(containerType)) {
            double remainingCapacity = container.getInventory().getAmountResourceRemainingCapacity(resource, true, false);
            if (!(remainingCapacity > mostCapacity)) continue;
            result = container;
            mostCapacity = remainingCapacity;
        }
        return result;
    }

    private double collectResources(double time) {
        this.checkForAccident(time);
        if (this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        double remainingPersonCapacity = this.person.getInventory().getAmountResourceRemainingCapacity(this.resourceType, true, false);
        double currentSamplesCollected = this.rover.getInventory().getAmountResourceStored(this.resourceType, false) - this.startingCargo;
        double remainingSamplesNeeded = this.targettedAmount - currentSamplesCollected;
        double sampleLimit = remainingPersonCapacity;
        if (remainingSamplesNeeded < remainingPersonCapacity) {
            sampleLimit = remainingSamplesNeeded;
        }
        double samplesCollected = time * this.collectionRate;
        int areologySkill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Areology");
        if (areologySkill == 0) {
            samplesCollected /= 2.0;
        }
        if (areologySkill > 1) {
            samplesCollected += samplesCollected * (0.2 * (double)areologySkill);
        }
        if (this.resourceType.equals(AmountResource.findAmountResource("ice")) && Simulation.instance().getMars().getSurfaceFeatures().inPolarRegion(this.person.getCoordinates())) {
            samplesCollected *= 3.0;
        }
        this.addExperience(time);
        if (samplesCollected <= sampleLimit) {
            this.person.getInventory().storeAmountResource(this.resourceType, samplesCollected, true);
            return 0.0;
        }
        if (sampleLimit >= 0.0) {
            this.person.getInventory().storeAmountResource(this.resourceType, sampleLimit, true);
        }
        this.setPhase("Enter Airlock");
        return time - sampleLimit / this.collectionRate;
    }

    private double enterRover(double time) {
        time = this.enterAirlock(time, this.rover.getAirlock());
        this.addExperience(time);
        if (this.enteredAirlock) {
            Inventory pInv = this.person.getInventory();
            if (pInv.containsUnitClass(this.containerType)) {
                for (Unit container : pInv.findAllUnitsOfClass(this.containerType)) {
                    pInv.retrieveUnit(container);
                    this.rover.getInventory().storeUnit(container);
                }
            } else {
                this.endTask();
                return time;
            }
        }
        return 0.0;
    }

    public static boolean canCollectResources(Person person, Rover rover, Class containerType, AmountResource resourceType) {
        double carryCapacity;
        EVASuit suit;
        boolean exitable = ExitAirlock.canExitAirlock(person, rover.getAirlock());
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        boolean sunlight = surface.getSurfaceSunlight(rover.getCoordinates()) > 0.0;
        boolean darkRegion = surface.inDarkPolarRegion(rover.getCoordinates());
        boolean medical = person.getPerformanceRating() < 0.5;
        Unit container = CollectResources.findLeastFullContainer(rover.getInventory(), containerType, resourceType);
        boolean containerAvailable = container != null;
        double carryMass = 0.0;
        if (container != null) {
            carryMass += container.getMass();
        }
        if ((suit = (EVASuit)rover.getInventory().findUnitOfClass(EVASuit.class)) != null) {
            carryMass += suit.getMass();
            AmountResource oxygenResource = AmountResource.findAmountResource("oxygen");
            carryMass += suit.getInventory().getAmountResourceRemainingCapacity(oxygenResource, false, false);
            AmountResource waterResource = AmountResource.findAmountResource("water");
            carryMass += suit.getInventory().getAmountResourceRemainingCapacity(waterResource, false, false);
        }
        boolean canCarryEquipment = (carryCapacity = person.getInventory().getGeneralCapacity()) >= carryMass;
        return exitable && (sunlight || darkRegion) && !medical && containerAvailable && canCarryEquipment;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int areologySkill = manager.getEffectiveSkillLevel("Areology");
        return (int)Math.round((double)(EVAOperationsSkill + areologySkill) / 2.0);
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add("Areology");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.rover = null;
        this.resourceType = null;
        this.containerType = null;
    }
}

