/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;

public class ConstructBuilding
extends EVAOperation
implements Serializable {
    private static Logger logger = Logger.getLogger(ConstructBuilding.class.getName());
    private static final String CONSTRUCTION = "Construction";
    public static final double BASE_LUV_ACCIDENT_CHANCE = 0.001;
    private ConstructionStage stage;
    private ConstructionSite site;
    private List<GroundVehicle> vehicles;
    private Airlock airlock;
    private LightUtilityVehicle luv;
    private boolean operatingLUV;

    public ConstructBuilding(Person person, ConstructionStage stage, ConstructionSite site, List<GroundVehicle> vehicles) {
        super("Construct Building", person);
        this.stage = stage;
        this.site = site;
        this.vehicles = vehicles;
        this.airlock = ConstructBuilding.getAvailableAirlock(person);
        if (this.airlock == null) {
            this.endTask();
        }
        this.addPhase(CONSTRUCTION);
    }

    public static boolean canConstruct(Person person) {
        SurfaceFeatures surface;
        boolean exitable = false;
        Airlock airlock = ConstructBuilding.getAvailableAirlock(person);
        if (airlock != null) {
            exitable = ExitAirlock.canExitAirlock(person, airlock);
        }
        boolean sunlight = (surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) > 0.0;
        boolean darkRegion = surface.inDarkPolarRegion(person.getCoordinates());
        boolean medical = person.getPerformanceRating() < 0.5;
        return exitable && (sunlight || darkRegion) && !medical;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitEVA(time);
        }
        if (CONSTRUCTION.equals(this.getPhase())) {
            return this.construction(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterEVA(time);
        }
        return time;
    }

    private double exitEVA(double time) {
        try {
            time = this.exitAirlock(time, this.airlock);
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(CONSTRUCTION);
            this.moveToConstructionSiteLocation();
        }
        return time;
    }

    private double enterEVA(double time) {
        time = this.enterAirlock(time, this.airlock);
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
        }
        return time;
    }

    private double construction(double time) {
        this.checkForAccident(time);
        if (this.shouldEndEVAOperation() || this.stage.isComplete()) {
            if (this.luv != null && this.luv.getInventory().containsUnit(this.person)) {
                this.returnVehicle();
            }
            this.setPhase("Enter Airlock");
            return time;
        }
        if (!this.operatingLUV) {
            this.obtainVehicle();
        }
        double workTime = time;
        int skill = this.getEffectiveSkillLevel();
        if (skill == 0) {
            workTime /= 2.0;
        }
        if (skill > 1) {
            workTime += workTime * (0.2 * (double)skill);
        }
        this.stage.addWorkTime(workTime);
        this.addExperience(time);
        this.checkForAccident(time);
        return 0.0;
    }

    private void moveToConstructionSiteLocation() {
        Point2D.Double relativeLocSite = LocalAreaUtil.getRandomInteriorLocation(this.site);
        Point2D.Double settlementLocSite = LocalAreaUtil.getLocalRelativeLocation(relativeLocSite.getX(), relativeLocSite.getY(), this.site);
        this.person.setXLocation(settlementLocSite.getX());
        this.person.setYLocation(settlementLocSite.getY());
    }

    private void obtainVehicle() {
        Iterator<GroundVehicle> i = this.vehicles.iterator();
        while (i.hasNext() && this.luv == null) {
            LightUtilityVehicle tempLuv;
            GroundVehicle vehicle = i.next();
            if (vehicle.getMalfunctionManager().hasMalfunction() || !(vehicle instanceof LightUtilityVehicle) || (tempLuv = (LightUtilityVehicle)vehicle).getOperator() != null) continue;
            tempLuv.getInventory().storeUnit(this.person);
            tempLuv.setOperator(this.person);
            this.luv = tempLuv;
            this.operatingLUV = true;
            Point2D.Double relativeLocSite = LocalAreaUtil.getRandomInteriorLocation(this.site);
            Point2D.Double settlementLocSite = LocalAreaUtil.getLocalRelativeLocation(relativeLocSite.getX(), relativeLocSite.getY(), this.site);
            this.luv.setParkedLocation(settlementLocSite.getX(), settlementLocSite.getY(), RandomUtil.getRandomDouble(360.0));
            break;
        }
    }

    private void returnVehicle() {
        this.luv.getInventory().retrieveUnit(this.person);
        this.luv.setOperator(null);
        this.operatingLUV = false;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int constructionSkill = manager.getEffectiveSkillLevel(CONSTRUCTION);
        return (int)Math.round((double)(EVAOperationsSkill + constructionSkill) / 2.0);
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add(CONSTRUCTION);
        return results;
    }

    @Override
    protected void addExperience(double time) {
        SkillManager manager = this.person.getMind().getSkillManager();
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        manager.addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (CONSTRUCTION.equals(this.getPhase())) {
            double constructionExperience = time / 10.0;
            constructionExperience += constructionExperience * experienceAptitudeModifier;
            manager.addExperience(CONSTRUCTION, constructionExperience);
            if (this.operatingLUV) {
                double drivingExperience = time / 10.0;
                drivingExperience += drivingExperience * experienceAptitudeModifier;
                manager.addExperience("Driving", drivingExperience);
            }
        }
    }

    @Override
    protected void checkForAccident(double time) {
        super.checkForAccident(time);
        if (this.operatingLUV) {
            double chance = 0.001;
            int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("EVA Operations");
            chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
            if (RandomUtil.lessThanRandPercent((chance *= this.luv.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
                this.luv.getMalfunctionManager().accident();
            }
        }
    }

    @Override
    protected boolean shouldEndEVAOperation() {
        boolean result = super.shouldEndEVAOperation();
        if (this.operatingLUV && this.luv.getMalfunctionManager().hasMalfunction()) {
            result = true;
        }
        return result;
    }

    public ConstructionStage getConstructionStage() {
        return this.stage;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.stage = null;
        if (this.vehicles != null) {
            this.vehicles.clear();
        }
        this.vehicles = null;
        this.airlock = null;
        this.luv = null;
    }
}

