/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Cooking;

public class CookMeal
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(CookMeal.class.getName());
    private static final String COOKING = "Cooking";
    private static final double STRESS_MODIFIER = -0.1;
    private static final double BREAKFAST_START = 300.0;
    private static final double LUNCH_START = 500.0;
    private static final double DINNER_START = 700.0;
    private static final double MEALTIME_DURATION = 100.0;
    private Cooking kitchen;

    public CookMeal(Person person) {
        super(COOKING, person, true, false, -0.1, false, 0.0);
        this.setDescription("Cooking " + this.getMealName());
        Building kitchenBuilding = CookMeal.getAvailableKitchen(person);
        if (kitchenBuilding != null) {
            this.kitchen = (Cooking)kitchenBuilding.getFunction(COOKING);
            BuildingManager.addPersonToBuilding(person, kitchenBuilding);
        } else {
            this.endTask();
        }
        this.addPhase(COOKING);
        this.setPhase(COOKING);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (CookMeal.isMealTime(person)) {
            try {
                Building kitchenBuilding = CookMeal.getAvailableKitchen(person);
                if (kitchenBuilding != null) {
                    result = 200.0;
                    result *= Task.getCrowdingProbabilityModifier(person, kitchenBuilding);
                    result *= Task.getRelationshipModifier(person, kitchenBuilding);
                    PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
                    double foodRequired = config.getFoodConsumptionRate() * 0.3333333333333333;
                    AmountResource food = AmountResource.findAmountResource("food");
                    double foodAvailable = person.getSettlement().getInventory().getAmountResourceStored(food, false);
                    if (foodAvailable < foodRequired) {
                        result = 0.0;
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "CookMeal.getProbability()", e);
            }
            result *= person.getPerformanceRating();
            Job job = person.getMind().getJob();
            if (job != null) {
                result *= job.getStartTaskProbabilityModifier(CookMeal.class);
            }
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (COOKING.equals(this.getPhase())) {
            return this.cookingPhase(time);
        }
        return time;
    }

    private double cookingPhase(double time) {
        if (this.kitchen.getBuilding().getMalfunctionManager().hasMalfunction()) {
            this.endTask();
            return time;
        }
        if (!CookMeal.isMealTime(this.person)) {
            this.endTask();
            this.kitchen.cleanup();
            return time;
        }
        double workTime = time;
        int cookingSkill = this.getEffectiveSkillLevel();
        workTime = cookingSkill == 0 ? (workTime /= 2.0) : (workTime += workTime * (0.2 * (double)cookingSkill));
        this.kitchen.addWork(workTime);
        this.addExperience(time);
        this.checkForAccident(time);
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 25.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience(COOKING, newPoints *= this.getTeachingExperienceModifier());
    }

    public Cooking getKitchen() {
        return this.kitchen;
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel(COOKING);
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.kitchen.getBuilding().getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            this.kitchen.getBuilding().getMalfunctionManager().accident();
        }
    }

    private static boolean isMealTime(Person person) {
        double timeDiff;
        boolean result = false;
        double timeOfDay = Simulation.instance().getMasterClock().getMarsClock().getMillisol();
        double modifiedTime = timeOfDay + (timeDiff = 1000.0 * (person.getCoordinates().getTheta() / (Math.PI * 2)));
        if (modifiedTime >= 1000.0) {
            modifiedTime -= 1000.0;
        }
        if (modifiedTime >= 300.0 && modifiedTime <= 400.0) {
            result = true;
        }
        if (modifiedTime >= 500.0 && modifiedTime <= 600.0) {
            result = true;
        }
        if (modifiedTime >= 700.0 && modifiedTime <= 800.0) {
            result = true;
        }
        return result;
    }

    private String getMealName() {
        double timeDiff;
        String result = "";
        double timeOfDay = Simulation.instance().getMasterClock().getMarsClock().getMillisol();
        double modifiedTime = timeOfDay + (timeDiff = 1000.0 * (this.person.getCoordinates().getTheta() / (Math.PI * 2)));
        if (modifiedTime >= 1000.0) {
            modifiedTime -= 1000.0;
        }
        if (modifiedTime >= 300.0 && modifiedTime <= 400.0) {
            result = "Breakfast";
        }
        if (modifiedTime >= 500.0 && modifiedTime <= 600.0) {
            result = "Lunch";
        }
        if (modifiedTime >= 700.0 && modifiedTime <= 800.0) {
            result = "Dinner";
        }
        return result;
    }

    private static Building getAvailableKitchen(Person person) {
        Building result = null;
        String location = person.getLocationSituation();
        if (location.equals("In Settlement")) {
            BuildingManager manager = person.getSettlement().getBuildingManager();
            List<Building> kitchenBuildings = manager.getBuildings(COOKING);
            kitchenBuildings = BuildingManager.getNonMalfunctioningBuildings(kitchenBuildings);
            kitchenBuildings = CookMeal.getKitchensNeedingCooks(kitchenBuildings);
            if ((kitchenBuildings = BuildingManager.getLeastCrowdedBuildings(kitchenBuildings)).size() > 0) {
                Map<Building, Double> kitchenBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, kitchenBuildings);
                result = RandomUtil.getWeightedRandomObject(kitchenBuildingProbs);
            }
        }
        return result;
    }

    private static List<Building> getKitchensNeedingCooks(List<Building> kitchenBuildings) {
        ArrayList<Building> result = new ArrayList<Building>();
        if (kitchenBuildings != null) {
            for (Building building : kitchenBuildings) {
                Cooking kitchen = (Cooking)building.getFunction(COOKING);
                if (kitchen.getNumCooks() >= kitchen.getCookCapacity()) continue;
                result.add(building);
            }
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel(COOKING);
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add(COOKING);
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.kitchen = null;
    }
}

