/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;

public class DigLocalRegolith
extends EVAOperation
implements Serializable {
    private static Logger logger = Logger.getLogger(DigLocalRegolith.class.getName());
    private static final String COLLECT_REGOLITH = "Collecting Regolith";
    private static final double COLLECTION_RATE = 20.0;
    private Airlock airlock;
    private Bag bag;
    private Settlement settlement;

    public DigLocalRegolith(Person person) {
        super("Digging local regolith", person);
        this.settlement = person.getSettlement();
        this.airlock = DigLocalRegolith.getAvailableAirlock(person);
        if (this.airlock == null) {
            this.endTask();
        }
        this.addPhase(COLLECT_REGOLITH);
        logger.finest(person.getName() + " starting DigLocalRegolith task.");
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            SurfaceFeatures surface;
            int numEmptyBags;
            Settlement settlement = person.getSettlement();
            Inventory inv = settlement.getInventory();
            try {
                GoodsManager manager = settlement.getGoodsManager();
                AmountResource regolithResource = AmountResource.findAmountResource("regolith");
                double value = manager.getGoodValuePerItem(GoodsUtil.getResourceGood(regolithResource));
                result = value * 50.0;
                if (result > 100.0) {
                    result = 100.0;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error checking good value of regolith.");
            }
            int numSuits = inv.findNumUnitsOfClass(EVASuit.class);
            if (numSuits == 0) {
                result = 0.0;
            }
            if ((numEmptyBags = inv.findNumEmptyUnitsOfClass(Bag.class, false)) == 0) {
                result = 0.0;
            }
            if (DigLocalRegolith.getAvailableAirlock(person) == null) {
                result = 0.0;
            }
            if ((surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) == 0.0 && !surface.inDarkPolarRegion(person.getCoordinates())) {
                result = 0.0;
            }
            if (settlement.getCurrentPopulationNum() > settlement.getPopulationCapacity()) {
                result *= 2.0;
            }
            result *= person.getPerformanceRating();
            Job job = person.getMind().getJob();
            if (job != null) {
                result *= job.getStartTaskProbabilityModifier(DigLocalRegolith.class);
            }
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitEVA(time);
        }
        if (COLLECT_REGOLITH.equals(this.getPhase())) {
            return this.collectRegolith(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterEVA(time);
        }
        return time;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (COLLECT_REGOLITH.equals(this.getPhase())) {
            double areologyExperience = time / 10.0;
            areologyExperience += areologyExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Areology", areologyExperience);
        }
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add("Areology");
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int areologySkill = manager.getEffectiveSkillLevel("Areology");
        return (int)Math.round((double)(EVAOperationsSkill + areologySkill) / 2.0);
    }

    private double exitEVA(double time) {
        try {
            time = this.exitAirlock(time, this.airlock);
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            if (this.bag == null) {
                Bag emptyBag = null;
                Iterator<Unit> i = this.settlement.getInventory().findAllUnitsOfClass(Bag.class).iterator();
                while (i.hasNext() && emptyBag == null) {
                    Bag foundBag = (Bag)i.next();
                    if (foundBag.getInventory().getTotalInventoryMass(false) != 0.0) continue;
                    emptyBag = foundBag;
                }
                if (emptyBag != null && this.person.getInventory().canStoreUnit(emptyBag, false)) {
                    this.settlement.getInventory().retrieveUnit(emptyBag);
                    this.person.getInventory().storeUnit(emptyBag);
                    this.bag = emptyBag;
                }
            }
            if (this.bag != null) {
                this.setPhase(COLLECT_REGOLITH);
                this.moveToDiggingLocation();
            } else {
                logger.log(Level.SEVERE, "Unable to find empty bag in settlement inventory");
                this.setPhase("Enter Airlock");
            }
        }
        return time;
    }

    private void moveToDiggingLocation() {
        Point2D.Double newLocation = null;
        boolean goodLocation = false;
        for (int x = 0; x < 5 && !goodLocation; ++x) {
            for (int y = 0; y < 10 && !goodLocation; ++y) {
                if (!(this.airlock.getEntity() instanceof LocalBoundedObject)) continue;
                LocalBoundedObject boundedObject = (LocalBoundedObject)this.airlock.getEntity();
                double distance = RandomUtil.getRandomDouble(100.0) + (double)x * 100.0 + 50.0;
                double radianDirection = RandomUtil.getRandomDouble(Math.PI * 2);
                double newXLoc = boundedObject.getXLocation() - distance * Math.sin(radianDirection);
                double newYLoc = boundedObject.getYLocation() + distance * Math.cos(radianDirection);
                Point2D.Double boundedLocalPoint = new Point2D.Double(newXLoc, newYLoc);
                newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), boundedObject);
                goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
            }
        }
        this.person.setXLocation(newLocation.getX());
        this.person.setYLocation(newLocation.getY());
    }

    private double enterEVA(double time) {
        time = this.enterAirlock(time, this.airlock);
        this.addExperience(time);
        if (this.enteredAirlock) {
            if (this.bag != null) {
                double settlementCap;
                AmountResource regolithResource = AmountResource.findAmountResource("regolith");
                double collectedAmount = this.bag.getInventory().getAmountResourceStored(regolithResource, false);
                if (collectedAmount < (settlementCap = this.settlement.getInventory().getAmountResourceRemainingCapacity(regolithResource, false, false))) {
                    this.bag.getInventory().retrieveAmountResource(regolithResource, collectedAmount);
                    this.settlement.getInventory().storeAmountResource(regolithResource, collectedAmount, false);
                }
                this.person.getInventory().retrieveUnit(this.bag);
                this.settlement.getInventory().storeUnit(this.bag);
                GoodsManager goodsManager = this.settlement.getGoodsManager();
                goodsManager.updateGoodValue(GoodsUtil.getResourceGood(regolithResource), false);
            }
            this.endTask();
        }
        return time;
    }

    private double collectRegolith(double time) {
        this.checkForAccident(time);
        if (this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        AmountResource regolith = AmountResource.findAmountResource("regolith");
        double remainingPersonCapacity = this.person.getInventory().getAmountResourceRemainingCapacity(regolith, true, false);
        double regolithCollected = time * 20.0;
        boolean finishedCollecting = false;
        if (regolithCollected > remainingPersonCapacity) {
            regolithCollected = remainingPersonCapacity;
            finishedCollecting = true;
        }
        this.person.getInventory().storeAmountResource(regolith, regolithCollected, true);
        if (finishedCollecting) {
            this.setPhase("Enter Airlock");
        }
        this.addExperience(time);
        return 0.0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.airlock = null;
        this.bag = null;
        this.settlement = null;
    }
}

