/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.task.OperateVehicle;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.GroundVehicle;

public class DriveGroundVehicle
extends OperateVehicle
implements Serializable {
    public static final String AVOID_OBSTACLE = "Avoiding Obstacle";
    public static final String WINCH_VEHICLE = "Winching Stuck Vehicle";
    private static final double STRESS_MODIFIER = 0.1;
    private static final int NONE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private int sideDirection = 0;

    public DriveGroundVehicle(Person person, GroundVehicle vehicle, Coordinates destination, MarsClock startTripTime, double startTripDistance) {
        super("Driving vehicle", person, vehicle, destination, startTripTime, startTripDistance, 0.1, true, 300.0 + RandomUtil.getRandomDouble(100.0));
        this.setDescription("Driving " + vehicle.getName());
        this.addPhase(AVOID_OBSTACLE);
        this.addPhase(WINCH_VEHICLE);
    }

    public DriveGroundVehicle(Person person, GroundVehicle vehicle, Coordinates destination, MarsClock startTripTime, double startTripDistance, String startingPhase) {
        super("Driving vehicle", person, vehicle, destination, startTripTime, startTripDistance, 0.1, true, 100.0 + RandomUtil.getRandomDouble(100.0));
        this.setDescription("Driving " + vehicle.getName());
        this.addPhase(AVOID_OBSTACLE);
        this.addPhase(WINCH_VEHICLE);
        if (startingPhase != null && startingPhase.length() != 0) {
            this.setPhase(startingPhase);
        }
    }

    @Override
    protected double performMappedPhase(double time) {
        time = super.performMappedPhase(time);
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (AVOID_OBSTACLE.equals(this.getPhase())) {
            return this.obstaclePhase(time);
        }
        if (WINCH_VEHICLE.equals(this.getPhase())) {
            return this.winchingPhase(time);
        }
        return time;
    }

    @Override
    protected double mobilizeVehicle(double time) {
        if (((GroundVehicle)this.getVehicle()).isStuck() && !WINCH_VEHICLE.equals(this.getPhase())) {
            this.setPhase(WINCH_VEHICLE);
            return time;
        }
        if (this.getVehicle().getSpeed() < 1.0 && !AVOID_OBSTACLE.equals(this.getPhase()) && !WINCH_VEHICLE.equals(this.getPhase())) {
            this.setPhase(AVOID_OBSTACLE);
            return time;
        }
        return super.mobilizeVehicle(time);
    }

    private double obstaclePhase(double time) {
        double timeUsed = 0.0;
        GroundVehicle vehicle = (GroundVehicle)this.getVehicle();
        this.updateVehicleElevationAltitude();
        Direction destinationDirection = vehicle.getCoordinates().getDirectionToPoint(this.getDestination());
        double destinationSpeed = this.getSpeed(destinationDirection);
        if (destinationSpeed >= 1.0) {
            vehicle.setDirection(destinationDirection);
            this.setPhase("Mobilize Vehicle");
            this.sideDirection = 0;
            return time;
        }
        Direction travelDirection = this.getObstacleAvoidanceDirection();
        if (travelDirection == null) {
            this.setPhase(WINCH_VEHICLE);
            this.sideDirection = 0;
            return time;
        }
        vehicle.setDirection(travelDirection);
        vehicle.setSpeed(this.getSpeed(vehicle.getDirection()));
        timeUsed = time - this.mobilizeVehicle(time);
        this.addExperience(time);
        if (!this.isDone()) {
            this.checkForAccident(timeUsed);
        }
        if (this.getVehicle().getMalfunctionManager().hasMalfunction()) {
            this.endTask();
        }
        return time - timeUsed;
    }

    private double winchingPhase(double time) {
        double timeUsed = 0.0;
        GroundVehicle vehicle = (GroundVehicle)this.getVehicle();
        vehicle.setDirection(vehicle.getCoordinates().getDirectionToPoint(this.getDestination()));
        this.updateVehicleElevationAltitude();
        if (this.getSpeed(vehicle.getDirection()) > 1.0) {
            this.setPhase("Mobilize Vehicle");
            vehicle.setStuck(false);
            return time;
        }
        vehicle.setSpeed(0.2);
        timeUsed = time - this.mobilizeVehicle(time);
        this.addExperience(time);
        if (!this.isDone()) {
            this.checkForAccident(timeUsed);
        }
        if (this.getVehicle().getMalfunctionManager().hasMalfunction()) {
            this.endTask();
        }
        return time - timeUsed;
    }

    private Direction getObstacleAvoidanceDirection() {
        Direction result = null;
        GroundVehicle vehicle = (GroundVehicle)this.getVehicle();
        boolean foundGoodPath = false;
        double initialDirection = vehicle.getCoordinates().getDirectionToPoint(this.getDestination()).getDirection();
        if (this.sideDirection == 0) {
            for (int x = 1; x < 11 && !foundGoodPath; ++x) {
                double modAngle = (double)x * 0.3141592653589793;
                for (int y = 1; y < 3 && !foundGoodPath; ++y) {
                    Direction testDirection = null;
                    testDirection = y == 1 ? new Direction(initialDirection - modAngle) : new Direction(initialDirection + modAngle);
                    double testSpeed = this.getSpeed(testDirection);
                    if (!(testSpeed > 1.0)) continue;
                    result = testDirection;
                    this.sideDirection = y == 1 ? 1 : 2;
                    foundGoodPath = true;
                }
            }
        } else {
            for (int x = 1; x < 21 && !foundGoodPath; ++x) {
                double modAngle = (double)x * 0.3141592653589793;
                Direction testDirection = null;
                testDirection = this.sideDirection == 1 ? new Direction(initialDirection - modAngle) : new Direction(initialDirection + modAngle);
                double testSpeed = this.getSpeed(testDirection);
                if (!(testSpeed > 1.0)) continue;
                result = testDirection;
                foundGoodPath = true;
            }
        }
        return result;
    }

    @Override
    protected void updateVehicleElevationAltitude() {
        ((GroundVehicle)this.getVehicle()).setElevation(this.getVehicleElevation());
    }

    @Override
    protected double getSpeed(Direction direction) {
        double result = super.getSpeed(direction);
        result *= this.getSpeedLightConditionModifier();
        return result *= this.getTerrainModifier(direction);
    }

    protected double getSpeedLightConditionModifier() {
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        double result = surface.getSurfaceSunlight(this.getVehicle().getCoordinates());
        result = result * 0.7 + 0.3;
        return result;
    }

    protected double getTerrainModifier(Direction direction) {
        double tempAngle;
        GroundVehicle vehicle = (GroundVehicle)this.getVehicle();
        double handling = vehicle.getTerrainHandlingCapability();
        double angleModifier = handling + (double)this.getEffectiveSkillLevel() - 10.0;
        if (angleModifier < 0.0) {
            angleModifier = Math.abs(1.0 / angleModifier);
        }
        if ((tempAngle = Math.abs(vehicle.getTerrainGrade(direction) / angleModifier)) > 1.5707963267948966) {
            tempAngle = 1.5707963267948966;
        }
        return Math.cos(tempAngle);
    }

    @Override
    protected void checkForAccident(double time) {
        GroundVehicle vehicle = (GroundVehicle)this.getVehicle();
        double chance = 0.001;
        int skill = this.getEffectiveSkillLevel();
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (AVOID_OBSTACLE.equals(this.getPhase())) {
            chance *= 1.2;
        }
        if (WINCH_VEHICLE.equals(this.getPhase())) {
            chance *= 1.3;
        }
        chance *= 1.0 + Math.sin(vehicle.getTerrainGrade());
        chance /= 1.0 + vehicle.getTerrainHandlingCapability();
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        double lightConditions = surface.getSurfaceSunlight(vehicle.getCoordinates());
        chance *= 5.0 * (1.0 - lightConditions) + 1.0;
        if (RandomUtil.lessThanRandPercent((chance *= vehicle.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            vehicle.getMalfunctionManager().accident();
        }
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Driving");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Driving");
        return results;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 100.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        newPoints *= this.getTeachingExperienceModifier();
        double phaseModifier = 1.0;
        if (AVOID_OBSTACLE.equals(this.getPhase())) {
            phaseModifier = 4.0;
        }
        this.person.getMind().getSkillManager().addExperience("Driving", newPoints *= phaseModifier);
    }

    @Override
    public void endTask() {
        super.endTask();
    }
}

