/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.CookedMeal;
import org.mars_sim.msp.core.structure.building.function.Cooking;

class EatMeal
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(EatMeal.class.getName());
    private static final String EATING = "Eating";
    private static final double DURATION = 40.0;
    private static final double STRESS_MODIFIER = -0.2;
    private CookedMeal meal;

    public EatMeal(Person person) {
        super("Eating a meal", person, false, false, -0.2, true, 40.0);
        String location = person.getLocationSituation();
        if (location.equals("In Settlement")) {
            Cooking kitchen;
            Building diningBuilding = EatMeal.getAvailableDiningBuilding(person);
            if (diningBuilding != null) {
                BuildingManager.addPersonToBuilding(person, diningBuilding);
            }
            if ((kitchen = EatMeal.getKitchenWithFood(person)) != null) {
                this.meal = kitchen.getCookedMeal();
            }
            if (this.meal != null) {
                this.setDescription("Eating a cooked meal");
            }
        } else if (location.equals("Outside")) {
            this.endTask();
        }
        this.addPhase(EATING);
        this.setPhase(EATING);
    }

    public static double getProbability(Person person) {
        Building building;
        double result = person.getPhysicalCondition().getHunger() - 250.0;
        if (result < 0.0) {
            result = 0.0;
        }
        if (person.getLocationSituation().equals("Outside")) {
            result = 0.0;
        }
        if ((building = EatMeal.getAvailableDiningBuilding(person)) != null) {
            result *= Task.getCrowdingProbabilityModifier(person, building);
            result *= Task.getRelationshipModifier(person, building);
        }
        if (EatMeal.getKitchenWithFood(person) != null) {
            result *= 5.0;
        } else if (!EatMeal.isFoodAvailable(person)) {
            result = 0.0;
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (EATING.equals(this.getPhase())) {
            return this.eatingPhase(time);
        }
        return time;
    }

    private double eatingPhase(double time) {
        PhysicalCondition condition = this.person.getPhysicalCondition();
        if (this.meal != null) {
            double stress = condition.getStress();
            condition.setStress(stress - -0.2 * ((double)this.meal.getQuality() + 1.0));
        }
        if (this.getDuration() <= this.getTimeCompleted() + time) {
            PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
            try {
                this.person.consumeFood(config.getFoodConsumptionRate() * 0.3333333333333333, this.meal == null);
                condition.setHunger(0.0);
            }
            catch (Exception e) {
                this.endTask();
            }
        }
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
    }

    private static Building getAvailableDiningBuilding(Person person) {
        Building result = null;
        if (person.getLocationSituation().equals("In Settlement")) {
            Settlement settlement = person.getSettlement();
            BuildingManager manager = settlement.getBuildingManager();
            List<Building> diningBuildings = manager.getBuildings("Dining");
            diningBuildings = BuildingManager.getNonMalfunctioningBuildings(diningBuildings);
            if ((diningBuildings = BuildingManager.getLeastCrowdedBuildings(diningBuildings)).size() > 0) {
                Map<Building, Double> diningBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, diningBuildings);
                result = RandomUtil.getWeightedRandomObject(diningBuildingProbs);
            }
        }
        return result;
    }

    private static Cooking getKitchenWithFood(Person person) {
        Cooking result = null;
        if (person.getLocationSituation().equals("In Settlement")) {
            Settlement settlement = person.getSettlement();
            BuildingManager manager = settlement.getBuildingManager();
            List<Building> cookingBuildings = manager.getBuildings("Cooking");
            for (Building building : cookingBuildings) {
                Cooking kitchen = (Cooking)building.getFunction("Cooking");
                if (!kitchen.hasCookedMeal()) continue;
                result = kitchen;
            }
        }
        return result;
    }

    private static boolean isFoodAvailable(Person person) {
        boolean result = false;
        Unit containerUnit = person.getContainerUnit();
        if (containerUnit != null) {
            try {
                Inventory inv = containerUnit.getInventory();
                AmountResource food = AmountResource.findAmountResource("food");
                if (inv.getAmountResourceStored(food, false) > 0.0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        return 0;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(0);
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.meal = null;
    }
}

