/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Airlockable;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class EnterAirlock
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(EnterAirlock.class.getName());
    private static final String ENTERING_AIRLOCK = "Entering Airlock from Outside";
    private static final double STRESS_MODIFIER = 0.5;
    private Airlock airlock;

    public EnterAirlock(Person person, Airlock airlock) {
        super("Entering airlock from EVA", person, false, false, 0.5, false, 0.0);
        this.setDescription("Entering " + airlock.getEntityName() + " from EVA");
        this.airlock = airlock;
        this.addPhase(ENTERING_AIRLOCK);
        this.setPhase(ENTERING_AIRLOCK);
        this.movePersonOutsideAirlock();
        logger.fine(person.getName() + " is starting to enter " + airlock.getEntityName());
    }

    public EnterAirlock(Person person) {
        super("Entering airlock from EVA", person, false, false, 0.5, false, 0.0);
        Iterator<Unit> i;
        if (person.getMind().getMission() != null) {
            i = person.getMind().getMission().getPeople().iterator();
            while (i.hasNext() && this.airlock == null) {
                Vehicle vehicle;
                Person p = (Person)i.next();
                if (p == person) continue;
                String location = p.getLocationSituation();
                if (location.equals("In Settlement")) {
                    this.airlock = p.getSettlement().getAvailableAirlock();
                    continue;
                }
                if (!location.equals("In Vehicle") || !((vehicle = p.getVehicle()) instanceof Airlockable)) continue;
                this.airlock = ((Airlockable)((Object)vehicle)).getAirlock();
            }
        }
        if (this.airlock == null) {
            i = Simulation.instance().getUnitManager().getSettlements().iterator();
            while (i.hasNext() && this.airlock == null) {
                Settlement settlement = (Settlement)i.next();
                if (!person.getCoordinates().equals(settlement.getCoordinates())) continue;
                this.airlock = settlement.getAvailableAirlock();
            }
        }
        if (this.airlock == null) {
            i = Simulation.instance().getUnitManager().getVehicles().iterator();
            while (i.hasNext() && this.airlock == null) {
                Vehicle vehicle = (Vehicle)i.next();
                if (!person.getCoordinates().equals(vehicle.getCoordinates()) || !(vehicle instanceof Airlockable)) continue;
                this.airlock = ((Airlockable)((Object)vehicle)).getAirlock();
            }
        }
        this.addPhase(ENTERING_AIRLOCK);
        this.setPhase(ENTERING_AIRLOCK);
        if (this.airlock == null) {
            this.endTask();
            logger.severe(person.getName() + " cannot find an airlock to enter.");
        } else {
            this.movePersonOutsideAirlock();
            this.setDescription("Entering " + this.airlock.getEntityName() + " from EVA");
            logger.fine(person.getName() + " is starting to enter " + this.airlock.getEntityName());
        }
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("Outside")) {
            result = 1000.0;
        }
        return result;
    }

    private void movePersonOutsideAirlock() {
        if (this.airlock.getEntity() instanceof LocalBoundedObject) {
            LocalBoundedObject entityBounds = (LocalBoundedObject)this.airlock.getEntity();
            Point2D.Double newLocation = null;
            boolean goodLocation = false;
            for (int x = 0; x < 20 && !goodLocation; ++x) {
                Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomExteriorLocation(entityBounds, 1.0);
                newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), entityBounds);
                goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
            }
            this.person.setXLocation(newLocation.getX());
            this.person.setYLocation(newLocation.getY());
        }
    }

    private void movePersonInsideAirlock() {
        if (this.airlock.getEntity() instanceof LocalBoundedObject) {
            LocalBoundedObject entityBounds = (LocalBoundedObject)this.airlock.getEntity();
            Point2D.Double newLocation = null;
            boolean goodLocation = false;
            for (int x = 0; x < 20 && !goodLocation; ++x) {
                Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomInteriorLocation(entityBounds);
                newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), entityBounds);
                goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
            }
            this.person.setXLocation(newLocation.getX());
            this.person.setYLocation(newLocation.getY());
        }
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (ENTERING_AIRLOCK.equals(this.getPhase())) {
            return this.enteringAirlockPhase(time);
        }
        return time;
    }

    private double enteringAirlockPhase(double time) {
        double remainingTime = time;
        while ((this.person.getLocationSituation().equals("Outside") || this.airlock.inAirlock(this.person)) && remainingTime > 0.0) {
            if (!this.airlock.inAirlock(this.person)) {
                if ("depressurized".equals(this.airlock.getState()) && !this.airlock.isOuterDoorLocked()) {
                    this.airlock.enterAirlock(this.person, false);
                } else {
                    this.airlock.addAwaitingAirlockOuterDoor(this.person);
                }
                if (!this.airlock.isActivated()) {
                    this.airlock.activateAirlock(this.person);
                }
            }
            if (this.person.equals(this.airlock.getOperator())) {
                double activationTime = remainingTime;
                remainingTime = this.airlock.getRemainingCycleTime() < remainingTime ? (remainingTime -= this.airlock.getRemainingCycleTime()) : 0.0;
                boolean activationSuccessful = this.airlock.addCycleTime(activationTime);
                if (activationSuccessful) continue;
                logger.severe("Problem with airlock activation: " + this.person.getName());
                continue;
            }
            remainingTime = 0.0;
        }
        if (!this.person.getLocationSituation().equals("Outside") && !this.airlock.inAirlock(this.person)) {
            logger.fine(this.person.getName() + " successfully entered airlock of " + this.airlock.getEntityName());
            this.movePersonInsideAirlock();
            this.putAwayEVASuit();
            this.endTask();
        }
        this.addExperience(time - remainingTime);
        return remainingTime;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
    }

    private void putAwayEVASuit() {
        EVASuit suit = (EVASuit)this.person.getInventory().findUnitOfClass(EVASuit.class);
        if (suit != null) {
            double oxygenCapacity;
            Inventory suitInv = suit.getInventory();
            Inventory personInv = this.person.getInventory();
            Inventory entityInv = this.person.getContainerUnit().getInventory();
            AmountResource oxygen = AmountResource.findAmountResource("oxygen");
            double oxygenAmount = suitInv.getAmountResourceStored(oxygen, false);
            if (oxygenAmount > (oxygenCapacity = entityInv.getAmountResourceRemainingCapacity(oxygen, true, false))) {
                oxygenAmount = oxygenCapacity;
            }
            try {
                suitInv.retrieveAmountResource(oxygen, oxygenAmount);
                entityInv.storeAmountResource(oxygen, oxygenAmount, true);
            }
            catch (Exception e) {
                // empty catch block
            }
            AmountResource water = AmountResource.findAmountResource("water");
            double waterAmount = suitInv.getAmountResourceStored(water, false);
            double waterCapacity = entityInv.getAmountResourceRemainingCapacity(water, true, false);
            if (waterAmount > waterCapacity) {
                waterAmount = waterCapacity;
            }
            try {
                suitInv.retrieveAmountResource(water, waterAmount);
                entityInv.storeAmountResource(water, waterAmount, true);
            }
            catch (Exception e) {
                // empty catch block
            }
            personInv.retrieveUnit(suit);
            entityInv.storeUnit(suit);
        } else {
            logger.severe(this.person.getName() + " doesn't have an EVA suit to put away.");
        }
    }

    public static boolean canEnterAirlock(Person person, Airlock airlock) {
        return true;
    }

    @Override
    public void endTask() {
        super.endTask();
        if (this.airlock != null && this.person.equals(this.airlock.getOperator())) {
            logger.severe(this.person + " ending entering airlock task prematurely, " + "clearing as airlock operator for " + this.airlock.getEntityName());
            this.airlock.clearOperator();
        }
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("EVA Operations");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("EVA Operations");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.airlock = null;
    }
}

