/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;

public class ExitAirlock
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(ExitAirlock.class.getName());
    private static final String EXITING_AIRLOCK = "Exiting Airlock from Inside";
    private static final double STRESS_MODIFIER = 0.5;
    private Airlock airlock;
    private boolean hasSuit = false;

    public ExitAirlock(Person person, Airlock airlock) {
        super("Exiting airlock for EVA", person, true, false, 0.5, false, 0.0);
        this.setDescription("Exiting " + airlock.getEntityName() + " for EVA");
        this.airlock = airlock;
        this.addPhase(EXITING_AIRLOCK);
        this.setPhase(EXITING_AIRLOCK);
        this.movePersonInsideAirlock();
        logger.fine(person.getName() + " is starting to exit airlock of " + airlock.getEntityName());
    }

    private void movePersonOutsideAirlock() {
        if (this.airlock.getEntity() instanceof LocalBoundedObject) {
            LocalBoundedObject entityBounds = (LocalBoundedObject)this.airlock.getEntity();
            Point2D.Double newLocation = null;
            boolean goodLocation = false;
            for (int x = 0; x < 20 && !goodLocation; ++x) {
                Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomExteriorLocation(entityBounds, 1.0);
                newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), entityBounds);
                goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
            }
            this.person.setXLocation(newLocation.getX());
            this.person.setYLocation(newLocation.getY());
        }
    }

    private void movePersonInsideAirlock() {
        if (this.airlock.getEntity() instanceof LocalBoundedObject) {
            LocalBoundedObject entityBounds = (LocalBoundedObject)this.airlock.getEntity();
            Point2D.Double newLocation = null;
            boolean goodLocation = false;
            for (int x = 0; x < 20 && !goodLocation; ++x) {
                Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomInteriorLocation(entityBounds);
                newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), entityBounds);
                goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
            }
            this.person.setXLocation(newLocation.getX());
            this.person.setYLocation(newLocation.getY());
        }
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (EXITING_AIRLOCK.equals(this.getPhase())) {
            return this.exitingAirlockPhase(time);
        }
        return time;
    }

    private double exitingAirlockPhase(double time) {
        Inventory inv;
        EVASuit suit;
        double remainingTime = time;
        if (!this.hasSuit && this.alreadyHasEVASuit()) {
            this.hasSuit = true;
        }
        if (!this.hasSuit && (suit = ExitAirlock.getGoodEVASuit(inv = this.airlock.getEntityInventory())) != null) {
            try {
                inv.retrieveUnit(suit);
                this.person.getInventory().storeUnit(suit);
                this.loadEVASuit(suit);
                this.hasSuit = true;
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
            }
        }
        if (!this.hasSuit) {
            logger.info(this.person.getName() + " does not have an EVA suit, ExitAirlock ended");
            this.endTask();
            return 0.0;
        }
        while (!this.person.getLocationSituation().equals("Outside") && remainingTime > 0.0) {
            if (!this.airlock.inAirlock(this.person)) {
                if ("pressurized".equals(this.airlock.getState()) && !this.airlock.isInnerDoorLocked()) {
                    this.airlock.enterAirlock(this.person, true);
                } else {
                    this.airlock.addAwaitingAirlockInnerDoor(this.person);
                }
                if (!this.airlock.isActivated()) {
                    this.airlock.activateAirlock(this.person);
                }
            }
            if (this.person.equals(this.airlock.getOperator())) {
                double activationTime = remainingTime;
                remainingTime = this.airlock.getRemainingCycleTime() < remainingTime ? (remainingTime -= this.airlock.getRemainingCycleTime()) : 0.0;
                boolean activationSuccessful = this.airlock.addCycleTime(activationTime);
                if (activationSuccessful) continue;
                logger.severe("Problem with airlock activation: " + this.person.getName());
                continue;
            }
            remainingTime = 0.0;
        }
        if (this.person.getLocationSituation().equals("Outside")) {
            logger.fine(this.person.getName() + " successfully exited airlock of " + this.airlock.getEntityName());
            this.movePersonOutsideAirlock();
            this.endTask();
        }
        this.addExperience(time - remainingTime);
        return remainingTime;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
    }

    public static boolean canExitAirlock(Person person, Airlock airlock) {
        boolean result = true;
        if (!ExitAirlock.goodEVASuitAvailable(airlock.getEntityInventory())) {
            result = false;
        }
        if (person.getPerformanceRating() == 0.0) {
            result = false;
        }
        return result;
    }

    private boolean alreadyHasEVASuit() {
        boolean result = false;
        EVASuit suit = (EVASuit)this.person.getInventory().findUnitOfClass(EVASuit.class);
        if (suit != null) {
            result = true;
            logger.severe(this.person.getName() + " already has an EVA suit in inventory!");
        }
        return result;
    }

    public static boolean goodEVASuitAvailable(Inventory inv) {
        return ExitAirlock.getGoodEVASuit(inv) != null;
    }

    public static EVASuit getGoodEVASuit(Inventory inv) {
        EVASuit result = null;
        Iterator<Unit> i = inv.findAllUnitsOfClass(EVASuit.class).iterator();
        while (i.hasNext() && result == null) {
            EVASuit suit = (EVASuit)i.next();
            boolean malfunction = suit.getMalfunctionManager().hasMalfunction();
            try {
                boolean hasEnoughResources = ExitAirlock.hasEnoughResourcesForSuit(inv, suit);
                if (malfunction || !hasEnoughResources) continue;
                result = suit;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    private static boolean hasEnoughResourcesForSuit(Inventory entityInv, EVASuit suit) {
        Inventory suitInv = suit.getInventory();
        int otherPeopleNum = entityInv.findNumUnitsOfClass(Person.class) - 1;
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double neededOxygen = suitInv.getAmountResourceRemainingCapacity(oxygen, true, false);
        double availableOxygen = entityInv.getAmountResourceStored(oxygen, false);
        boolean hasEnoughOxygen = (availableOxygen -= neededOxygen * (double)otherPeopleNum) >= neededOxygen;
        AmountResource water = AmountResource.findAmountResource("water");
        double neededWater = suitInv.getAmountResourceRemainingCapacity(water, true, false);
        double availableWater = entityInv.getAmountResourceStored(water, false);
        boolean hasEnoughWater = (availableWater -= neededWater * (double)otherPeopleNum) >= neededWater;
        return hasEnoughOxygen && hasEnoughWater;
    }

    private void loadEVASuit(EVASuit suit) {
        double availableOxygen;
        Inventory suitInv = suit.getInventory();
        Inventory entityInv = this.person.getContainerUnit().getInventory();
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double neededOxygen = suitInv.getAmountResourceRemainingCapacity(oxygen, true, false);
        double takenOxygen = neededOxygen;
        if (takenOxygen > (availableOxygen = entityInv.getAmountResourceStored(oxygen, false))) {
            takenOxygen = availableOxygen;
        }
        try {
            entityInv.retrieveAmountResource(oxygen, takenOxygen);
            suitInv.storeAmountResource(oxygen, takenOxygen, true);
        }
        catch (Exception e) {
            // empty catch block
        }
        AmountResource water = AmountResource.findAmountResource("water");
        double neededWater = suitInv.getAmountResourceRemainingCapacity(water, true, false);
        double availableWater = entityInv.getAmountResourceStored(water, false);
        double takenWater = neededWater;
        if (takenWater > availableWater) {
            takenWater = availableWater;
        }
        try {
            entityInv.retrieveAmountResource(water, takenWater);
            suitInv.storeAmountResource(water, takenWater, true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void endTask() {
        super.endTask();
        if (this.airlock != null && this.person.equals(this.airlock.getOperator())) {
            logger.severe(this.person + " ending exiting airlock task prematurely, " + "clearing as airlock operator for " + this.airlock.getEntityName());
            this.airlock.clearOperator();
        }
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("EVA Operations");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("EVA Operations");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.airlock = null;
    }
}

