/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.SpecimenContainer;
import org.mars_sim.msp.core.mars.ExploredLocation;
import org.mars_sim.msp.core.mars.MineralMap;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.vehicle.Rover;

public class ExploreSite
extends EVAOperation
implements Serializable {
    private static final String EXPLORING = "Exploring";
    private static final double AVERAGE_ROCK_SAMPLES_COLLECTED_SITE = 10.0;
    public static final double AVERAGE_ROCK_SAMPLE_MASS = 0.5;
    private static final double ESTIMATE_IMPROVEMENT_FACTOR = 5.0;
    private ExploredLocation site;
    private Rover rover;

    public ExploreSite(Person person, ExploredLocation site, Rover rover) {
        super("Explore Site", person);
        this.site = site;
        this.rover = rover;
        this.addPhase(EXPLORING);
    }

    public static boolean canExploreSite(Person person, Rover rover) {
        boolean exitable = ExitAirlock.canExitAirlock(person, rover.getAirlock());
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        boolean sunlight = surface.getSurfaceSunlight(rover.getCoordinates()) > 0.0;
        boolean darkRegion = surface.inDarkPolarRegion(rover.getCoordinates());
        boolean medical = person.getPerformanceRating() < 0.5;
        return exitable && (sunlight || darkRegion) && !medical;
    }

    private double exitRover(double time) {
        try {
            time = this.exitAirlock(time, this.rover.getAirlock());
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            if (!this.hasSpecimenContainer()) {
                this.takeContainer();
            }
            this.setPhase(EXPLORING);
        }
        return time;
    }

    private double enterRover(double time) {
        time = this.enterAirlock(time, this.rover.getAirlock());
        this.addExperience(time);
        if (this.enteredAirlock) {
            Inventory pInv = this.person.getInventory();
            if (pInv.containsUnitClass(SpecimenContainer.class)) {
                Unit container = pInv.findUnitOfClass(SpecimenContainer.class);
                pInv.retrieveUnit(container);
                this.rover.getInventory().storeUnit(container);
            } else {
                this.endTask();
                return time;
            }
        }
        return 0.0;
    }

    private double exploringPhase(double time) {
        this.checkForAccident(time);
        if (this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        this.collectRockSamples(time);
        this.improveMineralConcentrationEstimates(time);
        this.addExperience(time);
        return 0.0;
    }

    private void collectRockSamples(double time) {
        if (this.hasSpecimenContainer()) {
            double numSamplesCollected = 20.0;
            double probability = time / 1000.0 * numSamplesCollected;
            if (RandomUtil.getRandomDouble(1.0) <= probability) {
                AmountResource rockSamples;
                double rockSampleCapacity;
                Inventory inv = this.person.getInventory();
                double rockSampleMass = RandomUtil.getRandomDouble(1.0);
                if (rockSampleMass < (rockSampleCapacity = inv.getAmountResourceRemainingCapacity(rockSamples = AmountResource.findAmountResource("rock samples"), true, false))) {
                    inv.storeAmountResource(rockSamples, rockSampleMass, true);
                }
            }
        }
    }

    private void improveMineralConcentrationEstimates(double time) {
        double probability = time / 1000.0 * (double)this.getEffectiveSkillLevel() * 5.0;
        if (RandomUtil.getRandomDouble(1.0) <= probability) {
            MineralMap mineralMap = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap();
            Map<String, Double> estimatedMineralConcentrations = this.site.getEstimatedMineralConcentrations();
            for (String mineralType : estimatedMineralConcentrations.keySet()) {
                double actualConcentration = mineralMap.getMineralConcentration(mineralType, this.site.getLocation());
                double estimatedConcentration = estimatedMineralConcentrations.get(mineralType);
                double estimationDiff = Math.abs(actualConcentration - estimatedConcentration);
                double estimationImprovement = RandomUtil.getRandomDouble(1.0 * (double)this.getEffectiveSkillLevel());
                if (estimationImprovement > estimationDiff) {
                    estimationImprovement = estimationDiff;
                }
                estimatedConcentration = estimatedConcentration < actualConcentration ? (estimatedConcentration += estimationImprovement) : (estimatedConcentration -= estimationImprovement);
                estimatedMineralConcentrations.put(mineralType, estimatedConcentration);
            }
        }
    }

    private boolean hasSpecimenContainer() {
        return this.person.getInventory().containsUnitClass(SpecimenContainer.class);
    }

    private void takeContainer() {
        SpecimenContainer container = ExploreSite.findLeastFullContainer(this.rover);
        if (container != null && this.person.getInventory().canStoreUnit(container, false)) {
            this.rover.getInventory().retrieveUnit(container);
            this.person.getInventory().storeUnit(container);
        }
    }

    private static SpecimenContainer findLeastFullContainer(Rover rover) {
        SpecimenContainer result = null;
        double mostCapacity = 0.0;
        for (SpecimenContainer specimenContainer : rover.getInventory().findAllUnitsOfClass(SpecimenContainer.class)) {
            try {
                AmountResource rockSamples = AmountResource.findAmountResource("rock samples");
                double remainingCapacity = specimenContainer.getInventory().getAmountResourceRemainingCapacity(rockSamples, false, false);
                if (!(remainingCapacity > mostCapacity)) continue;
                result = specimenContainer;
                mostCapacity = remainingCapacity;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (EXPLORING.equals(this.getPhase())) {
            double areologyExperience = time / 10.0;
            areologyExperience += areologyExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Areology", areologyExperience);
        }
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add("Areology");
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int areologySkill = manager.getEffectiveSkillLevel("Areology");
        return (int)Math.round((double)(EVAOperationsSkill + areologySkill) / 2.0);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitRover(time);
        }
        if (EXPLORING.equals(this.getPhase())) {
            return this.exploringPhase(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterRover(time);
        }
        return time;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.site = null;
        this.rover = null;
    }
}

