/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class LoadVehicleGarage
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(LoadVehicleGarage.class.getName());
    private static final double SMALL_AMOUNT_COMPARISON = 1.0E-7;
    private static final String LOADING = "Loading";
    private static final double STRESS_MODIFIER = 0.1;
    private static double LOAD_RATE = 20.0;
    private static double DURATION = 100.0;
    private Vehicle vehicle;
    private Settlement settlement;
    private Map<Resource, Number> requiredResources;
    private Map<Resource, Number> optionalResources;
    private Map<Class, Integer> requiredEquipment;
    private Map<Class, Integer> optionalEquipment;

    public LoadVehicleGarage(Person person) {
        super("Loading vehicle", person, true, false, 0.1, true, DURATION);
        VehicleMission mission = this.getMissionNeedingLoading();
        if (mission != null) {
            Building garageBuilding;
            this.vehicle = mission.getVehicle();
            this.setDescription("Loading " + this.vehicle.getName());
            this.requiredResources = mission.getRequiredResourcesToLoad();
            this.optionalResources = mission.getOptionalResourcesToLoad();
            this.requiredEquipment = mission.getRequiredEquipmentToLoad();
            this.optionalEquipment = mission.getOptionalEquipmentToLoad();
            this.settlement = person.getSettlement();
            if (this.settlement == null) {
                this.endTask();
            }
            if ((garageBuilding = BuildingManager.getBuilding(this.vehicle)) != null) {
                BuildingManager.addPersonToBuilding(person, garageBuilding);
            }
            if (this.vehicle == null || garageBuilding == null) {
                this.endTask();
            }
            this.addPhase(LOADING);
            this.setPhase(LOADING);
        } else {
            this.endTask();
        }
    }

    public LoadVehicleGarage(Person person, Vehicle vehicle, Map<Resource, Number> requiredResources, Map<Resource, Number> optionalResources, Map<Class, Integer> requiredEquipment, Map<Class, Integer> optionalEquipment) {
        super("Loading vehicle", person, true, false, 0.1, true, DURATION);
        this.setDescription("Loading " + vehicle.getName());
        this.vehicle = vehicle;
        if (requiredResources != null) {
            this.requiredResources = new HashMap<Resource, Number>(requiredResources);
        }
        if (optionalResources != null) {
            this.optionalResources = new HashMap<Resource, Number>(optionalResources);
        }
        if (requiredEquipment != null) {
            this.requiredEquipment = new HashMap<Class, Integer>(requiredEquipment);
        }
        if (optionalEquipment != null) {
            this.optionalEquipment = new HashMap<Class, Integer>(optionalEquipment);
        }
        this.settlement = person.getSettlement();
        Building garage = BuildingManager.getBuilding(vehicle);
        if (garage != null) {
            BuildingManager.addPersonToBuilding(person, garage);
        }
        this.addPhase(LOADING);
        this.setPhase(LOADING);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            try {
                List<Mission> missions = LoadVehicleGarage.getAllMissionsNeedingLoading(person.getSettlement());
                result = 50.0 * (double)missions.size();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error finding loading missions.", e);
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(LoadVehicleGarage.class);
        }
        return result;
    }

    private static List<Mission> getAllMissionsNeedingLoading(Settlement settlement) {
        ArrayList<Mission> result = new ArrayList<Mission>();
        MissionManager manager = Simulation.instance().getMissionManager();
        for (Mission mission : manager.getMissions()) {
            Vehicle vehicle;
            VehicleMission vehicleMission;
            if (!(mission instanceof VehicleMission) || !"Embarking".equals(mission.getPhase()) || !(vehicleMission = (VehicleMission)mission).hasVehicle() || settlement != (vehicle = vehicleMission.getVehicle()).getSettlement() || vehicleMission.isVehicleLoaded() || BuildingManager.getBuilding(vehicle) == null) continue;
            result.add(vehicleMission);
        }
        return result;
    }

    private VehicleMission getMissionNeedingLoading() {
        VehicleMission result = null;
        List<Mission> loadingMissions = LoadVehicleGarage.getAllMissionsNeedingLoading(this.person.getSettlement());
        if (loadingMissions.size() > 0) {
            int index = RandomUtil.getRandomInt(loadingMissions.size() - 1);
            result = (VehicleMission)loadingMissions.get(index);
        }
        return result;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (LOADING.equals(this.getPhase())) {
            return this.loadingPhase(time);
        }
        return time;
    }

    double loadingPhase(double time) {
        if (this.settlement == null) {
            this.endTask();
            return 0.0;
        }
        int strength = this.person.getNaturalAttributeManager().getAttribute("Strength");
        double strengthModifier = 0.1 + (double)strength * 0.018;
        double amountLoading = LOAD_RATE * strengthModifier * time;
        Inventory sInv = this.settlement.getInventory();
        boolean roverInSettlement = false;
        if (sInv.containsUnit(this.vehicle)) {
            roverInSettlement = true;
            sInv.retrieveUnit(this.vehicle);
        }
        if (amountLoading > 0.0) {
            amountLoading = this.loadEquipment(amountLoading);
        }
        try {
            amountLoading = this.loadResources(amountLoading);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
        if (roverInSettlement) {
            sInv.storeUnit(this.vehicle);
        }
        if (LoadVehicleGarage.isFullyLoaded(this.requiredResources, this.optionalResources, this.requiredEquipment, this.optionalEquipment, this.vehicle, this.settlement)) {
            this.endTask();
        }
        return 0.0;
    }

    private double loadResources(double amountLoading) {
        Iterator<Resource> iR = this.requiredResources.keySet().iterator();
        while (iR.hasNext() && amountLoading > 0.0) {
            Resource resource = iR.next();
            if (resource instanceof AmountResource) {
                amountLoading = this.loadAmountResource(amountLoading, (AmountResource)resource, true);
                continue;
            }
            if (!(resource instanceof ItemResource)) continue;
            amountLoading = this.loadItemResource(amountLoading, (ItemResource)resource, true);
        }
        Iterator<Resource> iR2 = this.optionalResources.keySet().iterator();
        while (iR2.hasNext() && amountLoading > 0.0) {
            Resource resource = iR2.next();
            if (resource instanceof AmountResource) {
                amountLoading = this.loadAmountResource(amountLoading, (AmountResource)resource, false);
                continue;
            }
            if (!(resource instanceof ItemResource)) continue;
            amountLoading = this.loadItemResource(amountLoading, (ItemResource)resource, false);
        }
        return amountLoading;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double loadAmountResource(double amountLoading, AmountResource resource, boolean required) {
        Inventory vInv = this.vehicle.getInventory();
        Inventory sInv = this.settlement.getInventory();
        double amountNeededTotal = 0.0;
        if (required) {
            amountNeededTotal = (Double)this.requiredResources.get(resource);
        } else {
            if (this.requiredResources.containsKey(resource)) {
                amountNeededTotal += ((Double)this.requiredResources.get(resource)).doubleValue();
            }
            amountNeededTotal += ((Double)this.optionalResources.get(resource)).doubleValue();
        }
        double amountAlreadyLoaded = vInv.getAmountResourceStored(resource, false);
        if (amountAlreadyLoaded < amountNeededTotal) {
            double remainingCapacity;
            double amountNeeded = amountNeededTotal - amountAlreadyLoaded;
            boolean canLoad = true;
            String loadingError = "";
            double settlementStored = sInv.getAmountResourceStored(resource, false);
            if (settlementStored < amountNeeded) {
                if (required) {
                    canLoad = false;
                    loadingError = "Not enough resource stored at settlement to load resource: " + resource + " needed: " + amountNeeded + ", stored: " + settlementStored;
                } else {
                    amountNeeded = settlementStored;
                }
            }
            if ((remainingCapacity = vInv.getAmountResourceRemainingCapacity(resource, true, false)) < amountNeeded) {
                if (required) {
                    if (amountNeeded - remainingCapacity < 1.0E-5) {
                        amountNeeded = remainingCapacity;
                    } else {
                        canLoad = false;
                        loadingError = "Not enough capacity in vehicle for loading resource " + resource + ": " + amountNeeded + ", remaining capacity: " + remainingCapacity;
                    }
                } else {
                    amountNeeded = remainingCapacity;
                }
            }
            double resourceAmount = amountNeeded;
            if (amountNeeded > amountLoading) {
                resourceAmount = amountLoading;
            }
            if (canLoad) {
                try {
                    sInv.retrieveAmountResource(resource, resourceAmount);
                    vInv.storeAmountResource(resource, resourceAmount, true);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                amountLoading -= resourceAmount;
                return amountLoading;
            }
            this.endTask();
            throw new IllegalStateException(loadingError);
        }
        if (required && this.optionalResources.containsKey(resource)) {
            amountNeededTotal += ((Double)this.optionalResources.get(resource)).doubleValue();
        }
        if (!(amountAlreadyLoaded > amountNeededTotal)) return amountLoading;
        double amountToRemove = amountAlreadyLoaded - amountNeededTotal;
        try {
            vInv.retrieveAmountResource(resource, amountToRemove);
            sInv.storeAmountResource(resource, amountToRemove, true);
            return amountLoading;
        }
        catch (Exception e) {
            // empty catch block
        }
        return amountLoading;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double loadItemResource(double amountLoading, ItemResource resource, boolean required) {
        Inventory vInv = this.vehicle.getInventory();
        Inventory sInv = this.settlement.getInventory();
        int numNeededTotal = 0;
        if (required) {
            numNeededTotal = (Integer)this.requiredResources.get(resource);
        } else {
            if (this.requiredResources.containsKey(resource)) {
                numNeededTotal += ((Integer)this.requiredResources.get(resource)).intValue();
            }
            numNeededTotal += ((Integer)this.optionalResources.get(resource)).intValue();
        }
        int numAlreadyLoaded = vInv.getItemResourceNum(resource);
        if (numAlreadyLoaded < numNeededTotal) {
            int resourceNum;
            double remainingMassCapacity;
            int numNeeded = numNeededTotal - numAlreadyLoaded;
            boolean canLoad = true;
            String loadingError = "";
            int settlementStored = sInv.getItemResourceNum(resource);
            if (settlementStored < numNeeded) {
                if (required) {
                    canLoad = false;
                    loadingError = "Not enough resource stored at settlement to load resource: " + resource + " needed: " + numNeeded + ", stored: " + settlementStored;
                } else {
                    numNeeded = settlementStored;
                }
            }
            if ((remainingMassCapacity = vInv.getRemainingGeneralCapacity(false)) < (double)numNeeded * resource.getMassPerItem()) {
                if (required) {
                    canLoad = false;
                    loadingError = "Not enough capacity in vehicle for loading resource " + resource + ": " + numNeeded + ", remaining capacity: " + remainingMassCapacity + " kg";
                } else {
                    numNeeded = (int)(remainingMassCapacity / resource.getMassPerItem());
                }
            }
            if ((resourceNum = (int)(amountLoading / resource.getMassPerItem())) < 1) {
                resourceNum = 1;
            }
            if (resourceNum > numNeeded) {
                resourceNum = numNeeded;
            }
            if (canLoad) {
                sInv.retrieveItemResources(resource, resourceNum);
                vInv.storeItemResources(resource, resourceNum);
                amountLoading -= (double)resourceNum * resource.getMassPerItem();
                if (!(amountLoading < 0.0)) return amountLoading;
                return 0.0;
            }
            this.endTask();
            throw new IllegalStateException(loadingError);
        }
        if (required && this.optionalResources.containsKey(resource)) {
            numNeededTotal += ((Integer)this.optionalResources.get(resource)).intValue();
        }
        if (numAlreadyLoaded <= numNeededTotal) return amountLoading;
        int numToRemove = numAlreadyLoaded - numNeededTotal;
        try {
            vInv.retrieveItemResources(resource, numToRemove);
            sInv.storeItemResources(resource, numToRemove);
            return amountLoading;
        }
        catch (Exception e) {
            // empty catch block
        }
        return amountLoading;
    }

    private double loadEquipment(double amountLoading) {
        amountLoading = this.loadRequiredEquipment(amountLoading);
        amountLoading = this.loadOptionalEquipment(amountLoading);
        return amountLoading;
    }

    private double loadRequiredEquipment(double amountLoading) {
        Inventory vInv = this.vehicle.getInventory();
        Inventory sInv = this.settlement.getInventory();
        Iterator<Class> iE = this.requiredEquipment.keySet().iterator();
        while (iE.hasNext() && amountLoading > 0.0) {
            Object[] array;
            Collection<Unit> units;
            Class equipmentType = iE.next();
            int numNeededTotal = this.requiredEquipment.get(equipmentType);
            int numAlreadyLoaded = vInv.findNumUnitsOfClass(equipmentType);
            if (numAlreadyLoaded < numNeededTotal) {
                int numNeeded = numNeededTotal - numAlreadyLoaded;
                units = sInv.findAllUnitsOfClass(equipmentType);
                array = units.toArray();
                if (units.size() >= numNeeded) {
                    int loaded = 0;
                    for (int x = 0; x < units.size() && loaded < numNeeded && amountLoading > 0.0; ++x) {
                        Equipment eq = (Equipment)array[x];
                        boolean isEmpty = true;
                        Inventory eInv = eq.getInventory();
                        if (eInv != null) {
                            isEmpty = eq.getInventory().isEmpty(false);
                        }
                        if (!isEmpty) continue;
                        if (vInv.canStoreUnit(eq, false)) {
                            sInv.retrieveUnit(eq);
                            vInv.storeUnit(eq);
                            amountLoading -= eq.getMass();
                            if (amountLoading < 0.0) {
                                amountLoading = 0.0;
                            }
                            ++loaded;
                            continue;
                        }
                        logger.warning(this.vehicle + " cannot store " + eq);
                        this.endTask();
                    }
                    array = null;
                    continue;
                }
                this.endTask();
                continue;
            }
            if (this.optionalEquipment.containsKey(equipmentType)) {
                numNeededTotal += this.optionalEquipment.get(equipmentType).intValue();
            }
            if (numAlreadyLoaded <= numNeededTotal) continue;
            int numToRemove = numAlreadyLoaded - numNeededTotal;
            units = vInv.findAllUnitsOfClass(equipmentType);
            array = units.toArray();
            for (int x = 0; x < numToRemove; ++x) {
                Equipment eq = (Equipment)array[x];
                vInv.retrieveUnit(eq);
                sInv.storeUnit(eq);
            }
            array = null;
        }
        return amountLoading;
    }

    private double loadOptionalEquipment(double amountLoading) {
        Inventory vInv = this.vehicle.getInventory();
        Inventory sInv = this.settlement.getInventory();
        Iterator<Class> iE = this.optionalEquipment.keySet().iterator();
        while (iE.hasNext() && amountLoading > 0.0) {
            Object[] array;
            Collection<Unit> units;
            int numAlreadyLoaded;
            Class equipmentType = iE.next();
            int numNeededTotal = this.optionalEquipment.get(equipmentType);
            if (this.requiredEquipment.containsKey(equipmentType)) {
                numNeededTotal += this.requiredEquipment.get(equipmentType).intValue();
            }
            if ((numAlreadyLoaded = vInv.findNumUnitsOfClass(equipmentType)) < numNeededTotal) {
                int numNeeded = numNeededTotal - numAlreadyLoaded;
                units = sInv.findAllUnitsOfClass(equipmentType);
                array = units.toArray();
                if (units.size() < numNeeded) {
                    numNeeded = units.size();
                }
                int loaded = 0;
                for (int x = 0; x < units.size() && loaded < numNeeded && amountLoading > 0.0; ++x) {
                    Equipment eq = (Equipment)array[x];
                    boolean isEmpty = true;
                    Inventory eInv = eq.getInventory();
                    if (eInv != null) {
                        isEmpty = eq.getInventory().isEmpty(false);
                    }
                    if (!isEmpty) continue;
                    if (vInv.canStoreUnit(eq, false)) {
                        sInv.retrieveUnit(eq);
                        vInv.storeUnit(eq);
                        amountLoading -= eq.getMass();
                        if (amountLoading < 0.0) {
                            amountLoading = 0.0;
                        }
                        ++loaded;
                        continue;
                    }
                    logger.warning(this.vehicle + " cannot store " + eq);
                    this.endTask();
                }
                array = null;
                continue;
            }
            if (numAlreadyLoaded <= numNeededTotal) continue;
            int numToRemove = numAlreadyLoaded - numNeededTotal;
            units = vInv.findAllUnitsOfClass(equipmentType);
            array = units.toArray();
            for (int x = 0; x < numToRemove; ++x) {
                Equipment eq = (Equipment)array[x];
                vInv.retrieveUnit(eq);
                sInv.storeUnit(eq);
            }
            array = null;
        }
        return amountLoading;
    }

    @Override
    protected void addExperience(double time) {
    }

    public static boolean hasEnoughSupplies(Settlement settlement, Vehicle vehicle, Map<Resource, Number> resources, Map<Class, Integer> equipment, int vehicleCrewNum, double tripTime) {
        if (settlement == null) {
            throw new IllegalArgumentException("settlement is null");
        }
        boolean enoughSupplies = true;
        Inventory inv = settlement.getInventory();
        Inventory vInv = vehicle.getInventory();
        boolean roverInSettlement = false;
        if (inv.containsUnit(vehicle)) {
            roverInSettlement = true;
            inv.retrieveUnit(vehicle);
        }
        for (Resource resource : resources.keySet()) {
            if (resource instanceof AmountResource) {
                double amountNeeded = (Double)resources.get(resource);
                double remainingSettlementAmount = LoadVehicleGarage.getRemainingSettlementAmount(settlement, vehicleCrewNum, (AmountResource)resource, tripTime);
                double amountLoaded = vInv.getAmountResourceStored((AmountResource)resource, false);
                double totalNeeded = amountNeeded + remainingSettlementAmount - amountLoaded;
                if (!(inv.getAmountResourceStored((AmountResource)resource, false) < totalNeeded)) continue;
                double stored = inv.getAmountResourceStored((AmountResource)resource, false);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(resource.getName() + " needed: " + totalNeeded + " stored: " + stored);
                }
                enoughSupplies = false;
                continue;
            }
            if (resource instanceof ItemResource) {
                int numNeeded = (Integer)resources.get(resource);
                int remainingSettlementNum = LoadVehicleGarage.getRemainingSettlementNum(settlement, vehicleCrewNum, (ItemResource)resource);
                int numLoaded = vInv.getItemResourceNum((ItemResource)resource);
                int totalNeeded = numNeeded + remainingSettlementNum - numLoaded;
                if (inv.getItemResourceNum((ItemResource)resource) >= totalNeeded) continue;
                int stored = inv.getItemResourceNum((ItemResource)resource);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(resource.getName() + " needed: " + totalNeeded + " stored: " + stored);
                }
                enoughSupplies = false;
                continue;
            }
            throw new IllegalStateException("Unknown resource type: " + resource);
        }
        for (Class equipmentType : equipment.keySet()) {
            int numNeeded = equipment.get(equipmentType);
            int remainingSettlementNum = LoadVehicleGarage.getRemainingSettlementNum(settlement, vehicleCrewNum, equipmentType);
            int numLoaded = vInv.findNumUnitsOfClass(equipmentType);
            int totalNeeded = numNeeded + remainingSettlementNum - numLoaded;
            if (inv.findNumEmptyUnitsOfClass(equipmentType, false) >= totalNeeded) continue;
            int stored = inv.findNumEmptyUnitsOfClass(equipmentType, false);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(equipmentType + " needed: " + totalNeeded + " stored: " + stored);
            }
            enoughSupplies = false;
        }
        if (roverInSettlement) {
            inv.storeUnit(vehicle);
        }
        return enoughSupplies;
    }

    private static double getRemainingSettlementAmount(Settlement settlement, int vehicleCrewNum, AmountResource resource, double tripTime) {
        int remainingPeopleNum = settlement.getCurrentPopulationNum() - vehicleCrewNum;
        double amountPersonPerSol = 0.0;
        double tripTimeSols = tripTime / 1000.0;
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        AmountResource water = AmountResource.findAmountResource("water");
        AmountResource food = AmountResource.findAmountResource("food");
        if (resource.equals(oxygen)) {
            amountPersonPerSol = PhysicalCondition.getOxygenConsumptionRate();
        } else if (resource.equals(water)) {
            amountPersonPerSol = PhysicalCondition.getWaterConsumptionRate();
        } else if (resource.equals(food)) {
            amountPersonPerSol = PhysicalCondition.getFoodConsumptionRate();
        }
        return (double)remainingPeopleNum * (amountPersonPerSol * tripTimeSols);
    }

    private static int getRemainingSettlementNum(Settlement settlement, int vehicleCrewNum, ItemResource resource) {
        return 0;
    }

    private static int getRemainingSettlementNum(Settlement settlement, int vehicleCrewNum, Class equipmentType) {
        int remainingPeopleNum = settlement.getCurrentPopulationNum() - vehicleCrewNum;
        if (equipmentType == EVASuit.class) {
            int minSuits = remainingPeopleNum / 4;
            if (minSuits == 0) {
                minSuits = 1;
            }
            return minSuits;
        }
        return 0;
    }

    public static boolean enoughCapacityForSupplies(Map<Resource, Number> resources, Map<Class, Integer> equipment, Vehicle vehicle, Settlement settlement) {
        boolean sufficientCapacity = true;
        Inventory inv = vehicle.getInventory().clone(null);
        try {
            for (Class equipmentType : equipment.keySet()) {
                int num = equipment.get(equipmentType);
                Coordinates defaultLoc = new Coordinates(0.0, 0.0);
                for (int x = 0; x < num; ++x) {
                    inv.storeUnit(EquipmentFactory.getEquipment(equipmentType, defaultLoc, false));
                }
            }
            for (Resource resource : resources.keySet()) {
                if (resource instanceof AmountResource) {
                    double amount = (Double)resources.get(resource);
                    inv.storeAmountResource((AmountResource)resource, amount, true);
                    continue;
                }
                int num = (Integer)resources.get(resource);
                inv.storeItemResources((ItemResource)resource, num);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            sufficientCapacity = false;
        }
        return sufficientCapacity;
    }

    public static boolean isFullyLoaded(Map<Resource, Number> requiredResources, Map<Resource, Number> optionalResources, Map<Class, Integer> requiredEquipment, Map<Class, Integer> optionalEquipment, Vehicle vehicle, Settlement settlement) {
        boolean sufficientSupplies = true;
        sufficientSupplies = LoadVehicleGarage.isFullyLoadedWithResources(requiredResources, optionalResources, vehicle, settlement);
        if (sufficientSupplies) {
            sufficientSupplies = LoadVehicleGarage.isFullyLoadedWithEquipment(requiredEquipment, optionalEquipment, vehicle, settlement);
        }
        return sufficientSupplies;
    }

    private static boolean isFullyLoadedWithResources(Map<Resource, Number> requiredResources, Map<Resource, Number> optionalResources, Vehicle vehicle, Settlement settlement) {
        if (vehicle == null) {
            throw new IllegalArgumentException("vehicle is null");
        }
        boolean sufficientSupplies = true;
        Inventory vInv = vehicle.getInventory();
        Inventory sInv = settlement.getInventory();
        Iterator<Resource> iR = requiredResources.keySet().iterator();
        while (iR.hasNext() && sufficientSupplies) {
            Resource resource = iR.next();
            if (resource instanceof AmountResource) {
                double amount = (Double)requiredResources.get(resource);
                double storedAmount = vInv.getAmountResourceStored((AmountResource)resource, false);
                if (!(storedAmount < amount - 1.0E-7)) continue;
                sufficientSupplies = false;
                continue;
            }
            if (resource instanceof ItemResource) {
                int num = (Integer)requiredResources.get(resource);
                if (vInv.getItemResourceNum((ItemResource)resource) >= num) continue;
                sufficientSupplies = false;
                continue;
            }
            throw new IllegalStateException("Unknown resource type: " + resource);
        }
        Iterator<Resource> iR2 = optionalResources.keySet().iterator();
        while (iR2.hasNext() && sufficientSupplies) {
            Resource resource = iR2.next();
            if (resource instanceof AmountResource) {
                boolean hasStoredSettlement;
                double storedAmount;
                AmountResource amountResource = (AmountResource)resource;
                double amount = (Double)optionalResources.get(resource);
                if (requiredResources.containsKey(resource)) {
                    amount += ((Double)requiredResources.get(resource)).doubleValue();
                }
                if (!((storedAmount = vInv.getAmountResourceStored(amountResource, false)) < amount - 1.0E-7)) continue;
                double vehicleCapacity = vInv.getAmountResourceRemainingCapacity(amountResource, true, false);
                boolean hasVehicleCapacity = vehicleCapacity >= amount - storedAmount;
                double storedSettlement = sInv.getAmountResourceStored(amountResource, false);
                if (settlement.getParkedVehicles().contains(vehicle)) {
                    storedSettlement -= storedAmount;
                }
                boolean bl = hasStoredSettlement = storedSettlement >= amount - storedAmount;
                if (!hasVehicleCapacity || !hasStoredSettlement) continue;
                sufficientSupplies = false;
                continue;
            }
            if (resource instanceof ItemResource) {
                boolean hasStoredSettlement;
                int storedNum;
                ItemResource itemResource = (ItemResource)resource;
                double num = ((Integer)optionalResources.get(resource)).intValue();
                if (requiredResources.containsKey(resource)) {
                    num += (double)((Integer)requiredResources.get(resource)).intValue();
                }
                if (!((double)(storedNum = vInv.getItemResourceNum(itemResource)) < num)) continue;
                double vehicleCapacity = vInv.getRemainingGeneralCapacity(false);
                boolean hasVehicleCapacity = vehicleCapacity >= (num - (double)storedNum) * itemResource.getMassPerItem();
                int storedSettlement = sInv.getItemResourceNum(itemResource);
                if (settlement.getParkedVehicles().contains(vehicle)) {
                    storedSettlement -= storedNum;
                }
                boolean bl = hasStoredSettlement = (double)storedSettlement >= num - (double)storedNum;
                if (!hasVehicleCapacity || !hasStoredSettlement) continue;
                sufficientSupplies = false;
                continue;
            }
            throw new IllegalStateException("Unknown resource type: " + resource);
        }
        return sufficientSupplies;
    }

    private static boolean isFullyLoadedWithEquipment(Map<Class, Integer> requiredEquipment, Map<Class, Integer> optionalEquipment, Vehicle vehicle, Settlement settlement) {
        if (vehicle == null) {
            throw new IllegalArgumentException("vehicle is null");
        }
        boolean sufficientSupplies = true;
        Inventory vInv = vehicle.getInventory();
        Inventory sInv = settlement.getInventory();
        Iterator<Class> iE = requiredEquipment.keySet().iterator();
        while (iE.hasNext() && sufficientSupplies) {
            Class equipmentType = iE.next();
            int num = requiredEquipment.get(equipmentType);
            if (vInv.findNumUnitsOfClass(equipmentType) >= num) continue;
            sufficientSupplies = false;
        }
        Iterator<Class> iE2 = optionalEquipment.keySet().iterator();
        while (iE2.hasNext() && sufficientSupplies) {
            boolean hasStoredSettlement;
            int storedNum;
            Class equipmentType = iE2.next();
            int num = optionalEquipment.get(equipmentType);
            if (requiredEquipment.containsKey(equipmentType)) {
                num += requiredEquipment.get(equipmentType).intValue();
            }
            if ((storedNum = vInv.findNumUnitsOfClass(equipmentType)) >= num) continue;
            int storedSettlement = sInv.findNumEmptyUnitsOfClass(equipmentType, false);
            if (settlement.getParkedVehicles().contains(vehicle)) {
                storedSettlement -= storedNum;
            }
            if (!(hasStoredSettlement = storedSettlement >= num - storedNum)) continue;
            sufficientSupplies = false;
        }
        return sufficientSupplies;
    }

    @Override
    public int getEffectiveSkillLevel() {
        return 0;
    }

    @Override
    public List<String> getAssociatedSkills() {
        return new ArrayList<String>(0);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.vehicle = null;
        this.settlement = null;
        if (this.requiredResources != null) {
            this.requiredResources.clear();
        }
        this.requiredResources = null;
        if (this.optionalResources != null) {
            this.optionalResources.clear();
        }
        this.optionalResources = null;
        if (this.requiredEquipment != null) {
            this.requiredEquipment.clear();
        }
        this.requiredEquipment = null;
        if (this.optionalEquipment != null) {
            this.optionalEquipment.clear();
        }
        this.optionalEquipment = null;
    }
}

