/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.Structure;
import org.mars_sim.msp.core.structure.building.Building;

public class MaintenanceEVA
extends EVAOperation
implements Serializable {
    private static Logger logger = Logger.getLogger(MaintenanceEVA.class.getName());
    private static final String MAINTAIN = "Maintenance";
    private Malfunctionable entity;
    private Airlock airlock;

    public MaintenanceEVA(Person person) {
        super("Performing EVA Maintenance", person);
        this.airlock = MaintenanceEVA.getAvailableAirlock(person);
        if (this.airlock == null) {
            this.endTask();
        }
        try {
            this.entity = this.getMaintenanceMalfunctionable();
            if (this.entity == null) {
                this.endTask();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "MaintenanceEVA.constructor()", e);
            this.endTask();
        }
        this.addPhase(MAINTAIN);
    }

    public static double getProbability(Person person) {
        Settlement settlement;
        SurfaceFeatures surface;
        double result = 0.0;
        try {
            for (Malfunctionable entity : MalfunctionFactory.getMalfunctionables(person)) {
                boolean minTime;
                boolean isStructure = entity instanceof Structure;
                boolean uninhabitableBuilding = false;
                if (entity instanceof Building) {
                    uninhabitableBuilding = !((Building)entity).hasFunction("Life Support");
                }
                MalfunctionManager manager = entity.getMalfunctionManager();
                boolean hasMalfunction = manager.hasMalfunction();
                boolean hasParts = Maintenance.hasMaintenanceParts(person, entity);
                double effectiveTime = manager.getEffectiveTimeSinceLastMaintenance();
                boolean bl = minTime = effectiveTime >= 1000.0;
                if (!isStructure && !uninhabitableBuilding || hasMalfunction || !minTime || !hasParts) continue;
                double entityProb = manager.getEffectiveTimeSinceLastMaintenance() / 1000.0;
                if (entityProb > 100.0) {
                    entityProb = 100.0;
                }
                result += entityProb;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getProbability()", e);
        }
        if (MaintenanceEVA.getAvailableAirlock(person) == null) {
            result = 0.0;
        }
        if ((surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) == 0.0 && !surface.inDarkPolarRegion(person.getCoordinates())) {
            result = 0.0;
        }
        if (person.getLocationSituation().equals("In Settlement") && (settlement = person.getSettlement()).getCurrentPopulationNum() > settlement.getPopulationCapacity()) {
            result *= 2.0;
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(MaintenanceEVA.class);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitEVA(time);
        }
        if (MAINTAIN.equals(this.getPhase())) {
            return this.maintenance(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterEVA(time);
        }
        return time;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (MAINTAIN.equals(this.getPhase())) {
            double mechanicsExperience = time / 100.0;
            mechanicsExperience += mechanicsExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Mechanics", mechanicsExperience);
        }
    }

    private double exitEVA(double time) {
        try {
            time = this.exitAirlock(time, this.airlock);
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(MAINTAIN);
            this.moveToMaintenanceLocation();
        }
        return time;
    }

    private void moveToMaintenanceLocation() {
        Settlement settlement;
        List<Building> allBuildings;
        LocalBoundedObject boundedObject = null;
        if (this.entity instanceof LocalBoundedObject) {
            boundedObject = (LocalBoundedObject)((Object)this.entity);
        } else if (this.entity instanceof Settlement && (allBuildings = (settlement = (Settlement)((Object)this.entity)).getBuildingManager().getBuildings()).size() > 0) {
            int index = RandomUtil.getRandomInt(allBuildings.size() - 1);
            boundedObject = allBuildings.get(index);
        }
        if (boundedObject != null) {
            Point2D.Double newLocation = null;
            boolean goodLocation = false;
            for (int x = 0; x < 20 && !goodLocation; ++x) {
                Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomExteriorLocation(boundedObject, 1.0);
                newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), boundedObject);
                goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
            }
            this.person.setXLocation(newLocation.getX());
            this.person.setYLocation(newLocation.getY());
        }
    }

    private double maintenance(double time) {
        Inventory inv;
        boolean finishedMaintenance;
        MalfunctionManager manager = this.entity.getMalfunctionManager();
        boolean malfunction = manager.hasMalfunction();
        boolean bl = finishedMaintenance = manager.getEffectiveTimeSinceLastMaintenance() < 1000.0;
        if (finishedMaintenance || malfunction || this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        double workTime = time;
        int mechanicSkill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        if (mechanicSkill == 0) {
            workTime /= 2.0;
        }
        if (mechanicSkill > 1) {
            workTime += workTime * (0.2 * (double)mechanicSkill);
        }
        if (Maintenance.hasMaintenanceParts(inv = this.containerUnit.getInventory(), this.entity)) {
            HashMap<Part, Integer> parts = new HashMap<Part, Integer>(manager.getMaintenanceParts());
            for (Part part : parts.keySet()) {
                int number = (Integer)parts.get(part);
                inv.retrieveItemResources(part, number);
                manager.maintainWithParts(part, number);
            }
        } else {
            this.setPhase("Enter Airlock");
            return time;
        }
        manager.addMaintenanceWorkTime(workTime);
        this.addExperience(time);
        this.checkForAccident(time);
        return 0.0;
    }

    private double enterEVA(double time) {
        time = this.enterAirlock(time, this.airlock);
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
        }
        return time;
    }

    @Override
    protected void checkForAccident(double time) {
        super.checkForAccident(time);
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.entity.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            logger.info(this.person.getName() + " has accident while performing maintenance on " + this.entity.getName() + ".");
            this.entity.getMalfunctionManager().accident();
        }
    }

    private Malfunctionable getMaintenanceMalfunctionable() {
        Malfunctionable result = null;
        HashMap<Malfunctionable, Double> malfunctionables = new HashMap<Malfunctionable, Double>();
        for (Malfunctionable entity : MalfunctionFactory.getMalfunctionables(this.person)) {
            double probability = this.getProbabilityWeight(entity);
            if (!(probability > 0.0)) continue;
            malfunctionables.put(entity, probability);
        }
        if (!malfunctionables.isEmpty()) {
            result = (Malfunctionable)RandomUtil.getWeightedRandomObject(malfunctionables);
        }
        if (result != null) {
            this.setDescription("Performing maintenance on " + result.getName());
        }
        return result;
    }

    private double getProbabilityWeight(Malfunctionable malfunctionable) {
        boolean minTime;
        double result = 0.0;
        boolean isStructure = malfunctionable instanceof Structure;
        boolean uninhabitableBuilding = false;
        if (malfunctionable instanceof Building) {
            uninhabitableBuilding = !((Building)malfunctionable).hasFunction("Life Support");
        }
        MalfunctionManager manager = malfunctionable.getMalfunctionManager();
        boolean hasMalfunction = manager.hasMalfunction();
        boolean hasParts = Maintenance.hasMaintenanceParts(this.person, malfunctionable);
        double effectiveTime = manager.getEffectiveTimeSinceLastMaintenance();
        boolean bl = minTime = effectiveTime >= 1000.0;
        if ((isStructure || uninhabitableBuilding) && !hasMalfunction && minTime && hasParts) {
            result = effectiveTime;
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int mechanicsSkill = manager.getEffectiveSkillLevel("Mechanics");
        return (int)Math.round((double)(EVAOperationsSkill + mechanicsSkill) / 2.0);
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add("Mechanics");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.entity = null;
        this.airlock = null;
    }
}

