/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Doctor;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.person.medical.AntiStressMedication;
import org.mars_sim.msp.core.person.medical.Medication;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class PrescribeMedication
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(PrescribeMedication.class.getName());
    private static final String MEDICATING = "Medicating";
    private static final double STRESS_MODIFIER = 0.0;
    Person patient = null;
    Medication medication = null;

    public PrescribeMedication(Person person) {
        super("Prescribing Medication", person, true, false, 0.0, true, 10.0);
        this.patient = PrescribeMedication.determinePatient(person);
        if (this.patient != null) {
            Building patientBuilding;
            Building doctorBuilding;
            this.medication = this.determineMedication(this.patient);
            if (person.getLocationSituation().equals("In Settlement") && (doctorBuilding = BuildingManager.getBuilding(person)) != (patientBuilding = BuildingManager.getBuilding(this.patient))) {
                BuildingManager.addPersonToBuilding(person, patientBuilding);
            }
            logger.info(person.getName() + " prescribing " + this.medication.getName() + " to " + this.patient.getName());
        } else {
            this.endTask();
        }
        this.addPhase(MEDICATING);
        this.setPhase(MEDICATING);
    }

    public static double getProbability(Person person) {
        Person patient;
        double result = 0.0;
        Job job = person.getMind().getJob();
        if (job instanceof Doctor && (patient = PrescribeMedication.determinePatient(person)) != null) {
            result = 100.0;
        }
        return result *= person.getPerformanceRating();
    }

    private static Person determinePatient(Person doctor) {
        Vehicle vehicle;
        Person result = null;
        Collection<Person> patientList = null;
        String loc = doctor.getLocationSituation();
        if (loc.equals("In Settlement")) {
            patientList = doctor.getSettlement().getInhabitants();
        } else if (loc.equals("In Vehicle") && (vehicle = doctor.getVehicle()) instanceof Crewable) {
            Crewable crewVehicle = (Crewable)((Object)vehicle);
            patientList = crewVehicle.getCrew();
        }
        if (patientList != null) {
            Iterator<Person> i = patientList.iterator();
            while (i.hasNext() && result == null) {
                Person person = i.next();
                PhysicalCondition condition = person.getPhysicalCondition();
                if (condition.isDead() || !(condition.getStress() >= 100.0) || condition.hasMedication("anti-stress medication")) continue;
                result = person;
            }
        }
        return result;
    }

    private Medication determineMedication(Person patient) {
        return new AntiStressMedication(patient);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double medicatingPhase(double time) {
        if (this.getDuration() <= this.getTimeCompleted() + time) {
            if (this.patient == null) throw new IllegalStateException("patient is null");
            if (this.medication == null) throw new IllegalStateException("medication is null");
            PhysicalCondition condition = this.patient.getPhysicalCondition();
            if (!condition.hasMedication(this.medication.getName())) {
                condition.addMedication(this.medication);
            }
        }
        this.addExperience(time);
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 10.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Medicine", newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Medicine");
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Medicine");
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (MEDICATING.equals(this.getPhase())) {
            return this.medicatingPhase(time);
        }
        return time;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.patient = null;
        this.medication = null;
    }
}

