/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;

public class ProposeScientificStudy
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(ProposeScientificStudy.class.getName());
    private static final double STRESS_MODIFIER = 0.0;
    private static final String PROPOSAL_PHASE = "Writing Study Proposal";
    private ScientificStudy study;

    public ProposeScientificStudy(Person person) {
        super("Proposing a Scientific Study", person, false, true, 0.0, true, RandomUtil.getRandomDouble(100.0));
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        this.study = manager.getOngoingPrimaryStudy(person);
        if (this.study == null) {
            Job job = person.getMind().getJob();
            Science science = ScienceUtil.getAssociatedScience(job);
            if (science != null) {
                String skillName = ScienceUtil.getAssociatedSkill(science);
                int level = person.getMind().getSkillManager().getSkillLevel(skillName);
                this.study = manager.createScientificStudy(person, science, level);
            } else {
                logger.log(Level.SEVERE, "Person's job: " + job.getName() + " not scientist.");
                this.endTask();
            }
        }
        if (this.study != null) {
            this.setDescription("Proposing a " + this.study.getScience().getName() + " study");
        }
        this.addPhase(PROPOSAL_PHASE);
        this.setPhase(PROPOSAL_PHASE);
    }

    public static double getProbability(Person person) {
        Job job;
        double result = 0.0;
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        ScientificStudy study = manager.getOngoingPrimaryStudy(person);
        if (study != null) {
            if (study.getPhase().equals("Study Proposal")) {
                job = person.getMind().getJob();
                Science science = study.getScience();
                result = job != null && science.equals(ScienceUtil.getAssociatedScience(job)) ? 50.0 : 10.0;
            }
        } else {
            if (ScienceUtil.isScienceJob(person.getMind().getJob())) {
                result = 1.0;
            }
            int numCollabStudies = manager.getOngoingCollaborativeStudies(person).size();
            result /= (double)numCollabStudies + 1.0;
        }
        if ((job = person.getMind().getJob()) != null) {
            result *= job.getStartTaskProbabilityModifier(ProposeScientificStudy.class);
        }
        return result;
    }

    private double proposingPhase(double time) {
        if (!this.study.getPhase().equals("Study Proposal")) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        double workTime = time;
        int scienceSkill = this.getEffectiveSkillLevel();
        workTime = scienceSkill == 0 ? (workTime /= 2.0) : (workTime += workTime * (0.2 * (double)scienceSkill));
        this.study.addProposalWorkTime(workTime);
        this.addExperience(time);
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 25.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        String skillName = ScienceUtil.getAssociatedSkill(this.study.getScience());
        this.person.getMind().getSkillManager().addExperience(skillName, newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> skills = new ArrayList<String>(1);
        skills.add(ScienceUtil.getAssociatedSkill(this.study.getScience()));
        return skills;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        String skillName = ScienceUtil.getAssociatedSkill(this.study.getScience());
        return manager.getEffectiveSkillLevel(skillName);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (PROPOSAL_PHASE.equals(this.getPhase())) {
            return this.proposingPhase(time);
        }
        return time;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.study = null;
    }
}

