/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;

class Relax
extends Task
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.person.ai.task.Task";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private static final String RELAXING = "Relaxing";
    private static final double STRESS_MODIFIER = -0.5;

    public Relax(Person person) {
        super(RELAXING, person, false, false, -0.5, true, RandomUtil.getRandomInt(100));
        if (person.getLocationSituation().equals("In Settlement")) {
            try {
                Building recBuilding = Relax.getAvailableRecreationBuilding(person);
                if (recBuilding != null) {
                    BuildingManager.addPersonToBuilding(person, recBuilding);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Relax.constructor(): " + e.getMessage());
                this.endTask();
            }
        }
        this.addPhase(RELAXING);
        this.setPhase(RELAXING);
    }

    public static double getProbability(Person person) {
        double result = 10.0;
        result += person.getPhysicalCondition().getStress();
        if (person.getLocationSituation().equals("In Settlement")) {
            try {
                Building recBuilding = Relax.getAvailableRecreationBuilding(person);
                if (recBuilding != null) {
                    result *= Task.getCrowdingProbabilityModifier(person, recBuilding);
                    result *= Task.getRelationshipModifier(person, recBuilding);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Relax.getProbability(): " + e.getMessage());
            }
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (RELAXING.equals(this.getPhase())) {
            return this.relaxingPhase(time);
        }
        return time;
    }

    private double relaxingPhase(double time) {
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
    }

    private static Building getAvailableRecreationBuilding(Person person) {
        Building result = null;
        if (person.getLocationSituation().equals("In Settlement")) {
            BuildingManager manager = person.getSettlement().getBuildingManager();
            List<Building> recreationBuildings = manager.getBuildings("Recreation");
            recreationBuildings = BuildingManager.getNonMalfunctioningBuildings(recreationBuildings);
            if ((recreationBuildings = BuildingManager.getLeastCrowdedBuildings(recreationBuildings)).size() > 0) {
                Map<Building, Double> recreationBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, recreationBuildings);
                result = RandomUtil.getWeightedRandomObject(recreationBuildingProbs);
            }
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        return 0;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(0);
        return results;
    }
}

