/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.social.Relationship;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.core.structure.Settlement;

public class RespondToStudyInvitation
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(RespondToStudyInvitation.class.getName());
    private static final double STRESS_MODIFIER = 0.0;
    private static final double DURATION = 50.0;
    private static final String RESPONDING_INVITATION = "Responding to Invitation";
    private ScientificStudy study;

    public RespondToStudyInvitation(Person person) {
        super("Responding to a Study Invitation", person, false, true, 0.0, true, 50.0);
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        List<ScientificStudy> invitedStudies = manager.getOpenInvitationStudies(person);
        if (invitedStudies.size() > 0) {
            this.study = invitedStudies.get(0);
        } else {
            logger.log(Level.SEVERE, person.getName() + " does not have any open invited studies.");
            this.endTask();
        }
        this.addPhase(RESPONDING_INVITATION);
        this.setPhase(RESPONDING_INVITATION);
    }

    public static double getProbability(Person person) {
        Job job;
        double result = 0.0;
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        List<ScientificStudy> invitedStudies = manager.getOpenInvitationStudies(person);
        if (invitedStudies.size() > 0) {
            result = 50.0;
        }
        if ((job = person.getMind().getJob()) != null) {
            result *= job.getStartTaskProbabilityModifier(RespondToStudyInvitation.class);
        }
        return result;
    }

    private double respondingToInvitationPhase(double time) {
        if (this.isDone()) {
            return time;
        }
        if (this.getDuration() <= this.getTimeCompleted() + time) {
            this.study.respondingInvitedResearcher(this.person);
            Job job = this.person.getMind().getJob();
            Person primaryResearcher = this.study.getPrimaryResearcher();
            RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
            Relationship relationship = relationshipManager.getRelationship(this.person, primaryResearcher);
            if (this.decideResponse()) {
                Science science = ScienceUtil.getAssociatedScience(job);
                this.study.addCollaborativeResearcher(this.person, science);
                if (relationship != null) {
                    double currentOpinion = relationship.getPersonOpinion(primaryResearcher);
                    relationship.setPersonOpinion(primaryResearcher, currentOpinion + 10.0);
                }
                logger.info(job.getName() + " " + this.person.getName() + " accepting invitation from " + primaryResearcher.getName() + " to collaborate on " + this.study.toString());
            } else {
                if (relationship != null) {
                    double currentOpinion = relationship.getPersonOpinion(primaryResearcher);
                    relationship.setPersonOpinion(primaryResearcher, currentOpinion - 10.0);
                }
                logger.info(job.getName() + " " + this.person.getName() + " rejecting invitation from " + primaryResearcher.getName() + " to collaborate on " + this.study.toString());
            }
        }
        return 0.0;
    }

    private boolean decideResponse() {
        boolean result = false;
        Science studyScience = this.study.getScience();
        Science jobScience = ScienceUtil.getAssociatedScience(this.person.getMind().getJob());
        if (jobScience != null) {
            boolean isPrimaryScience = studyScience.equals(jobScience);
            boolean isCollaborativeScience = ScienceUtil.isCollaborativeScience(studyScience, jobScience);
            if (isPrimaryScience || isCollaborativeScience) {
                int difficultyLevel;
                double acceptChance = 50.0;
                double primaryAchievement = this.study.getPrimaryResearcher().getScientificAchievement(studyScience);
                acceptChance += primaryAchievement;
                for (Person collaborator : this.study.getCollaborativeResearchers().keySet()) {
                    Science collaborativeScience = this.study.getCollaborativeResearchers().get(collaborator);
                    acceptChance += collaborator.getScientificAchievement(collaborativeScience) / 2.0;
                }
                if (isCollaborativeScience) {
                    acceptChance /= 2.0;
                }
                ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
                int numCollabStudies = manager.getOngoingCollaborativeStudies(this.person).size();
                acceptChance /= (double)numCollabStudies + 1.0;
                String skillName = ScienceUtil.getAssociatedSkill(jobScience);
                int skillLevel = this.person.getMind().getSkillManager().getSkillLevel(skillName);
                if (skillLevel == 0) {
                    skillLevel = 1;
                }
                if ((difficultyLevel = this.study.getDifficultyLevel()) == 0) {
                    difficultyLevel = 1;
                }
                acceptChance *= (double)difficultyLevel / (double)skillLevel;
                RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
                double researcherOpinion = relationshipManager.getOpinionOfPerson(this.person, this.study.getPrimaryResearcher());
                acceptChance *= researcherOpinion / 50.0;
                Settlement researcherSettlement = this.person.getAssociatedSettlement();
                Settlement primarySettlement = this.study.getPrimaryResearcher().getAssociatedSettlement();
                if (researcherSettlement != null && researcherSettlement.equals(primarySettlement)) {
                    acceptChance *= 2.0;
                }
                result = RandomUtil.getRandomDouble(100.0) < acceptChance;
            }
        }
        return result;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 25.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        Science jobScience = ScienceUtil.getAssociatedScience(this.person.getMind().getJob());
        String skillName = ScienceUtil.getAssociatedSkill(jobScience);
        this.person.getMind().getSkillManager().addExperience(skillName, newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> result = new ArrayList<String>(1);
        Science jobScience = ScienceUtil.getAssociatedScience(this.person.getMind().getJob());
        if (jobScience != null) {
            result.add(ScienceUtil.getAssociatedSkill(jobScience));
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        Science jobScience = ScienceUtil.getAssociatedScience(this.person.getMind().getJob());
        String skillName = ScienceUtil.getAssociatedSkill(jobScience);
        return this.person.getMind().getSkillManager().getEffectiveSkillLevel(skillName);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (RESPONDING_INVITATION.equals(this.getPhase())) {
            return this.respondingToInvitationPhase(time);
        }
        return time;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.study = null;
    }
}

