/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class ReturnLightUtilityVehicle
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(ReturnLightUtilityVehicle.class.getName());
    private static final String RETURN_LUV = "Returning Light Utility Vehicle";
    private static final double STRESS_MODIFIER = 0.5;
    LightUtilityVehicle luv = null;
    Unit returnContainer = null;

    public ReturnLightUtilityVehicle(Person person) {
        super("Returning light utility vehicle", person, false, false, 0.5, false, 0.0);
        Vehicle personVehicle = person.getVehicle();
        if (personVehicle != null && personVehicle instanceof LightUtilityVehicle) {
            this.luv = (LightUtilityVehicle)personVehicle;
        } else {
            this.endTask();
            logger.severe(person.getName() + " is not in a light utility vehicle.");
        }
        this.returnContainer = null;
        Mission mission = person.getMind().getMission();
        if (mission != null) {
            if (mission instanceof RoverMission) {
                RoverMission roverMission = (RoverMission)mission;
                this.returnContainer = roverMission.getRover();
            } else {
                this.returnContainer = mission.getAssociatedSettlement();
            }
        }
        if (this.returnContainer == null) {
            for (Settlement settlement : Simulation.instance().getUnitManager().getSettlements()) {
                if (!person.getCoordinates().equals(settlement.getCoordinates())) continue;
                this.returnContainer = settlement;
                break;
            }
        }
        if (this.returnContainer == null) {
            for (Vehicle vehicle : Simulation.instance().getUnitManager().getVehicles()) {
                if (!(vehicle instanceof Rover)) continue;
                this.returnContainer = vehicle;
                break;
            }
        }
        this.addPhase(RETURN_LUV);
        this.setPhase(RETURN_LUV);
        if (this.returnContainer == null) {
            this.endTask();
            logger.severe(person.getName() + " cannot find a settlement or rover to return light utility vehicle.");
        } else {
            this.setDescription("Returning " + this.luv.getName() + " to " + this.returnContainer.getName());
            logger.fine(person.getName() + " is starting to return light utility vehicle: " + this.luv.getName() + " to " + this.returnContainer.getName());
        }
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Vehicle") && person.getVehicle() instanceof LightUtilityVehicle) {
            result = 500.0;
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (RETURN_LUV.equals(this.getPhase())) {
            return this.returnLUVPhase(time);
        }
        return time;
    }

    private double returnLUVPhase(double time) {
        this.luv.getInventory().retrieveUnit(this.person);
        this.luv.setOperator(null);
        Mission mission = this.person.getMind().getMission();
        if (mission == null) {
            if (this.returnContainer.getInventory().canStoreUnit(this.luv, false)) {
                this.returnContainer.getInventory().storeUnit(this.luv);
                if (this.returnContainer instanceof Settlement) {
                    this.luv.determinedSettlementParkedLocationAndFacing();
                }
            } else {
                logger.severe("Light utility vehicle: " + this.luv.getName() + " could not be stored in " + this.returnContainer.getName());
            }
            this.unloadLUVInventory();
        }
        this.endTask();
        return time;
    }

    private void unloadLUVInventory() {
        Inventory luvInv = this.luv.getInventory();
        Inventory rcInv = this.returnContainer.getInventory();
        for (Unit unit : luvInv.getContainedUnits()) {
            if (rcInv.canStoreUnit(unit, false)) {
                luvInv.retrieveUnit(unit);
                rcInv.storeUnit(unit);
                continue;
            }
            logger.severe(unit.getName() + " cannot be stored in " + this.returnContainer.getName());
        }
        for (ItemResource item : luvInv.getAllItemResourcesStored()) {
            int num = luvInv.getItemResourceNum(item);
            double mass = item.getMassPerItem() * (double)num;
            if (rcInv.getRemainingGeneralCapacity(false) >= mass) {
                luvInv.retrieveItemResources(item, num);
                rcInv.storeItemResources(item, num);
                continue;
            }
            logger.severe(item.getName() + " numbered " + num + " cannot be stored in " + this.returnContainer.getName() + " due to insufficient remaining general capacity.");
        }
        for (AmountResource resource : luvInv.getAllAmountResourcesStored(false)) {
            double amount;
            if (rcInv.hasAmountResourceCapacity(resource, amount = luvInv.getAmountResourceStored(resource, false), false)) {
                luvInv.retrieveAmountResource(resource, amount);
                rcInv.storeAmountResource(resource, amount, true);
                continue;
            }
            logger.severe(resource.getName() + " of amount " + amount + " kg. cannot be stored in " + this.returnContainer.getName());
        }
    }

    @Override
    public int getEffectiveSkillLevel() {
        return 0;
    }

    @Override
    public List<String> getAssociatedSkills() {
        return new ArrayList<String>(0);
    }

    @Override
    protected void addExperience(double time) {
    }
}

