/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.manufacture.ManufactureUtil;
import org.mars_sim.msp.core.manufacture.SalvageProcess;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Manufacture;
import org.mars_sim.msp.core.time.MarsClock;

public class SalvageGood
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(SalvageGood.class.getName());
    private static final String SALVAGE = "Salvage";
    private static final double STRESS_MODIFIER = 0.1;
    private Manufacture workshop;
    private SalvageProcess process;

    public SalvageGood(Person person) {
        super("Salvage Good", person, true, false, 0.1, true, RandomUtil.getRandomDouble(100.0));
        Building manufactureBuilding = SalvageGood.getAvailableManufacturingBuilding(person);
        if (manufactureBuilding != null) {
            this.workshop = (Manufacture)manufactureBuilding.getFunction("Manufacture");
            BuildingManager.addPersonToBuilding(person, manufactureBuilding);
        } else {
            this.endTask();
        }
        if (this.workshop != null) {
            this.process = this.determineSalvageProcess();
            if (this.process != null) {
                this.setDescription(this.process.toString());
            } else {
                this.endTask();
            }
        }
        this.addPhase(SALVAGE);
        this.setPhase(SALVAGE);
    }

    public static double getProbability(Person person) {
        Building manufacturingBuilding;
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement") && (manufacturingBuilding = SalvageGood.getAvailableManufacturingBuilding(person)) != null) {
            SkillManager skillManager;
            int skill;
            result = 1.0;
            MarsClock startTime = Simulation.instance().getMasterClock().getInitialMarsTime();
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            double totalTimeMillisols = MarsClock.getTimeDiff(currentTime, startTime);
            double totalTimeOrbits = totalTimeMillisols / 1000.0 / 668.0;
            if (totalTimeOrbits < 28.0) {
                result = 0.0;
            }
            result *= Task.getCrowdingProbabilityModifier(person, manufacturingBuilding);
            result *= Task.getRelationshipModifier(person, manufacturingBuilding);
            if ((result *= SalvageGood.getHighestSalvagingProcessValue(person, manufacturingBuilding)) > 100.0) {
                result = 100.0;
            }
            if (SalvageGood.hasSalvageProcessRequiringWork(manufacturingBuilding, skill = (skillManager = person.getMind().getSkillManager()).getEffectiveSkillLevel("Materials Science"))) {
                result += 10.0;
            } else if (person.getSettlement().getManufactureOverride()) {
                result = 0.0;
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(SalvageGood.class);
        }
        return result;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 100.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Materials Science", newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Materials Science");
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Materials Science");
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (SALVAGE.equals(this.getPhase())) {
            return this.salvagePhase(time);
        }
        return time;
    }

    private double salvagePhase(double time) {
        if (this.workshop.getBuilding().getMalfunctionManager().hasMalfunction()) {
            this.endTask();
            return time;
        }
        if (this.process.getWorkTimeRemaining() <= 0.0) {
            this.endTask();
            return time;
        }
        double workTime = time;
        int skill = this.getEffectiveSkillLevel();
        workTime = skill == 0 ? (workTime /= 2.0) : (workTime += workTime * (0.2 * (double)skill));
        double remainingWorkTime = this.process.getWorkTimeRemaining();
        double providedWorkTime = workTime;
        if (providedWorkTime > remainingWorkTime) {
            providedWorkTime = remainingWorkTime;
        }
        this.process.addWorkTime(providedWorkTime, skill);
        if (this.process.getWorkTimeRemaining() <= 0.0) {
            this.workshop.endSalvageProcess(this.process, false);
            this.endTask();
        }
        this.addExperience(time);
        this.checkForAccident(time);
        return 0.0;
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        int skill = this.getEffectiveSkillLevel();
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.workshop.getBuilding().getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            logger.info(this.person.getName() + " has accident while salvaging " + this.process.getInfo().getItemName() + ".");
            this.workshop.getBuilding().getMalfunctionManager().accident();
        }
    }

    private static Building getAvailableManufacturingBuilding(Person person) {
        Building result = null;
        SkillManager skillManager = person.getMind().getSkillManager();
        int skill = skillManager.getEffectiveSkillLevel("Materials Science");
        if (person.getLocationSituation().equals("In Settlement")) {
            BuildingManager manager = person.getSettlement().getBuildingManager();
            List<Building> manufacturingBuildings = manager.getBuildings("Manufacture");
            manufacturingBuildings = BuildingManager.getNonMalfunctioningBuildings(manufacturingBuildings);
            manufacturingBuildings = SalvageGood.getManufacturingBuildingsNeedingSalvageWork(manufacturingBuildings, skill);
            manufacturingBuildings = SalvageGood.getBuildingsWithSalvageProcessesRequiringWork(manufacturingBuildings, skill);
            manufacturingBuildings = SalvageGood.getHighestManufacturingTechLevelBuildings(manufacturingBuildings);
            if ((manufacturingBuildings = BuildingManager.getLeastCrowdedBuildings(manufacturingBuildings)).size() > 0) {
                Map<Building, Double> manufacturingBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, manufacturingBuildings);
                result = RandomUtil.getWeightedRandomObject(manufacturingBuildingProbs);
            }
        }
        return result;
    }

    private static List<Building> getManufacturingBuildingsNeedingSalvageWork(List<Building> buildingList, int skill) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            Manufacture manufacturingFunction = (Manufacture)building.getFunction("Manufacture");
            if (!manufacturingFunction.requiresSalvagingWork(skill)) continue;
            result.add(building);
        }
        return result;
    }

    private static List<Building> getBuildingsWithSalvageProcessesRequiringWork(List<Building> buildingList, int skill) {
        List<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            if (!SalvageGood.hasSalvageProcessRequiringWork(building, skill)) continue;
            result.add(building);
        }
        if (result.size() == 0) {
            result = buildingList;
        }
        return result;
    }

    private static boolean hasSalvageProcessRequiringWork(Building manufacturingBuilding, int skill) {
        boolean result = false;
        Manufacture manufacturingFunction = (Manufacture)manufacturingBuilding.getFunction("Manufacture");
        for (SalvageProcess process : manufacturingFunction.getSalvageProcesses()) {
            boolean skillRequired;
            boolean workRequired = process.getWorkTimeRemaining() > 0.0;
            boolean bl = skillRequired = process.getInfo().getSkillLevelRequired() <= skill;
            if (!workRequired || !skillRequired) continue;
            result = true;
        }
        return result;
    }

    private static List<Building> getHighestManufacturingTechLevelBuildings(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        int highestTechLevel = 0;
        for (Building building : buildingList) {
            Manufacture manufacturingFunction = (Manufacture)building.getFunction("Manufacture");
            if (manufacturingFunction.getTechLevel() <= highestTechLevel) continue;
            highestTechLevel = manufacturingFunction.getTechLevel();
        }
        for (Building building : buildingList) {
            Manufacture manufacturingFunction = (Manufacture)building.getFunction("Manufacture");
            if (manufacturingFunction.getTechLevel() != highestTechLevel) continue;
            result.add(building);
        }
        return result;
    }

    private static double getHighestSalvagingProcessValue(Person person, Building manufacturingBuilding) {
        double highestProcessValue = 0.0;
        int skillLevel = person.getMind().getSkillManager().getEffectiveSkillLevel("Materials Science");
        Manufacture manufacturingFunction = (Manufacture)manufacturingBuilding.getFunction("Manufacture");
        int techLevel = manufacturingFunction.getTechLevel();
        for (SalvageProcessInfo process : ManufactureUtil.getSalvageProcessesForTechSkillLevel(techLevel, skillLevel)) {
            Settlement settlement;
            double processValue;
            if (!ManufactureUtil.canSalvageProcessBeStarted(process, manufacturingFunction) && !SalvageGood.isSalvageProcessRunning(process, manufacturingFunction) || !((processValue = ManufactureUtil.getSalvageProcessValue(process, settlement = manufacturingBuilding.getBuildingManager().getSettlement(), person)) > highestProcessValue)) continue;
            highestProcessValue = processValue;
        }
        return highestProcessValue;
    }

    private static boolean isSalvageProcessRunning(SalvageProcessInfo processInfo, Manufacture manufactureBuilding) {
        boolean result = false;
        for (SalvageProcess process : manufactureBuilding.getSalvageProcesses()) {
            if (process.getInfo().getItemName() != processInfo.getItemName()) continue;
            result = true;
        }
        return result;
    }

    private SalvageProcess getRunningSalvageProcess() {
        SalvageProcess result = null;
        int skillLevel = this.getEffectiveSkillLevel();
        Iterator<SalvageProcess> i = this.workshop.getSalvageProcesses().iterator();
        while (i.hasNext() && result == null) {
            SalvageProcess process = i.next();
            if (process.getInfo().getSkillLevelRequired() > skillLevel || !(process.getWorkTimeRemaining() > 0.0)) continue;
            result = process;
        }
        return result;
    }

    private SalvageProcess createNewSalvageProcess() {
        SalvageProcess result = null;
        if (this.workshop.getTotalProcessNumber() < this.workshop.getConcurrentProcesses()) {
            Unit salvagedUnit;
            int skillLevel = this.getEffectiveSkillLevel();
            int techLevel = this.workshop.getTechLevel();
            HashMap<SalvageProcessInfo, Double> processValues = new HashMap<SalvageProcessInfo, Double>();
            for (SalvageProcessInfo processInfo : ManufactureUtil.getSalvageProcessesForTechSkillLevel(techLevel, skillLevel)) {
                double processValue;
                if (!ManufactureUtil.canSalvageProcessBeStarted(processInfo, this.workshop) || !((processValue = ManufactureUtil.getSalvageProcessValue(processInfo, this.person.getSettlement(), this.person)) > 0.0)) continue;
                processValues.put(processInfo, processValue);
            }
            SalvageProcessInfo selectedProcess = (SalvageProcessInfo)RandomUtil.getWeightedRandomObject(processValues);
            if (selectedProcess != null && (salvagedUnit = ManufactureUtil.findUnitForSalvage(selectedProcess, this.person.getSettlement())) != null) {
                result = new SalvageProcess(selectedProcess, this.workshop, salvagedUnit);
                this.workshop.addSalvageProcess(result);
            }
        }
        return result;
    }

    private SalvageProcess determineSalvageProcess() {
        SalvageProcess process = this.getRunningSalvageProcess();
        if (process == null) {
            process = this.createNewSalvageProcess();
        }
        return process;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.workshop = null;
        this.process = null;
    }
}

