/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.LivingAccommodations;

class Sleep
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(Sleep.class.getName());
    private static final String SLEEPING = "Sleeping";
    private static final double STRESS_MODIFIER = -0.3;
    private static final double BASE_ALARM_TIME = 300.0;
    private LivingAccommodations accommodations;
    private double previousTime;

    public Sleep(Person person) {
        super(SLEEPING, person, false, false, -0.3, true, 250.0 + (double)RandomUtil.getRandomInt(100));
        Building quarters;
        if (person.getLocationSituation().equals("In Settlement") && (quarters = Sleep.getAvailableLivingQuartersBuilding(person)) != null) {
            BuildingManager.addPersonToBuilding(person, quarters);
            this.accommodations = (LivingAccommodations)quarters.getFunction("Living Accommodations");
            this.accommodations.addSleeper();
        }
        this.previousTime = Simulation.instance().getMasterClock().getMarsClock().getMillisol();
        this.addPhase(SLEEPING);
        this.setPhase(SLEEPING);
    }

    public static double getProbability(Person person) {
        Building building;
        SurfaceFeatures surface;
        double result = 0.0;
        double fatigue = person.getPhysicalCondition().getFatigue();
        if (fatigue > 500.0) {
            result = (fatigue - 500.0) / 4.0;
        }
        if ((surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) == 0.0) {
            result *= 2.0;
        }
        if (person.getLocationSituation().equals("In Settlement") && (building = Sleep.getAvailableLivingQuartersBuilding(person)) != null) {
            result *= Task.getCrowdingProbabilityModifier(person, building);
            result *= Task.getRelationshipModifier(person, building);
        }
        if (person.getLocationSituation().equals("Outside")) {
            result = 0.0;
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (SLEEPING.equals(this.getPhase())) {
            return this.sleepingPhase(time);
        }
        return time;
    }

    private double sleepingPhase(double time) {
        double newFatigue = this.person.getPhysicalCondition().getFatigue() - 5.0 * time;
        if (newFatigue < 0.0) {
            newFatigue = 0.0;
        }
        this.person.getPhysicalCondition().setFatigue(newFatigue);
        double newTime = Simulation.instance().getMasterClock().getMarsClock().getMillisol();
        double alarmTime = this.getAlarmTime();
        if (this.previousTime <= alarmTime && newTime >= alarmTime) {
            this.endTask();
        } else {
            this.previousTime = newTime;
        }
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
    }

    @Override
    public void endTask() {
        super.endTask();
        if (this.accommodations != null && this.accommodations.getSleepers() > 0) {
            this.accommodations.removeSleeper();
        }
    }

    private static Building getAvailableLivingQuartersBuilding(Person person) {
        Building result = null;
        if (person.getLocationSituation().equals("In Settlement")) {
            BuildingManager manager = person.getSettlement().getBuildingManager();
            List<Building> quartersBuildings = manager.getBuildings("Living Accommodations");
            quartersBuildings = BuildingManager.getNonMalfunctioningBuildings(quartersBuildings);
            quartersBuildings = Sleep.getQuartersWithEmptyBeds(quartersBuildings);
            if ((quartersBuildings = BuildingManager.getLeastCrowdedBuildings(quartersBuildings)).size() > 0) {
                Map<Building, Double> quartersBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, quartersBuildings);
                result = RandomUtil.getWeightedRandomObject(quartersBuildingProbs);
            }
        }
        return result;
    }

    private static List<Building> getQuartersWithEmptyBeds(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            LivingAccommodations quarters = (LivingAccommodations)building.getFunction("Living Accommodations");
            if (quarters.getSleepers() >= quarters.getBeds()) continue;
            result.add(building);
        }
        return result;
    }

    private double getAlarmTime() {
        double timeDiff = 1000.0 * (this.person.getCoordinates().getTheta() / (Math.PI * 2));
        double modifiedAlarmTime = 300.0 - timeDiff;
        if (modifiedAlarmTime < 0.0) {
            modifiedAlarmTime += 1000.0;
        }
        return modifiedAlarmTime;
    }

    @Override
    public int getEffectiveSkillLevel() {
        return 0;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(0);
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.accommodations = null;
    }
}

