/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Lab;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.mars.ExploredLocation;
import org.mars_sim.msp.core.mars.MineralMap;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Exploration;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.task.ResearchScientificStudy;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Research;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class StudyFieldSamples
extends Task
implements ResearchScientificStudy,
Serializable {
    private static Logger logger = Logger.getLogger(StudyFieldSamples.class.getName());
    private static final double STRESS_MODIFIER = -0.1;
    private static final String STUDYING_SAMPLES = "Studying Samples";
    private static final double SAMPLE_MASS = 1.0;
    private static final double ESTIMATE_IMPROVEMENT_FACTOR = 5.0;
    private ScientificStudy study = this.determineStudy();
    private Lab lab;
    private Science science;
    private MalfunctionManager malfunctions;
    private Person researchAssistant;

    public StudyFieldSamples(Person person) {
        super("Study Field Samples", person, true, false, -0.1, true, RandomUtil.getRandomDouble(100.0));
        Unit container;
        if (this.study != null) {
            this.science = StudyFieldSamples.getScience(person, this.study);
            if (this.science != null) {
                this.lab = StudyFieldSamples.getLocalLab(person, this.science);
                if (this.lab != null) {
                    this.addPersonToLab();
                } else {
                    logger.info("lab could not be determined.");
                    this.endTask();
                }
            } else {
                logger.info("science could not be determined");
                this.endTask();
            }
        } else {
            logger.info("study could not be determined");
            this.endTask();
        }
        if (!this.isDone() && (container = person.getContainerUnit()) != null) {
            AmountResource rockSamples = AmountResource.findAmountResource("rock samples");
            Inventory inv = container.getInventory();
            double totalRockSampleMass = inv.getAmountResourceStored(rockSamples, false);
            if (totalRockSampleMass >= 1.0) {
                double fieldSampleMass = RandomUtil.getRandomDouble(2.0);
                if (fieldSampleMass > totalRockSampleMass) {
                    fieldSampleMass = totalRockSampleMass;
                }
                inv.retrieveAmountResource(rockSamples, fieldSampleMass);
            }
        }
        this.addPhase(STUDYING_SAMPLES);
        this.setPhase(STUDYING_SAMPLES);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        List<Science> fieldSciences = StudyFieldSamples.getFieldSciences();
        ScientificStudyManager studyManager = Simulation.instance().getScientificStudyManager();
        ScientificStudy primaryStudy = studyManager.getOngoingPrimaryStudy(person);
        if (primaryStudy != null && "Research".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryResearchCompleted() && fieldSciences.contains(primaryStudy.getScience())) {
            try {
                Lab lab = StudyFieldSamples.getLocalLab(person, primaryStudy.getScience());
                if (lab != null) {
                    double primaryResult = 50.0;
                    primaryResult *= StudyFieldSamples.getLabCrowdingModifier(person, lab);
                    Job job = person.getMind().getJob();
                    if (job != null) {
                        Science jobScience = ScienceUtil.getAssociatedScience(job);
                        if (!primaryStudy.getScience().equals(jobScience)) {
                            primaryResult /= 2.0;
                        }
                    }
                    result += primaryResult;
                }
            }
            catch (Exception e) {
                logger.severe("getProbability(): " + e.getMessage());
            }
        }
        for (ScientificStudy collabStudy : studyManager.getOngoingCollaborativeStudies(person)) {
            Science collabScience;
            if (!"Research".equals(collabStudy.getPhase()) || collabStudy.isCollaborativeResearchCompleted(person) || !fieldSciences.contains(collabScience = collabStudy.getCollaborativeResearchers().get(person))) continue;
            try {
                Science jobScience;
                Lab lab = StudyFieldSamples.getLocalLab(person, collabScience);
                if (lab == null) continue;
                double collabResult = 25.0;
                collabResult *= StudyFieldSamples.getLabCrowdingModifier(person, lab);
                Job job = person.getMind().getJob();
                if (job != null && !collabScience.equals(jobScience = ScienceUtil.getAssociatedScience(job))) {
                    collabResult /= 2.0;
                }
                result += collabResult;
            }
            catch (Exception e) {
                logger.severe("getProbability(): " + e.getMessage());
            }
        }
        try {
            AmountResource rockSamples;
            Inventory inv;
            Unit container = person.getContainerUnit();
            if (container != null && (inv = container.getInventory()).getAmountResourceStored(rockSamples = AmountResource.findAmountResource("rock samples"), false) < 1.0) {
                result = 0.0;
            }
        }
        catch (Exception e) {
            logger.severe("getProbability(): " + e.getMessage());
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(StudyFieldSamples.class);
        }
        return result;
    }

    private static List<Science> getFieldSciences() {
        ArrayList<Science> fieldSciences = new ArrayList<Science>(3);
        fieldSciences.add(ScienceUtil.getScience("Areology"));
        fieldSciences.add(ScienceUtil.getScience("Biology"));
        fieldSciences.add(ScienceUtil.getScience("Chemistry"));
        return fieldSciences;
    }

    private static double getLabCrowdingModifier(Person researcher, Lab lab) {
        Building labBuilding;
        double result = 1.0;
        if (researcher.getLocationSituation().equals("In Settlement") && (labBuilding = ((Research)lab).getBuilding()) != null) {
            result *= Task.getCrowdingProbabilityModifier(researcher, labBuilding);
            result *= Task.getRelationshipModifier(researcher, labBuilding);
        }
        return result;
    }

    private ScientificStudy determineStudy() {
        ScientificStudy result = null;
        ArrayList<ScientificStudy> possibleStudies = new ArrayList<ScientificStudy>();
        List<Science> fieldSciences = StudyFieldSamples.getFieldSciences();
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        ScientificStudy primaryStudy = manager.getOngoingPrimaryStudy(this.person);
        if (primaryStudy != null && "Research".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryResearchCompleted() && fieldSciences.contains(primaryStudy.getScience())) {
            possibleStudies.add(primaryStudy);
            possibleStudies.add(primaryStudy);
        }
        for (ScientificStudy collabStudy : manager.getOngoingCollaborativeStudies(this.person)) {
            Science collabScience;
            if (!"Research".equals(collabStudy.getPhase()) || collabStudy.isCollaborativeResearchCompleted(this.person) || !fieldSciences.contains(collabScience = collabStudy.getCollaborativeResearchers().get(this.person))) continue;
            possibleStudies.add(collabStudy);
        }
        if (possibleStudies.size() > 0) {
            int selected = RandomUtil.getRandomInt(possibleStudies.size() - 1);
            result = (ScientificStudy)possibleStudies.get(selected);
        }
        return result;
    }

    private static Science getScience(Person researcher, ScientificStudy study) {
        Science result = null;
        if (study.getPrimaryResearcher().equals(researcher)) {
            result = study.getScience();
        } else if (study.getCollaborativeResearchers().containsKey(researcher)) {
            result = study.getCollaborativeResearchers().get(researcher);
        }
        return result;
    }

    private static Lab getLocalLab(Person person, Science science) {
        Lab result = null;
        String location = person.getLocationSituation();
        if (location.equals("In Settlement")) {
            result = StudyFieldSamples.getSettlementLab(person, science);
        } else if (location.equals("In Vehicle")) {
            result = StudyFieldSamples.getVehicleLab(person.getVehicle(), science);
        }
        return result;
    }

    private static Lab getSettlementLab(Person person, Science science) {
        Research result = null;
        BuildingManager manager = person.getSettlement().getBuildingManager();
        List<Building> labBuildings = manager.getBuildings("Research");
        labBuildings = StudyFieldSamples.getSettlementLabsWithSpeciality(science, labBuildings);
        labBuildings = BuildingManager.getNonMalfunctioningBuildings(labBuildings);
        labBuildings = StudyFieldSamples.getSettlementLabsWithAvailableSpace(labBuildings);
        if ((labBuildings = BuildingManager.getLeastCrowdedBuildings(labBuildings)).size() > 0) {
            Map<Building, Double> labBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, labBuildings);
            Building building = RandomUtil.getWeightedRandomObject(labBuildingProbs);
            result = (Research)building.getFunction("Research");
        }
        return result;
    }

    private static List<Building> getSettlementLabsWithAvailableSpace(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            Research lab = (Research)building.getFunction("Research");
            if (lab.getResearcherNum() >= lab.getLaboratorySize()) continue;
            result.add(building);
        }
        return result;
    }

    private static List<Building> getSettlementLabsWithSpeciality(Science science, List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            Research lab = (Research)building.getFunction("Research");
            if (!lab.hasSpeciality(science.getName())) continue;
            result.add(building);
        }
        return result;
    }

    private static Lab getVehicleLab(Vehicle vehicle, Science science) {
        Rover rover;
        Lab result = null;
        if (vehicle instanceof Rover && (rover = (Rover)vehicle).hasLab()) {
            Lab lab = rover.getLab();
            boolean availableSpace = lab.getResearcherNum() < lab.getLaboratorySize();
            boolean speciality = lab.hasSpeciality(science.getName());
            boolean malfunction = rover.getMalfunctionManager().hasMalfunction();
            if (availableSpace && speciality && !malfunction) {
                result = lab;
            }
        }
        return result;
    }

    private void addPersonToLab() {
        try {
            String location = this.person.getLocationSituation();
            if (location.equals("In Settlement")) {
                Building labBuilding = ((Research)this.lab).getBuilding();
                BuildingManager.addPersonToBuilding(this.person, labBuilding);
                this.lab.addResearcher();
                this.malfunctions = labBuilding.getMalfunctionManager();
            } else if (location.equals("In Vehicle")) {
                this.lab.addResearcher();
                this.malfunctions = this.person.getVehicle().getMalfunctionManager();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "addPersonToLab(): " + e.getMessage());
        }
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 10.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.science);
        this.person.getMind().getSkillManager().addExperience(scienceSkill, newPoints *= this.getTeachingExperienceModifier());
    }

    private double getEffectiveResearchTime(double time) {
        int techLevel;
        double researchTime = time;
        int scienceSkill = this.getEffectiveSkillLevel();
        if (scienceSkill == 0) {
            researchTime /= 2.0;
        }
        if (scienceSkill > 1) {
            researchTime += researchTime * (0.2 * (double)scienceSkill);
        }
        if ((techLevel = this.lab.getTechnologyLevel()) > 0) {
            researchTime *= (double)techLevel;
        }
        if (this.hasResearchAssistant()) {
            SkillManager manager = this.researchAssistant.getMind().getSkillManager();
            int assistantSkill = manager.getEffectiveSkillLevel(ScienceUtil.getAssociatedSkill(this.science));
            if (scienceSkill > 0) {
                researchTime *= 1.0 + (double)assistantSkill / (double)scienceSkill;
            }
        }
        return researchTime;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.science);
        results.add(scienceSkill);
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.science);
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel(scienceSkill);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (STUDYING_SAMPLES.equals(this.getPhase())) {
            return this.studyingSamplesPhase(time);
        }
        return time;
    }

    private double studyingSamplesPhase(double time) {
        boolean isPrimary;
        if (this.person.getPerformanceRating() == 0.0) {
            this.endTask();
        }
        if (this.malfunctions.hasMalfunction()) {
            this.endTask();
        }
        if (isPrimary = this.study.getPrimaryResearcher().equals(this.person)) {
            if (this.study.isPrimaryResearchCompleted()) {
                this.endTask();
            }
        } else if (this.study.isCollaborativeResearchCompleted(this.person)) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        double researchTime = this.getEffectiveResearchTime(time);
        if (isPrimary) {
            this.study.addPrimaryResearchWorkTime(researchTime);
        } else {
            this.study.addCollaborativeResearchWorkTime(this.person, researchTime);
        }
        Science areologyScience = ScienceUtil.getScience("Areology");
        if (areologyScience.equals(this.science)) {
            this.improveMineralConcentrationEstimates(time);
        }
        this.addExperience(researchTime);
        this.checkForAccident(time);
        return 0.0;
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.science);
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel(scienceSkill);
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        Malfunctionable entity = null;
        entity = this.lab instanceof Research ? ((Research)this.lab).getBuilding() : this.person.getVehicle();
        if (entity != null && RandomUtil.lessThanRandPercent((chance *= entity.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            logger.info(this.person.getName() + " has a lab accident while studying field samples.");
            entity.getMalfunctionManager().accident();
        }
    }

    private void improveMineralConcentrationEstimates(double time) {
        ExploredLocation site;
        double probability = time / 1000.0 * (double)this.getEffectiveSkillLevel() * 5.0;
        if (RandomUtil.getRandomDouble(1.0) <= probability && (site = this.determineExplorationSite()) != null) {
            MineralMap mineralMap = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap();
            Map<String, Double> estimatedMineralConcentrations = site.getEstimatedMineralConcentrations();
            for (String mineralType : estimatedMineralConcentrations.keySet()) {
                double actualConcentration = mineralMap.getMineralConcentration(mineralType, site.getLocation());
                double estimatedConcentration = estimatedMineralConcentrations.get(mineralType);
                double estimationDiff = Math.abs(actualConcentration - estimatedConcentration);
                double estimationImprovement = RandomUtil.getRandomDouble(1.0 * (double)this.getEffectiveSkillLevel());
                if (estimationImprovement > estimationDiff) {
                    estimationImprovement = estimationDiff;
                }
                estimatedConcentration = estimatedConcentration < actualConcentration ? (estimatedConcentration += estimationImprovement) : (estimatedConcentration -= estimationImprovement);
                estimatedMineralConcentrations.put(mineralType, estimatedConcentration);
            }
        }
    }

    private ExploredLocation determineExplorationSite() {
        ExploredLocation result = this.getExplorationMissionSite();
        if (result == null) {
            result = this.getSettlementExploredSite();
        }
        return result;
    }

    private ExploredLocation getExplorationMissionSite() {
        int siteIndex;
        ExploredLocation location;
        Exploration explorationMission;
        List<ExploredLocation> exploredSites;
        ExploredLocation result = null;
        Mission mission = this.person.getMind().getMission();
        if (mission != null && mission instanceof Exploration && (exploredSites = (explorationMission = (Exploration)mission).getExploredSites()).size() > 0 && !(location = exploredSites.get(siteIndex = RandomUtil.getRandomInt(exploredSites.size() - 1))).isMined() && !location.isReserved()) {
            result = location;
        }
        return result;
    }

    private ExploredLocation getSettlementExploredSite() {
        ExploredLocation result = null;
        Settlement settlement = this.person.getAssociatedSettlement();
        if (settlement != null) {
            ArrayList<ExploredLocation> settlementExploredLocations = new ArrayList<ExploredLocation>();
            List<ExploredLocation> allExploredLocations = Simulation.instance().getMars().getSurfaceFeatures().getExploredLocations();
            for (ExploredLocation location : allExploredLocations) {
                if (!settlement.equals(location.getSettlement()) || location.isMined() || location.isReserved()) continue;
                settlementExploredLocations.add(location);
            }
            if (settlementExploredLocations.size() > 0) {
                int siteIndex = RandomUtil.getRandomInt(settlementExploredLocations.size() - 1);
                result = (ExploredLocation)settlementExploredLocations.get(siteIndex);
            }
        }
        return result;
    }

    @Override
    public void endTask() {
        super.endTask();
        try {
            if (this.lab != null) {
                this.lab.removeResearcher();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Science getResearchScience() {
        return this.science;
    }

    @Override
    public Person getResearcher() {
        return this.person;
    }

    @Override
    public boolean hasResearchAssistant() {
        return this.researchAssistant != null;
    }

    @Override
    public Person getResearchAssistant() {
        return this.researchAssistant;
    }

    @Override
    public void setResearchAssistant(Person researchAssistant) {
        this.researchAssistant = researchAssistant;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.study = null;
        this.lab = null;
        this.science = null;
        this.malfunctions = null;
        this.researchAssistant = null;
    }
}

