/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.person.ai.task.TaskEvent;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;

public abstract class Task
implements Serializable,
Comparable<Task> {
    public static final String TASK_NAME_EVENT = "task name";
    public static final String TASK_DESC_EVENT = "task name";
    public static final String TASK_PHASE_EVENT = "task name";
    public static final String TASK_ENDED_EVENT = "task ended";
    public static final String TASK_SUBTASK_EVENT = "subtask";
    private static final double JOB_STRESS_MODIFIER = 0.5;
    private static final double SKILL_STRESS_MODIFIER = 0.1;
    private String name;
    protected Person person;
    private boolean done;
    protected boolean hasDuration;
    private double duration;
    private double timeCompleted;
    private String description;
    protected Task subTask;
    private String phase;
    protected double phaseTimeRequired;
    protected double phaseTimeCompleted;
    protected boolean effortDriven;
    private boolean createEvents;
    protected double stressModifier;
    private Person teacher;
    private Collection<String> phases;

    public Task(String name, Person person, boolean effort, boolean createEvents, double stressModifier, boolean hasDuration, double duration) {
        this.name = name;
        this.person = person;
        this.createEvents = createEvents;
        this.stressModifier = stressModifier;
        this.hasDuration = hasDuration;
        this.duration = duration;
        this.done = false;
        this.timeCompleted = 0.0;
        this.description = name;
        this.subTask = null;
        this.phase = null;
        this.effortDriven = effort;
        this.phases = new ArrayList<String>();
    }

    public void endTask() {
        this.done = true;
        this.person.fireUnitUpdate(TASK_ENDED_EVENT, this);
        if (this.createEvents) {
            TaskEvent endingEvent = new TaskEvent(this.person, this, "Task Finished", "");
            Simulation.instance().getEventManager().registerNewEvent(endingEvent);
        }
    }

    public boolean isEffortDriven() {
        return this.effortDriven;
    }

    public String getName() {
        if (this.subTask != null && !this.subTask.done) {
            return this.subTask.getName();
        }
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
        this.person.fireUnitUpdate("task name", name);
    }

    public String getDescription() {
        if (this.subTask != null && !this.subTask.done) {
            return this.subTask.getDescription();
        }
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
        this.person.fireUnitUpdate("task name", description);
    }

    public boolean getCreateEvents() {
        return this.createEvents;
    }

    public String getPhase() {
        if (this.subTask != null && !this.subTask.done) {
            return this.subTask.getPhase();
        }
        return this.phase;
    }

    public String getTopPhase() {
        return this.phase;
    }

    protected void setPhase(String newPhase) {
        if (newPhase == null) {
            throw new IllegalArgumentException("newPhase is null");
        }
        if (!this.phases.contains(newPhase)) {
            throw new IllegalStateException("newPhase: " + newPhase + " is not a valid phase for this task.");
        }
        this.phase = newPhase;
        this.person.fireUnitUpdate("task name", newPhase);
    }

    protected void addPhase(String newPhase) {
        if (newPhase == null) {
            throw new IllegalArgumentException("newPhase is null");
        }
        if (!this.phases.contains(newPhase)) {
            this.phases.add(newPhase);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    void addSubTask(Task newSubTask) {
        if (this.subTask != null) {
            this.subTask.addSubTask(newSubTask);
        } else {
            this.subTask = newSubTask;
            this.person.fireUnitUpdate(TASK_SUBTASK_EVENT, newSubTask);
        }
    }

    public Task getSubTask() {
        return this.subTask;
    }

    public static double getProbability(Person person) {
        return 0.0;
    }

    double performTask(double time) {
        double timeLeft = time;
        if (this.subTask != null) {
            if (this.subTask.done) {
                this.subTask = null;
            } else {
                timeLeft = this.subTask.performTask(timeLeft);
            }
        }
        if (this.subTask == null || this.subTask.done) {
            if (this.effortDriven && this.person.getPerformanceRating() == 0.0) {
                this.endTask();
            } else {
                while (timeLeft > 0.0 && !this.done) {
                    if (this.hasDuration) {
                        if (this.timeCompleted + timeLeft >= this.duration) {
                            double performTime = this.duration - this.timeCompleted;
                            double extraTime = this.timeCompleted + timeLeft - this.duration;
                            timeLeft = this.performMappedPhase(performTime) + extraTime;
                            this.timeCompleted = this.duration;
                            this.endTask();
                            continue;
                        }
                        double remainingTime = timeLeft;
                        timeLeft = this.performMappedPhase(timeLeft);
                        this.timeCompleted += remainingTime;
                        continue;
                    }
                    timeLeft = this.performMappedPhase(timeLeft);
                }
            }
        }
        this.modifyStress(time - timeLeft);
        return timeLeft;
    }

    protected abstract double performMappedPhase(double var1);

    protected void setCreateEvents(boolean create) {
        this.createEvents = create;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public int compareTo(Task other) {
        return this.name.compareTo(other.name);
    }

    private void modifyStress(double time) {
        PhysicalCondition condition = this.person.getPhysicalCondition();
        double effectiveStressModifier = this.stressModifier;
        if (this.stressModifier > 0.0) {
            int skill;
            Job job = this.person.getMind().getJob();
            if (job != null && job.isJobRelatedTask(this.getClass())) {
                effectiveStressModifier *= 0.5;
            }
            if ((effectiveStressModifier -= effectiveStressModifier * (double)(skill = this.getEffectiveSkillLevel()) * 0.1) < 0.0) {
                effectiveStressModifier = 0.0;
            }
        }
        condition.setStress(condition.getStress() + effectiveStressModifier * time);
    }

    protected void setStressModifier(double newStressModifier) {
        this.stressModifier = newStressModifier;
    }

    protected static double getCrowdingProbabilityModifier(Person person, Building newBuilding) {
        double modifier = 1.0;
        Building currentBuilding = BuildingManager.getBuilding(person);
        if (currentBuilding != null && newBuilding != null && currentBuilding != newBuilding) {
            LifeSupport newLS;
            int newOverCrowding;
            LifeSupport currentLS = (LifeSupport)currentBuilding.getFunction("Life Support");
            int currentOverCrowding = currentLS.getOccupantNumber() - currentLS.getOccupantCapacity();
            if (currentOverCrowding > 0) {
                modifier *= (double)currentOverCrowding + 2.0;
            }
            if ((newOverCrowding = (newLS = (LifeSupport)newBuilding.getFunction("Life Support")).getOccupantNumber() - newLS.getOccupantCapacity()) > 0) {
                modifier /= (double)newOverCrowding + 2.0;
            }
        }
        return modifier;
    }

    public abstract int getEffectiveSkillLevel();

    public abstract List<String> getAssociatedSkills();

    public boolean hasTeacher() {
        return this.teacher != null;
    }

    public Person getTeacher() {
        return this.teacher;
    }

    public void setTeacher(Person newTeacher) {
        this.teacher = newTeacher;
    }

    protected double getTeachingExperienceModifier() {
        double result = 1.0;
        if (this.hasTeacher()) {
            int teachingModifier = this.teacher.getNaturalAttributeManager().getAttribute("Teaching");
            int learningModifier = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
            result += (double)(teachingModifier + learningModifier) / 100.0;
        }
        return result;
    }

    protected static double getRelationshipModifier(Person person, Building building) {
        double result = 1.0;
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        if (person == null || building == null) {
            throw new IllegalArgumentException("Task.getRelationshipModifier(): null parameter.");
        }
        if (building.hasFunction("Life Support")) {
            LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
            double totalOpinion = 0.0;
            for (Person occupant : lifeSupport.getOccupants()) {
                if (person == occupant) continue;
                totalOpinion += (relationshipManager.getOpinionOfPerson(person, occupant) - 50.0) / 50.0;
            }
            result = totalOpinion >= 0.0 ? (result *= 1.0 + totalOpinion) : (result /= 1.0 - totalOpinion);
        }
        return result;
    }

    protected abstract void addExperience(double var1);

    protected double getDuration() {
        return this.duration;
    }

    protected void setDuration(double newDuration) {
        if (newDuration < 0.0) {
            throw new IllegalArgumentException("newDuration less than 0");
        }
        this.duration = newDuration;
    }

    protected double getTimeCompleted() {
        return this.timeCompleted;
    }

    public void destroy() {
        this.name = null;
        this.person = null;
        this.description = null;
        if (this.subTask != null) {
            this.subTask.destroy();
        }
        this.subTask = null;
        this.phase = null;
        this.teacher = null;
        this.phases.clear();
        this.phases = null;
    }
}

