/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Crop;
import org.mars_sim.msp.core.structure.building.function.Farming;

public class TendGreenhouse
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(TendGreenhouse.class.getName());
    private static final String TENDING = "Tending";
    private static final double STRESS_MODIFIER = -0.1;
    private Farming greenhouse;

    public TendGreenhouse(Person person) {
        super("Tending Greenhouse", person, false, false, -0.1, true, RandomUtil.getRandomDouble(100.0));
        if (person.getSettlement() != null) {
            this.setDescription("Tending Greenhouse at " + person.getSettlement().getName());
        } else {
            this.endTask();
        }
        Building farmBuilding = TendGreenhouse.getAvailableGreenhouse(person);
        if (farmBuilding != null) {
            this.greenhouse = (Farming)farmBuilding.getFunction("Farming");
            BuildingManager.addPersonToBuilding(person, farmBuilding);
        } else {
            this.endTask();
        }
        this.addPhase(TENDING);
        this.setPhase(TENDING);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            try {
                Building farmingBuilding = TendGreenhouse.getAvailableGreenhouse(person);
                if (farmingBuilding != null) {
                    result = 100.0;
                    int needyCropsNum = TendGreenhouse.getCropsNeedingTending(person.getSettlement());
                    result += (double)needyCropsNum * 10.0;
                    result *= Task.getCrowdingProbabilityModifier(person, farmingBuilding);
                    result *= Task.getRelationshipModifier(person, farmingBuilding);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "TendGreenhouse.getProbability(): " + e.getMessage());
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(TendGreenhouse.class);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (TENDING.equals(this.getPhase())) {
            return this.tendingPhase(time);
        }
        return time;
    }

    private double tendingPhase(double time) {
        if (this.greenhouse.getBuilding().getMalfunctionManager().hasMalfunction()) {
            this.endTask();
            return time;
        }
        double workTime = time;
        int greenhouseSkill = this.getEffectiveSkillLevel();
        workTime = greenhouseSkill == 0 ? (workTime /= 2.0) : (workTime += workTime * (double)greenhouseSkill);
        this.greenhouse.addWork(workTime);
        this.addExperience(time);
        this.checkForAccident(time);
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 100.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Botany", newPoints *= this.getTeachingExperienceModifier());
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        int skill = this.getEffectiveSkillLevel();
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.greenhouse.getBuilding().getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            this.greenhouse.getBuilding().getMalfunctionManager().accident();
        }
    }

    public Farming getGreenhouse() {
        return this.greenhouse;
    }

    private static Building getAvailableGreenhouse(Person person) {
        Building result = null;
        String location = person.getLocationSituation();
        if (location.equals("In Settlement")) {
            BuildingManager manager = person.getSettlement().getBuildingManager();
            List<Building> farmBuildings = manager.getBuildings("Farming");
            farmBuildings = BuildingManager.getNonMalfunctioningBuildings(farmBuildings);
            farmBuildings = TendGreenhouse.getFarmsNeedingWork(farmBuildings);
            if ((farmBuildings = BuildingManager.getLeastCrowdedBuildings(farmBuildings)).size() > 0) {
                Map<Building, Double> farmBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, farmBuildings);
                result = RandomUtil.getWeightedRandomObject(farmBuildingProbs);
            }
        }
        return result;
    }

    private static List<Building> getFarmsNeedingWork(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            Farming farm = (Farming)building.getFunction("Farming");
            if (!farm.requiresWork()) continue;
            result.add(building);
        }
        return result;
    }

    private static int getCropsNeedingTending(Settlement settlement) {
        int result = 0;
        BuildingManager manager = settlement.getBuildingManager();
        for (Building building : manager.getBuildings("Farming")) {
            Farming farm = (Farming)building.getFunction("Farming");
            for (Crop crop : farm.getCrops()) {
                if (!crop.requiresWork()) continue;
                ++result;
            }
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Botany");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Botany");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.greenhouse = null;
    }
}

