/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.vehicle.Towing;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class UnloadVehicleEVA
extends EVAOperation
implements Serializable {
    private static Logger logger = Logger.getLogger(UnloadVehicleEVA.class.getName());
    private static final String UNLOADING = "Unloading";
    private static double UNLOAD_RATE = 20.0;
    private Vehicle vehicle;
    private Settlement settlement;
    private Airlock airlock;

    public UnloadVehicleEVA(Person person) {
        super("Unloading vehicle EVA", person);
        VehicleMission mission;
        this.settlement = person.getSettlement();
        this.airlock = UnloadVehicleEVA.getAvailableAirlock(person);
        if (this.airlock == null) {
            this.endTask();
        }
        if ((mission = this.getMissionNeedingUnloading()) != null) {
            this.vehicle = mission.getVehicle();
        } else {
            List<Vehicle> nonMissionVehicles = UnloadVehicleEVA.getNonMissionVehiclesNeedingUnloading(this.settlement);
            if (nonMissionVehicles.size() > 0) {
                this.vehicle = nonMissionVehicles.get(RandomUtil.getRandomInt(nonMissionVehicles.size() - 1));
            }
        }
        if (this.vehicle != null) {
            this.setDescription("Unloading " + this.vehicle.getName());
            this.addPhase(UNLOADING);
        } else {
            this.endTask();
        }
    }

    public UnloadVehicleEVA(Person person, Vehicle vehicle) {
        super("Unloading vehicle EVA", person);
        this.setDescription("Unloading " + vehicle.getName());
        this.vehicle = vehicle;
        this.settlement = person.getSettlement();
        this.airlock = UnloadVehicleEVA.getAvailableAirlock(person);
        if (this.airlock == null) {
            this.endTask();
        }
        this.addPhase(UNLOADING);
    }

    public static double getProbability(Person person) {
        Settlement settlement;
        SurfaceFeatures surface;
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            try {
                int numVehicles = 0;
                numVehicles += UnloadVehicleEVA.getAllMissionsNeedingUnloading(person.getSettlement()).size();
                result = 50.0 * (double)(numVehicles += UnloadVehicleEVA.getNonMissionVehiclesNeedingUnloading(person.getSettlement()).size());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error finding unloading missions. " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        if (UnloadVehicleEVA.getAvailableAirlock(person) == null) {
            result = 0.0;
        }
        if ((surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) == 0.0 && !surface.inDarkPolarRegion(person.getCoordinates())) {
            result = 0.0;
        }
        if (person.getLocationSituation().equals("In Settlement") && (settlement = person.getSettlement()).getCurrentPopulationNum() > settlement.getPopulationCapacity()) {
            result *= 2.0;
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(UnloadVehicleEVA.class);
        }
        return result;
    }

    private static List<Vehicle> getNonMissionVehiclesNeedingUnloading(Settlement settlement) {
        ArrayList<Vehicle> result = new ArrayList<Vehicle>();
        if (settlement != null) {
            for (Vehicle vehicle : settlement.getParkedVehicles()) {
                int peopleOnboard;
                boolean needsUnloading = false;
                if (!vehicle.isReserved() && (peopleOnboard = CollectionUtils.getPerson(vehicle.getInventory().getContainedUnits()).size()) == 0 && BuildingManager.getBuilding(vehicle) == null) {
                    if (vehicle.getInventory().getTotalInventoryMass(false) > 0.0) {
                        needsUnloading = true;
                    }
                    if (vehicle instanceof Towing && ((Towing)((Object)vehicle)).getTowedVehicle() != null) {
                        needsUnloading = true;
                    }
                }
                if (!needsUnloading) continue;
                result.add(vehicle);
            }
        }
        return result;
    }

    private static List<Mission> getAllMissionsNeedingUnloading(Settlement settlement) {
        ArrayList<Mission> result = new ArrayList<Mission>();
        MissionManager manager = Simulation.instance().getMissionManager();
        for (Mission mission : manager.getMissions()) {
            int peopleOnboard;
            Vehicle vehicle;
            VehicleMission vehicleMission;
            if (!(mission instanceof VehicleMission) || !"Disembarking".equals(mission.getPhase()) || !(vehicleMission = (VehicleMission)mission).hasVehicle() || settlement != (vehicle = vehicleMission.getVehicle()).getSettlement() || (peopleOnboard = CollectionUtils.getPerson(vehicle.getInventory().getContainedUnits()).size()) != 0 || UnloadVehicleEVA.isFullyUnloaded(vehicle) || BuildingManager.getBuilding(vehicle) != null) continue;
            result.add(vehicleMission);
        }
        return result;
    }

    private VehicleMission getMissionNeedingUnloading() {
        VehicleMission result = null;
        List<Mission> unloadingMissions = UnloadVehicleEVA.getAllMissionsNeedingUnloading(this.person.getSettlement());
        if (unloadingMissions.size() > 0) {
            int index = RandomUtil.getRandomInt(unloadingMissions.size() - 1);
            result = (VehicleMission)unloadingMissions.get(index);
        }
        return result;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitEVA(time);
        }
        if (UNLOADING.equals(this.getPhase())) {
            return this.unloadingPhase(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterEVA(time);
        }
        return time;
    }

    private double exitEVA(double time) {
        try {
            time = this.exitAirlock(time, this.airlock);
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(UNLOADING);
            this.moveToUnloadingLocation();
        }
        return time;
    }

    private void moveToUnloadingLocation() {
        Point2D.Double newLocation = null;
        boolean goodLocation = false;
        for (int x = 0; x < 20 && !goodLocation; ++x) {
            Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomExteriorLocation(this.vehicle, 1.0);
            newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), this.vehicle);
            goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
        }
        this.person.setXLocation(newLocation.getX());
        this.person.setYLocation(newLocation.getY());
    }

    protected double unloadingPhase(double time) {
        Towing towingVehicle;
        Vehicle towedVehicle;
        double amountUnloading;
        this.checkForAccident(time);
        if (this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        int strength = this.person.getNaturalAttributeManager().getAttribute("Strength");
        double strengthModifier = 0.1 + (double)strength * 0.018;
        Inventory vehicleInv = this.vehicle.getInventory();
        if (this.settlement == null) {
            this.endTask();
            return 0.0;
        }
        Inventory settlementInv = this.settlement.getInventory();
        if (amountUnloading > 0.0) {
            Equipment equipment;
            Iterator<Unit> k = vehicleInv.findAllUnitsOfClass(Equipment.class).iterator();
            for (amountUnloading = UNLOAD_RATE * strengthModifier * time / 4.0; k.hasNext() && amountUnloading > 0.0; amountUnloading -= equipment.getMass()) {
                equipment = (Equipment)k.next();
                this.unloadEquipmentInventory(equipment);
                vehicleInv.retrieveUnit(equipment);
                settlementInv.storeUnit(equipment);
            }
        }
        Iterator<AmountResource> i = vehicleInv.getAllAmountResourcesStored(false).iterator();
        while (i.hasNext() && amountUnloading > 0.0) {
            double capacity;
            AmountResource resource = i.next();
            double amount = vehicleInv.getAmountResourceStored(resource, false);
            if (amount > amountUnloading) {
                amount = amountUnloading;
            }
            if ((capacity = settlementInv.getAmountResourceRemainingCapacity(resource, true, false)) < amount) {
                amount = capacity;
                amountUnloading = 0.0;
            }
            try {
                vehicleInv.retrieveAmountResource(resource, amount);
                settlementInv.storeAmountResource(resource, amount, true);
            }
            catch (Exception e) {
                // empty catch block
            }
            amountUnloading -= amount;
        }
        if (amountUnloading > 0.0) {
            Iterator<ItemResource> j = vehicleInv.getAllItemResourcesStored().iterator();
            while (j.hasNext() && amountUnloading > 0.0) {
                ItemResource resource = j.next();
                int num = vehicleInv.getItemResourceNum(resource);
                if ((double)num * resource.getMassPerItem() > amountUnloading && (num = (int)Math.round(amountUnloading / resource.getMassPerItem())) == 0) {
                    num = 1;
                }
                vehicleInv.retrieveItemResources(resource, num);
                settlementInv.storeItemResources(resource, num);
                amountUnloading -= (double)num * resource.getMassPerItem();
            }
        }
        if (this.vehicle instanceof Towing && (towedVehicle = (towingVehicle = (Towing)((Object)this.vehicle)).getTowedVehicle()) != null) {
            towingVehicle.setTowedVehicle(null);
            towedVehicle.setTowingVehicle(null);
            if (!settlementInv.containsUnit(towedVehicle)) {
                settlementInv.storeUnit(towedVehicle);
                towedVehicle.determinedSettlementParkedLocationAndFacing();
            }
        }
        if (UnloadVehicleEVA.isFullyUnloaded(this.vehicle)) {
            this.setPhase("Enter Airlock");
        }
        return 0.0;
    }

    private void unloadEquipmentInventory(Equipment equipment) {
        Inventory eInv = equipment.getInventory();
        Inventory sInv = this.settlement.getInventory();
        for (AmountResource resource : eInv.getAllAmountResourcesStored(false)) {
            double capacity;
            double amount = eInv.getAmountResourceStored(resource, false);
            if (amount < (capacity = sInv.getAmountResourceRemainingCapacity(resource, true, false))) {
                amount = capacity;
            }
            try {
                eInv.retrieveAmountResource(resource, amount);
                sInv.storeAmountResource(resource, amount, true);
            }
            catch (Exception e) {}
        }
    }

    public static boolean isFullyUnloaded(Vehicle vehicle) {
        return vehicle.getInventory().getTotalInventoryMass(false) == 0.0;
    }

    private double enterEVA(double time) {
        time = this.enterAirlock(time, this.airlock);
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
        }
        return time;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        return EVAOperationsSkill;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        return results;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
    }

    @Override
    public void destroy() {
        super.destroy();
        this.vehicle = null;
        this.settlement = null;
        this.airlock = null;
    }
}

