/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Exercise;

public class Workout
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(Workout.class.getName());
    private static final String EXERCISING = "Exercising";
    private static final double STRESS_MODIFIER = -1.0;
    private Exercise gym;

    public Workout(Person person) {
        super("Exercise", person, true, false, -1.0, true, 50.0 + (double)RandomUtil.getRandomInt(100));
        if (person.getLocationSituation().equals("In Settlement")) {
            Building gymBuilding = Workout.getAvailableGym(person);
            if (gymBuilding != null) {
                BuildingManager.addPersonToBuilding(person, gymBuilding);
                this.gym = (Exercise)gymBuilding.getFunction("Exercise");
            } else {
                this.endTask();
            }
        } else {
            this.endTask();
        }
        this.addPhase(EXERCISING);
        this.setPhase(EXERCISING);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            Building building;
            PhysicalCondition condition = person.getPhysicalCondition();
            result = condition.getStress() - condition.getFatigue() / 10.0 + 20.0;
            if (result < 0.0) {
                result = 0.0;
            }
            if ((building = Workout.getAvailableGym(person)) != null) {
                result *= Task.getCrowdingProbabilityModifier(person, building);
                result *= Task.getRelationshipModifier(person, building);
            } else {
                result = 0.0;
            }
        }
        return result *= person.getPerformanceRating();
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (EXERCISING.equals(this.getPhase())) {
            return this.exercisingPhase(time);
        }
        return time;
    }

    private double exercisingPhase(double time) {
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
    }

    @Override
    public void endTask() {
        super.endTask();
        if (this.gym != null && this.gym.getNumExercisers() > 0) {
            this.gym.removeExerciser();
        }
    }

    private static Building getAvailableGym(Person person) {
        Building result = null;
        if (person.getLocationSituation().equals("In Settlement")) {
            BuildingManager buildingManager = person.getSettlement().getBuildingManager();
            List<Building> gyms = buildingManager.getBuildings("Exercise");
            gyms = BuildingManager.getNonMalfunctioningBuildings(gyms);
            if ((gyms = BuildingManager.getLeastCrowdedBuildings(gyms)).size() > 0) {
                Map<Building, Double> gymProbs = BuildingManager.getBestRelationshipBuildings(person, gyms);
                result = RandomUtil.getWeightedRandomObject(gymProbs);
            }
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        return 0;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(0);
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.gym = null;
    }
}

