/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.medical.Medication;

public class AntiStressMedication
extends Medication
implements Serializable {
    public static final String NAME = "anti-stress medication";
    private static final double STRESS_REDUCTION = -1.0;
    private static final double DURATION = 200.0;

    public AntiStressMedication(Person person) {
        super(NAME, 200.0, person);
    }

    @Override
    public void timePassing(double time) {
        super.timePassing(time);
        PhysicalCondition condition = this.getPerson().getPhysicalCondition();
        condition.setStress(condition.getStress() + -1.0 * time);
    }
}

