/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;
import org.mars_sim.msp.core.person.medical.Treatment;

public class Complaint
implements Serializable {
    public static final double MAXPROBABILITY = 10000.0;
    private String name;
    private int seriousness;
    private double degradePeriod;
    private double recoveryPeriod;
    private double probability;
    private double performanceFactor;
    private Treatment recoveryTreatment;
    Complaint nextPhase;
    String nextPhaseStr;

    Complaint(String name, int seriousness, double degrade, double recovery, double probability, double performance, Treatment recoveryTreatment, Complaint next) {
        this.name = name;
        this.seriousness = seriousness;
        this.degradePeriod = degrade;
        this.recoveryPeriod = recovery;
        this.performanceFactor = performance / 100.0;
        this.nextPhase = next;
        this.nextPhaseStr = "";
        if (next != null) {
            this.nextPhaseStr = next.name;
        }
        this.probability = probability;
        this.recoveryTreatment = recoveryTreatment;
    }

    Complaint(String name, int seriousness, double degrade, double recovery, double probability, Treatment recoveryTreatment, String nextStr, double performance) {
        this.name = name;
        this.seriousness = seriousness;
        this.degradePeriod = degrade;
        this.recoveryPeriod = recovery;
        this.performanceFactor = performance / 100.0;
        this.probability = probability;
        this.recoveryTreatment = recoveryTreatment;
        this.nextPhaseStr = nextStr;
    }

    void setNextComplaint(Complaint nextComplaint) {
        this.nextPhase = nextComplaint;
    }

    public double getDegradePeriod() {
        return this.degradePeriod;
    }

    public String getName() {
        return this.name;
    }

    public Complaint getNextPhase() {
        return this.nextPhase;
    }

    String getNextPhaseStr() {
        return this.nextPhaseStr;
    }

    public double getPerformanceFactor() {
        return this.performanceFactor;
    }

    public double getProbability() {
        return this.probability;
    }

    public Treatment getRecoveryTreatment() {
        return this.recoveryTreatment;
    }

    public double getRecoveryPeriod() {
        return this.recoveryPeriod;
    }

    public int getSeriousness() {
        return this.seriousness;
    }

    public String toString() {
        return this.name;
    }
}

