/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.medical.Complaint;
import org.mars_sim.msp.core.person.medical.MedicalConfig;
import org.mars_sim.msp.core.person.medical.Treatment;

public class MedicalManager
implements Serializable {
    public static final int MINSPERDAY = 1440;
    private HashMap<String, Complaint> complaints = new HashMap();
    private HashMap<String, Treatment> treatments = new HashMap();
    private HashMap<Integer, List<Treatment>> supported = new HashMap();
    private Complaint starvation;
    private Complaint suffocation;
    private Complaint dehydration;
    private Complaint decompression;
    private Complaint freezing;
    private Complaint heatStroke;
    public static final String SUFFOCATION = "Suffocation";
    public static final String DEHYDRATION = "Dehydration";
    public static final String STARVATION = "Starvation";
    public static final String DECOMPRESSION = "Decompression";
    public static final String FREEZING = "Freezing";
    public static final String HEAT_STROKE = "Heat Stroke";

    public MedicalManager() {
        this.initMedical();
    }

    public void initMedical() {
        SimulationConfig simConfig = SimulationConfig.instance();
        PersonConfig personConfig = simConfig.getPersonConfiguration();
        MedicalConfig medicalConfig = simConfig.getMedicalConfiguration();
        this.starvation = this.createEnvironmentComplaint(STARVATION, 70, (personConfig.getFoodDeprivationTime() - personConfig.getStarvationStartTime()) * 1000.0, 80);
        this.suffocation = this.createEnvironmentComplaint(SUFFOCATION, 100, personConfig.getOxygenDeprivationTime(), 25);
        this.dehydration = this.createEnvironmentComplaint(DEHYDRATION, 60, personConfig.getWaterDeprivationTime() * 1000.0, 70);
        this.decompression = this.createEnvironmentComplaint(DECOMPRESSION, 100, personConfig.getDecompressionTime(), 10);
        this.freezing = this.createEnvironmentComplaint(FREEZING, 80, personConfig.getFreezingTime(), 40);
        this.heatStroke = this.createEnvironmentComplaint(HEAT_STROKE, 80, 100.0, 40);
        Iterator<Treatment> i = medicalConfig.getTreatmentList().iterator();
        while (i.hasNext()) {
            this.addTreatment(i.next());
        }
        Iterator<Complaint> j = medicalConfig.getComplaintList().iterator();
        while (j.hasNext()) {
            this.addComplaint(j.next());
        }
    }

    private Complaint createEnvironmentComplaint(String name, int seriousness, double degrade, int performance) {
        return new Complaint(name, seriousness, degrade, 0.0, 0.0, performance, null, null);
    }

    void createComplaint(String name, int seriousness, double degrade, double recovery, double probability, int performance, Treatment recoveryTreatment, Complaint next) {
        Complaint complaint = new Complaint(name, seriousness, degrade, recovery, probability, performance, recoveryTreatment, next);
        this.complaints.put(name, complaint);
    }

    void addComplaint(Complaint newComplaint) {
        if (this.complaints.containsKey(newComplaint.getName())) {
            throw new IllegalStateException("Complaint " + newComplaint.getName() + " already exists in map.");
        }
        this.complaints.put(newComplaint.getName(), newComplaint);
    }

    void createTreatment(String name, int skill, double duration, boolean selfHeal, boolean retainAid, int level) {
        Treatment newTreatment = new Treatment(name, skill, duration, selfHeal, retainAid, level);
        this.treatments.put(name, newTreatment);
    }

    void addTreatment(Treatment newTreatment) {
        if (this.treatments.containsKey(newTreatment.getName())) {
            throw new IllegalStateException("Treatment " + newTreatment.getName() + " already exists in map.");
        }
        this.treatments.put(newTreatment.getName(), newTreatment);
    }

    public Complaint getProbableComplaint(Person person, double time) {
        Complaint complaint = null;
        double r = RandomUtil.getRandomDouble(10000.0);
        r *= 1000.0 / time;
        ArrayList<Complaint> possibles = null;
        for (Complaint next : this.complaints.values()) {
            if (!(next.getProbability() > r)) continue;
            if (possibles == null) {
                possibles = new ArrayList<Complaint>();
            }
            possibles.add(next);
        }
        if (possibles != null) {
            int index = RandomUtil.getRandomInt(possibles.size() - 1);
            complaint = (Complaint)possibles.get(index);
        }
        return complaint;
    }

    public Complaint getComplaintByName(String name) {
        return this.complaints.get(name);
    }

    public Treatment getTreatmentByName(String name) {
        return this.treatments.get(name);
    }

    public Complaint getSuffocation() {
        return this.suffocation;
    }

    public List<Treatment> getSupportedTreatments(int level) {
        Integer key = level;
        List<Treatment> results = this.supported.get(key);
        if (results == null) {
            results = new ArrayList<Treatment>();
            for (Treatment next : this.treatments.values()) {
                if (next.getFacilityLevel() > level) continue;
                results.add(next);
            }
            Collections.sort(results);
            this.supported.put(key, results);
        }
        return results;
    }

    public Complaint getDehydration() {
        return this.dehydration;
    }

    public Complaint getStarvation() {
        return this.starvation;
    }

    public Complaint getDecompression() {
        return this.decompression;
    }

    public Complaint getFreezing() {
        return this.freezing;
    }

    public Complaint getHeatStroke() {
        return this.heatStroke;
    }

    public boolean isEnvironmentalComplaint(Complaint complaint) {
        boolean result = false;
        if (complaint == this.suffocation) {
            result = true;
        }
        if (complaint == this.dehydration) {
            result = true;
        }
        if (complaint == this.starvation) {
            result = true;
        }
        if (complaint == this.decompression) {
            result = true;
        }
        if (complaint == this.freezing) {
            result = true;
        }
        if (complaint == this.heatStroke) {
            result = true;
        }
        return result;
    }

    public void destroy() {
        this.complaints.clear();
        this.complaints = null;
        this.treatments.clear();
        this.treatments = null;
        this.supported.clear();
        this.supported = null;
        this.starvation = null;
        this.suffocation = null;
        this.dehydration = null;
        this.decompression = null;
        this.freezing = null;
        this.heatStroke = null;
    }
}

