/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;

public class Treatment
implements Serializable,
Comparable<Treatment> {
    private String name;
    private int requiredSkill;
    private int facilityLevel;
    private double duration;
    private boolean retainAid;
    private boolean selfAdmin;

    public Treatment(String name, int skill, double duration, boolean selfAdmin, boolean retainAid, int facilityLevel) {
        this.name = name;
        this.requiredSkill = skill;
        this.selfAdmin = selfAdmin;
        this.retainAid = retainAid;
        this.facilityLevel = facilityLevel;
        if (duration < 0.0) {
            duration = -1.0;
        } else {
            this.duration = duration;
        }
    }

    @Override
    public int compareTo(Treatment otherTreatment) {
        return this.name.compareTo(otherTreatment.name);
    }

    public boolean equals(Object other) {
        boolean match = false;
        if (other instanceof Treatment) {
            match = this.name.equals(((Treatment)other).name);
        }
        return match;
    }

    public double getAdjustedDuration(int skill) {
        double result = this.duration;
        if (result > 0.0 && skill < this.requiredSkill) {
            result = this.duration * (double)(1 + (this.requiredSkill - skill) / this.requiredSkill);
        }
        return result;
    }

    public double getDuration() {
        return this.duration;
    }

    public int getFacilityLevel() {
        return this.facilityLevel;
    }

    public String getName() {
        return this.name;
    }

    public boolean getRetainAid() {
        return this.retainAid;
    }

    public int getSkill() {
        return this.requiredSkill;
    }

    public boolean getSelfAdminister() {
        return this.selfAdmin;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

