/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.resource.AmountResourceConfig;
import org.mars_sim.msp.core.resource.Phase;
import org.mars_sim.msp.core.resource.Resource;

public final class AmountResource
implements Resource,
Serializable {
    private String name;
    private Phase phase;
    private boolean lifeSupport;
    private int hashcode = -1;

    private AmountResource() {
    }

    public AmountResource(String name, Phase phase, boolean lifeSupport) {
        this.name = name;
        this.phase = phase;
        this.lifeSupport = lifeSupport;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public boolean isLifeSupport() {
        return this.lifeSupport;
    }

    public static AmountResource findAmountResource(String name) {
        AmountResource result = null;
        for (AmountResource resource : AmountResource.getAmountResources()) {
            if (!resource.name.equalsIgnoreCase(name)) continue;
            result = resource;
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Resource: " + name + " could not be found.");
    }

    public static Set<AmountResource> getAmountResources() {
        SimulationConfig simulationConfig = SimulationConfig.instance();
        AmountResourceConfig resourceConfiguration = simulationConfig.getResourceConfiguration();
        Set<AmountResource> amountResources = resourceConfiguration.getAmountResources();
        return Collections.unmodifiableSet(amountResources);
    }

    public boolean equals(Object object) {
        if (object instanceof AmountResource) {
            AmountResource otherObject = (AmountResource)object;
            if (this.name.equals(otherObject.name) && this.phase.equals(otherObject.phase)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = this.name.hashCode() * this.phase.hashCode();
        }
        return this.hashcode;
    }

    @Override
    public int compareTo(Resource o) {
        return this.name.compareTo(o.getName());
    }
}

