/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Phase;

public class AmountResourceConfig
implements Serializable {
    private static final String RESOURCE = "resource";
    private static final String NAME = "name";
    private static final String PHASE = "phase";
    private static final String LIFE_SUPPORT = "life-support";
    private Set<AmountResource> resources = new HashSet<AmountResource>();

    public AmountResourceConfig(Document amountResourceDoc) {
        this.loadAmountResources(amountResourceDoc);
    }

    private void loadAmountResources(Document amountResourceDoc) {
        Element root = amountResourceDoc.getRootElement();
        List resourceNodes = root.getChildren(RESOURCE);
        for (Element resourceElement : resourceNodes) {
            String name = "";
            name = resourceElement.getAttributeValue(NAME);
            String phaseString = resourceElement.getAttributeValue(PHASE);
            Phase phase = Phase.findPhase(phaseString);
            Boolean lifeSupport = Boolean.parseBoolean(resourceElement.getAttributeValue(LIFE_SUPPORT));
            AmountResource resource = new AmountResource(name, phase, lifeSupport);
            this.resources.add(resource);
        }
    }

    public Set<AmountResource> getAmountResources() {
        return this.resources;
    }
}

